/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.enterprise.auth.oidc;

import com.floragunn.codova.config.net.ProxyConfig;
import com.floragunn.codova.config.net.TLSConfig;
import com.floragunn.searchguard.authc.AuthenticatorUnavailableException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedActionException;
import org.apache.cxf.rs.security.jose.jwk.JsonWebKeys;
import org.apache.cxf.rs.security.jose.jwk.JwkUtils;
import org.apache.http.HttpEntity;
import org.apache.http.StatusLine;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.elasticsearch.SpecialPermission;

public class JwksProviderClient {
    private final TLSConfig tlsConfig;
    private final ProxyConfig proxyConfig;
    private int requestTimeoutMs = 10000;

    public JwksProviderClient(TLSConfig tlsConfig, ProxyConfig proxyConfig) {
        this.tlsConfig = tlsConfig;
        this.proxyConfig = proxyConfig;
    }

    public JsonWebKeys getJsonWebKeys(URI uri) throws AuthenticatorUnavailableException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission((Permission)new SpecialPermission());
        }
        try {
            return AccessController.doPrivileged(() -> this.getJsonWebKeysPrivileged(uri));
        }
        catch (PrivilegedActionException e) {
            if (e.getCause() instanceof AuthenticatorUnavailableException) {
                throw (AuthenticatorUnavailableException)e.getCause();
            }
            if (e.getCause() instanceof RuntimeException) {
                throw (RuntimeException)e.getCause();
            }
            throw new RuntimeException(e.getCause());
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private JsonWebKeys getJsonWebKeysPrivileged(URI uri) throws AuthenticatorUnavailableException {
        try (CloseableHttpClient httpClient = this.createHttpClient();){
            JsonWebKeys jsonWebKeys;
            block16: {
                HttpGet httpGet = new HttpGet(uri);
                RequestConfig requestConfig = RequestConfig.custom().setConnectionRequestTimeout(this.getRequestTimeoutMs()).setConnectTimeout(this.getRequestTimeoutMs()).setSocketTimeout(this.getRequestTimeoutMs()).build();
                httpGet.setConfig(requestConfig);
                CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpGet);
                try {
                    JsonWebKeys keySet;
                    StatusLine statusLine = response.getStatusLine();
                    if (statusLine.getStatusCode() < 200 || statusLine.getStatusCode() >= 300) {
                        throw new AuthenticatorUnavailableException("Error while retrieving JWKS OIDC config", String.valueOf(statusLine) + (String)(response.getEntity() != null ? "\n" + EntityUtils.toString((HttpEntity)response.getEntity()) : "")).details("jwks_uri", (Object)uri, new Object[0]);
                    }
                    HttpEntity httpEntity = response.getEntity();
                    if (httpEntity == null) {
                        throw new AuthenticatorUnavailableException("Error while retrieving JWKS OIDC config", "Empty response").details("jwks_uri", (Object)uri, new Object[0]);
                    }
                    jsonWebKeys = keySet = JwkUtils.readJwkSet((InputStream)httpEntity.getContent());
                    if (response == null) break block16;
                }
                catch (Throwable throwable) {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                response.close();
            }
            return jsonWebKeys;
        }
        catch (IOException e) {
            throw new AuthenticatorUnavailableException("Error while retrieving JWKS OIDC config", (Throwable)e).details("jwks_uri", (Object)uri, new Object[0]);
        }
    }

    private CloseableHttpClient createHttpClient() {
        HttpClientBuilder builder = HttpClients.custom();
        if (this.proxyConfig != null) {
            this.proxyConfig.apply(builder);
        }
        builder.useSystemProperties();
        if (this.tlsConfig != null) {
            builder.setSSLSocketFactory((LayeredConnectionSocketFactory)this.tlsConfig.toSSLConnectionSocketFactory());
        }
        return builder.build();
    }

    public int getRequestTimeoutMs() {
        return this.requestTimeoutMs;
    }

    public void setRequestTimeoutMs(int requestTimeoutMs) {
        this.requestTimeoutMs = requestTimeoutMs;
    }
}

