/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.enterprise.auth.oidc;

import com.floragunn.codova.documents.DocNode;
import com.floragunn.codova.documents.Document;
import com.floragunn.codova.validation.ValidatingDocNode;
import com.floragunn.codova.validation.ValidationErrors;
import com.floragunn.codova.validation.ValidationResult;
import java.net.URI;
import java.util.Map;

public class OidcProviderConfig
implements Document<OidcProviderConfig> {
    private final DocNode source;
    private final URI jwksUri;
    private final URI tokenEndpoint;
    private final URI authorizationEndpoint;
    private final URI endSessionEndpoint;
    private final URI userinfoEndpoint;

    public OidcProviderConfig(DocNode source, URI jwksUri, URI tokenEndpoint, URI authorizationEndpoint, URI endSessionEndpoint, URI userinfoEndpoint) {
        this.source = source;
        this.jwksUri = jwksUri;
        this.tokenEndpoint = tokenEndpoint;
        this.authorizationEndpoint = authorizationEndpoint;
        this.endSessionEndpoint = endSessionEndpoint;
        this.userinfoEndpoint = userinfoEndpoint;
    }

    public URI getJwksUri() {
        return this.jwksUri;
    }

    public URI getTokenEndpoint() {
        return this.tokenEndpoint;
    }

    public URI getAuthorizationEndpoint() {
        return this.authorizationEndpoint;
    }

    public URI getEndSessionEndpoint() {
        return this.endSessionEndpoint;
    }

    public URI getUserinfoEndpoint() {
        return this.userinfoEndpoint;
    }

    public static ValidationResult<OidcProviderConfig> parse(DocNode docNode) {
        ValidationErrors validationErrors = new ValidationErrors();
        ValidatingDocNode vNode = new ValidatingDocNode(docNode, validationErrors);
        URI jwksUri = vNode.get("jwks_uri").asAbsoluteURI();
        URI tokenEndpoint = vNode.get("token_endpoint").asAbsoluteURI();
        URI authorizationEndpoint = vNode.get("authorization_endpoint").asAbsoluteURI();
        URI endSessionEndpoint = vNode.get("end_session_endpoint").asAbsoluteURI();
        URI userinfoEndpoint = vNode.get("userinfo_endpoint").asAbsoluteURI();
        return new ValidationResult((Object)new OidcProviderConfig(docNode, jwksUri, tokenEndpoint, authorizationEndpoint, endSessionEndpoint, userinfoEndpoint), validationErrors);
    }

    public Map<String, Object> toBasicObject() {
        return this.source;
    }
}

