/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.enterprise.dlsfls;

import com.floragunn.fluent.collections.ImmutableList;
import com.floragunn.fluent.collections.ImmutableSet;
import com.floragunn.searchguard.BaseDependencies;
import com.floragunn.searchguard.SearchGuardModule;
import com.floragunn.searchguard.authz.SyncAuthorizationFilter;
import com.floragunn.searchguard.configuration.CType;
import com.floragunn.searchguard.enterprise.dlsfls.DlsFlsBaseContext;
import com.floragunn.searchguard.enterprise.dlsfls.DlsFlsConfig;
import com.floragunn.searchguard.enterprise.dlsfls.DlsFlsConfigApi;
import com.floragunn.searchguard.enterprise.dlsfls.DlsFlsLicenseInfo;
import com.floragunn.searchguard.enterprise.dlsfls.DlsFlsProcessedConfig;
import com.floragunn.searchguard.enterprise.dlsfls.DlsFlsSearchOperationListener;
import com.floragunn.searchguard.enterprise.dlsfls.DlsFlsValve;
import com.floragunn.searchguard.enterprise.dlsfls.FlsFieldFilter;
import com.floragunn.searchguard.enterprise.dlsfls.FlsQueryCacheWeightProvider;
import com.floragunn.searchguard.enterprise.dlsfls.lucene.DlsFlsDirectoryReaderWrapper;
import com.floragunn.searchguard.license.SearchGuardLicense;
import com.floragunn.searchsupport.StaticSettings;
import com.floragunn.searchsupport.cstate.ComponentState;
import com.floragunn.searchsupport.cstate.ComponentStateProvider;
import com.floragunn.searchsupport.cstate.metrics.Measurement;
import com.floragunn.searchsupport.cstate.metrics.TimeAggregation;
import com.floragunn.searchsupport.meta.Meta;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.index.DirectoryReader;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.IndexScopedSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.SettingsFilter;
import org.elasticsearch.core.CheckedFunction;
import org.elasticsearch.features.NodeFeature;
import org.elasticsearch.index.IndexService;
import org.elasticsearch.index.shard.SearchOperationListener;
import org.elasticsearch.plugins.ActionPlugin;
import org.elasticsearch.plugins.FieldPredicate;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.threadpool.ThreadPool;

public class DlsFlsModule
implements SearchGuardModule,
ComponentStateProvider {
    private static final Logger log = LogManager.getLogger(DlsFlsModule.class);
    private static final CType<DlsFlsConfig> TYPE = DlsFlsConfig.TYPE;
    static final StaticSettings.Attribute<Boolean> PROVIDE_THREAD_CONTEXT_AUTHZ_HASH = StaticSettings.Attribute.define((String)"searchguard.dls_fls.provide_thread_context_authz_hash").withDefault(false).asBoolean();
    private final ComponentState componentState = new ComponentState(1000, null, "dlsfls", DlsFlsModule.class).requiresEnterpriseLicense();
    private final ComponentState directoryReaderWrapperComponentState = new ComponentState(10, null, "directory_reader_wrapper", DlsFlsDirectoryReaderWrapper.class).initialized();
    private final TimeAggregation directoryReaderWrapperApplyAggregation = new TimeAggregation.Nanoseconds();
    private DlsFlsBaseContext dlsFlsBaseContext;
    private DlsFlsValve dlsFlsValve;
    private DlsFlsSearchOperationListener dlsFlsSearchOperationListener;
    private FlsFieldFilter flsFieldFilter;
    private AtomicReference<DlsFlsProcessedConfig> config = new AtomicReference<DlsFlsProcessedConfig>(DlsFlsProcessedConfig.DEFAULT);
    private AtomicReference<DlsFlsLicenseInfo> licenseInfo = new AtomicReference<DlsFlsLicenseInfo>(new DlsFlsLicenseInfo(false));
    private FlsQueryCacheWeightProvider flsQueryCacheWeightProvider;
    private ClusterService clusterService;
    private Function<IndexService, CheckedFunction<DirectoryReader, DirectoryReader, IOException>> directoryReaderWrapperFactory;
    private ThreadPool threadPool;

    public DlsFlsModule() {
        this.componentState.addPart(this.directoryReaderWrapperComponentState);
        this.directoryReaderWrapperComponentState.addMetrics("wrap_reader", (Measurement)this.directoryReaderWrapperApplyAggregation);
    }

    public Collection<Object> createComponents(BaseDependencies baseDependencies) {
        this.clusterService = baseDependencies.getClusterService();
        Supplier<Meta> metaSupplier = () -> Meta.from((ClusterService)baseDependencies.getClusterService());
        this.dlsFlsBaseContext = new DlsFlsBaseContext(baseDependencies.getAuthInfoService(), baseDependencies.getAuthorizationService(), baseDependencies.getThreadPool().getThreadContext(), metaSupplier);
        this.dlsFlsValve = new DlsFlsValve(baseDependencies.getLocalClient(), baseDependencies.getClusterService(), baseDependencies.getIndexNameExpressionResolver(), baseDependencies.getGuiceDependencies(), baseDependencies.getThreadPool().getThreadContext(), this.config, baseDependencies.getStaticSettings());
        this.dlsFlsSearchOperationListener = new DlsFlsSearchOperationListener(this.dlsFlsBaseContext, this.config);
        this.flsFieldFilter = new FlsFieldFilter(this.dlsFlsBaseContext, this.config);
        this.flsQueryCacheWeightProvider = new FlsQueryCacheWeightProvider(this.dlsFlsBaseContext, this.config);
        this.directoryReaderWrapperFactory = indexService -> new DlsFlsDirectoryReaderWrapper((IndexService)indexService, baseDependencies.getAuditLog(), this.dlsFlsBaseContext, this.config, this.licenseInfo, this.directoryReaderWrapperComponentState, this.directoryReaderWrapperApplyAggregation);
        this.componentState.addParts(new ComponentState[]{this.dlsFlsValve.getComponentState(), this.dlsFlsSearchOperationListener.getComponentState(), this.flsFieldFilter.getComponentState(), this.flsQueryCacheWeightProvider.getComponentState()});
        this.threadPool = baseDependencies.getThreadPool();
        baseDependencies.getConfigurationRepository().subscribeOnChange(configMap -> {
            DlsFlsProcessedConfig config = DlsFlsProcessedConfig.createFrom(configMap, this.componentState, Meta.from((ClusterService)this.clusterService));
            DlsFlsProcessedConfig oldConfig = this.config.getAndSet(config);
            if (oldConfig != null) {
                oldConfig.shutdown();
            }
        });
        baseDependencies.getLicenseRepository().subscribeOnLicenseChange(license -> this.licenseInfo.set(new DlsFlsLicenseInfo(license.hasFeature(SearchGuardLicense.Feature.COMPLIANCE))));
        this.clusterService.addListener(new ClusterStateListener(){

            public void clusterChanged(ClusterChangedEvent event) {
                DlsFlsProcessedConfig config = DlsFlsModule.this.config.get();
                config.updateIndicesAsync(DlsFlsModule.this.clusterService, DlsFlsModule.this.threadPool);
            }
        });
        return ImmutableList.empty();
    }

    public ImmutableList<Function<IndexService, CheckedFunction<DirectoryReader, DirectoryReader, IOException>>> getDirectoryReaderWrappersForNormalOperations() {
        return ImmutableList.of(this.directoryReaderWrapperFactory);
    }

    public ImmutableList<SearchOperationListener> getSearchOperationListeners() {
        return ImmutableList.of((Object)this.dlsFlsSearchOperationListener);
    }

    public ImmutableList<SyncAuthorizationFilter> getSyncAuthorizationFilters() {
        return ImmutableList.of((Object)this.dlsFlsValve);
    }

    public ImmutableList<Function<String, FieldPredicate>> getFieldFilters() {
        return ImmutableList.of((Object)this.flsFieldFilter);
    }

    public ImmutableList<SearchGuardModule.QueryCacheWeightProvider> getQueryCacheWeightProviders() {
        return ImmutableList.of((Object)this.flsQueryCacheWeightProvider);
    }

    public ComponentState getComponentState() {
        return this.componentState;
    }

    public ImmutableSet<String> getCapabilities() {
        return ImmutableSet.of((Object)"dls", (Object[])new String[]{"fls", "field_masking"});
    }

    public List<RestHandler> getRestHandlers(Settings settings, RestController restController, ClusterSettings clusterSettings, IndexScopedSettings indexScopedSettings, SettingsFilter settingsFilter, IndexNameExpressionResolver indexNameExpressionResolver, ScriptService scriptService, Supplier<DiscoveryNodes> nodesInCluster, Predicate<NodeFeature> clusterSupportsFeature) {
        return ImmutableList.of((Object)DlsFlsConfigApi.REST_API);
    }

    public List<ActionPlugin.ActionHandler<? extends ActionRequest, ? extends ActionResponse>> getActions() {
        return DlsFlsConfigApi.ACTION_HANDLERS;
    }

    public StaticSettings.AttributeSet getSettings() {
        return StaticSettings.AttributeSet.of((StaticSettings.Attribute[])new StaticSettings.Attribute[]{PROVIDE_THREAD_CONTEXT_AUTHZ_HASH});
    }
}

