/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.storage.annotation;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.time.Instant;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import org.opensaml.storage.annotation.Context;
import org.opensaml.storage.annotation.Expiration;
import org.opensaml.storage.annotation.Key;
import org.opensaml.storage.annotation.Value;

public final class AnnotationSupport {
    private static final Map<String, Field> FIELD_CACHE = new ConcurrentHashMap<String, Field>();

    private AnnotationSupport() {
    }

    @Nonnull
    @NotEmpty
    public static String getContext(@Nonnull Object target) {
        Context ctxField = AnnotationSupport.getAnnotation(target, Context.class);
        Object value = AnnotationSupport.getFieldValue(target, ctxField.value());
        if (value instanceof String) {
            return (String)value;
        }
        return value.toString();
    }

    public static void setContext(@Nonnull Object target, @Nonnull @NotEmpty String context) {
        Context ctxField = AnnotationSupport.getAnnotation(target, Context.class);
        AnnotationSupport.setFieldValue(target, ctxField.value(), context);
    }

    @Nonnull
    @NotEmpty
    public static String getKey(@Nonnull Object target) {
        Key keyField = AnnotationSupport.getAnnotation(target, Key.class);
        Object value = AnnotationSupport.getFieldValue(target, keyField.value());
        if (value instanceof String) {
            return (String)value;
        }
        return value.toString();
    }

    public static void setKey(@Nonnull Object target, @Nonnull @NotEmpty String key) {
        Key keyField = AnnotationSupport.getAnnotation(target, Key.class);
        AnnotationSupport.setFieldValue(target, keyField.value(), key);
    }

    @Nonnull
    @NotEmpty
    public static String getValue(@Nonnull Object target) {
        Value valueField = AnnotationSupport.getAnnotation(target, Value.class);
        Object value = AnnotationSupport.getFieldValue(target, valueField.value());
        if (value instanceof String) {
            return (String)value;
        }
        return value.toString();
    }

    public static void setValue(@Nonnull Object target, @Nonnull @NotEmpty String value) {
        Value valueField = AnnotationSupport.getAnnotation(target, Value.class);
        AnnotationSupport.setFieldValue(target, valueField.value(), value);
    }

    @Nullable
    public static Long getExpiration(@Nonnull Object target) {
        Expiration expField = AnnotationSupport.getAnnotation(target, Expiration.class);
        Object value = AnnotationSupport.getFieldValue(target, expField.value());
        if (value == null) {
            return null;
        }
        if (value instanceof Long) {
            return (Long)value;
        }
        if (value instanceof Date) {
            return ((Date)value).getTime();
        }
        if (value instanceof Instant) {
            return ((Instant)value).toEpochMilli();
        }
        throw new RuntimeException(value + " is an unsupported data type for an expiration field.");
    }

    public static void setExpiration(@Nonnull Object target, @Nullable Long expiration) {
        Class<?> type;
        Expiration expField = AnnotationSupport.getAnnotation(target, Expiration.class);
        if (expiration == null) {
            AnnotationSupport.setFieldValue(target, expField.value(), null);
        }
        if (Long.class.isAssignableFrom(type = AnnotationSupport.getField(target, expField.value()).getType())) {
            AnnotationSupport.setFieldValue(target, expField.value(), expiration);
        } else if (Date.class.isAssignableFrom(type)) {
            AnnotationSupport.setFieldValue(target, expField.value(), new Date(expiration));
        } else if (Instant.class.isAssignableFrom(type)) {
            AnnotationSupport.setFieldValue(target, expField.value(), Instant.ofEpochMilli(expiration));
        } else {
            throw new RuntimeException(type + " is an unsupported data type for an expiration field.");
        }
    }

    @Nonnull
    private static <T extends Annotation> T getAnnotation(@Nonnull Object target, @Nonnull Class<T> annotationType) {
        Class<?> targetClass = target.getClass();
        T keyField = targetClass.getAnnotation(annotationType);
        if (keyField == null) {
            throw new IllegalArgumentException("Key annotation not found on " + target);
        }
        return keyField;
    }

    @Nullable
    private static Object getFieldValue(@Nonnull Object target, @Nonnull String fieldName) {
        try {
            return AnnotationSupport.getField(target, fieldName).get(target);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Field " + fieldName + " cannot be read on " + target);
        }
    }

    private static void setFieldValue(@Nonnull Object target, @Nonnull String fieldName, @Nullable Object fieldValue) {
        try {
            AnnotationSupport.getField(target, fieldName).set(target, fieldValue);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Field " + fieldName + " cannot be set on " + target);
        }
    }

    @Nonnull
    private static Field getField(@Nonnull Object target, @Nonnull String fieldName) {
        Class<?> targetClass = target.getClass();
        String key = targetClass.getName() + "." + fieldName;
        Field field = FIELD_CACHE.get(key);
        if (field == null) {
            try {
                field = targetClass.getDeclaredField(fieldName);
                if (!field.canAccess(target) && !field.trySetAccessible()) {
                    throw new IllegalStateException("Field " + field + " is not accessible and cannot be mutated");
                }
                FIELD_CACHE.put(key, field);
            }
            catch (NoSuchFieldException e) {
                throw new RuntimeException("Field " + fieldName + " does not exist on " + target);
            }
        }
        return field;
    }
}

