/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchsupport.jobs.actions;

import com.floragunn.searchsupport.jobs.actions.SchedulerConfigUpdateRequest;
import com.floragunn.searchsupport.jobs.actions.SchedulerConfigUpdateResponse;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.client.internal.Client;

public class SchedulerConfigUpdateAction
extends ActionType<SchedulerConfigUpdateResponse> {
    private static final Logger log = LogManager.getLogger(SchedulerConfigUpdateAction.class);
    public static final SchedulerConfigUpdateAction INSTANCE = new SchedulerConfigUpdateAction();
    public static final String NAME = "cluster:admin/searchsupport/scheduler/config/update";

    protected SchedulerConfigUpdateAction() {
        super(NAME);
    }

    public static void send(Client client, final String schedulerName) {
        client.execute((ActionType)INSTANCE, (ActionRequest)new SchedulerConfigUpdateRequest(schedulerName), (ActionListener)new ActionListener<SchedulerConfigUpdateResponse>(){

            public void onResponse(SchedulerConfigUpdateResponse response) {
                log.info("Result of scheduler config update of " + schedulerName + ":\n" + String.valueOf((Object)response));
            }

            public void onFailure(Exception e) {
                log.error("Scheduler config update of " + schedulerName + " failed", (Throwable)e);
            }
        });
    }
}

