/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.fluent.collections;

import com.floragunn.fluent.collections.ImmutableMap;
import com.floragunn.fluent.collections.ImmutableSet;
import com.floragunn.fluent.collections.OrderedImmutableMapImpl;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;

public interface OrderedImmutableMap<K, V>
extends ImmutableMap<K, V> {
    public static <K, V> OrderedImmutableMap<K, V> of(K k1, V v1) {
        return OrderedImmutableMapImpl.of(k1, v1);
    }

    public static <K, V> OrderedImmutableMap<K, V> of(K k1, V v1, K k2, V v2) {
        return OrderedImmutableMapImpl.of(k1, v1, k2, v2);
    }

    public static <K, V> OrderedImmutableMap<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3) {
        return OrderedImmutableMapImpl.of(k1, v1, k2, v2, k3, v3);
    }

    public static <K, V> OrderedImmutableMap<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4) {
        return OrderedImmutableMapImpl.of(k1, v1, k2, v2, k3, v3, k4, v4);
    }

    public static <K, V> OrderedImmutableMap<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5) {
        return OrderedImmutableMapImpl.of(k1, v1, k2, v2, k3, v3, k4, v4, k5, v5);
    }

    public static <K, V> OrderedImmutableMap<K, V> ofNonNull(K k1, V v1) {
        return OrderedImmutableMapImpl.ofNonNull(k1, v1);
    }

    public static <K, V> OrderedImmutableMap<K, V> ofNonNull(K k1, V v1, K k2, V v2) {
        return OrderedImmutableMapImpl.ofNonNull(k1, v1, k2, v2);
    }

    public static <K, V> OrderedImmutableMap<K, V> ofNonNull(K k1, V v1, K k2, V v2, K k3, V v3) {
        return OrderedImmutableMapImpl.ofNonNull(k1, v1, k2, v2, k3, v3);
    }

    public static <K, V> OrderedImmutableMap<K, V> ofNonNull(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4) {
        return OrderedImmutableMapImpl.ofNonNull(k1, v1, k2, v2, k3, v3, k4, v4);
    }

    public static <K, V> OrderedImmutableMap<K, V> ofNonNull(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5) {
        return OrderedImmutableMapImpl.ofNonNull(k1, v1, k2, v2, k3, v3, k4, v4, k5, v5);
    }

    public static <K, V> OrderedImmutableMap<K, V> of(Map<K, V> map) {
        return OrderedImmutableMapImpl.of(map);
    }

    public static <K, V> OrderedImmutableMap<K, V> of(Map<K, V> map, K k1, V v1) {
        return OrderedImmutableMapImpl.of(map, k1, v1);
    }

    public static <K, V> OrderedImmutableMap<K, V> of(Map<K, V> map, K k1, V v1, K k2, V v2) {
        return OrderedImmutableMapImpl.of(map, k1, v1, k2, v2);
    }

    public static <K, V> OrderedImmutableMap<K, V> without(Map<K, V> map, K key) {
        return OrderedImmutableMapImpl.without(map, key);
    }

    public static <C, K, V> OrderedImmutableMap<K, V> map(Collection<C> collection, Function<C, Map.Entry<K, V>> mappingFunction) {
        return OrderedImmutableMapImpl.map(collection, mappingFunction);
    }

    public static <KS, VS, KT, VT> OrderedImmutableMap<KT, VT> map(Map<KS, VS> source, Function<KS, KT> keyMappingFunction, Function<VS, VT> valueMappingFunction) {
        return OrderedImmutableMapImpl.map(source, keyMappingFunction, valueMappingFunction);
    }

    public static <K, V> Map.Entry<K, V> entry(K k1, V v1) {
        return new AbstractMap.SimpleImmutableEntry<K, V>(k1, v1);
    }

    public static <K, V> OrderedImmutableMap<K, V> empty() {
        return OrderedImmutableMapImpl.empty();
    }

    public static <K, V> OrderedImmutableMap<K, V> ordered() {
        return OrderedImmutableMapImpl.empty();
    }

    @Override
    public OrderedImmutableMap<K, V> without(K var1);

    @Override
    public OrderedImmutableMap<K, V> with(K var1, V var2);

    @Override
    public <K2 extends K, V2 extends V> OrderedImmutableMap<K, V> with(ImmutableMap<K2, V2> var1);

    @Override
    public OrderedImmutableMap<K, V> withComputed(K var1, Function<V, V> var2);

    @Override
    public OrderedImmutableMap<K, V> matching(Predicate<K> var1);

    @Override
    public OrderedImmutableMap<K, V> matching(BiPredicate<K, V> var1);

    @Override
    public OrderedImmutableMap<K, V> intersection(ImmutableSet<? extends K> var1);

    @Override
    public <KT, VT> OrderedImmutableMap<KT, VT> map(Function<K, KT> var1, Function<V, VT> var2);

    @Override
    public <VT> OrderedImmutableMap<K, VT> mapValues(Function<V, VT> var1);

    @Override
    public <KT, VT> OrderedImmutableMap<KT, VT> assertElementType(Class<KT> var1, Class<VT> var2);

    @Override
    public <KT> OrderedImmutableMap<KT, V> ensureKeyType(Class<KT> var1, Function<Object, KT> var2);

    public static class Builder<K, V> {
        private OrderedImmutableMapImpl.InternalBuilder<K, V> internalBuilder;
        private Function<K, V> defaultSupplier;

        public Builder() {
            this.internalBuilder = new OrderedImmutableMapImpl.HashArrayBackedMap.Builder(16);
        }

        public Builder(int expectedNumberOfElements) {
            this.internalBuilder = expectedNumberOfElements <= 25 ? new OrderedImmutableMapImpl.HashArrayBackedMap.Builder(16) : (expectedNumberOfElements <= 100 ? new OrderedImmutableMapImpl.HashArrayBackedMap.Builder(64) : (expectedNumberOfElements <= 400 ? new OrderedImmutableMapImpl.HashArrayBackedMap.Builder(256) : new OrderedImmutableMapImpl.MapBackedMap.Builder(expectedNumberOfElements)));
        }

        public Builder(Map<K, V> initialContent) {
            if (initialContent instanceof OrderedImmutableMapImpl.HashArrayBackedMap) {
                this.internalBuilder = new OrderedImmutableMapImpl.HashArrayBackedMap.Builder((OrderedImmutableMapImpl.HashArrayBackedMap)initialContent);
            } else if (initialContent.size() <= 25) {
                this.internalBuilder = new OrderedImmutableMapImpl.HashArrayBackedMap.Builder(16);
                for (Map.Entry<K, V> entry : initialContent.entrySet()) {
                    this.internalBuilder = this.internalBuilder.with(entry.getKey(), entry.getValue());
                }
            } else if (initialContent.size() <= 100) {
                this.internalBuilder = new OrderedImmutableMapImpl.HashArrayBackedMap.Builder(64);
                for (Map.Entry<K, V> entry : initialContent.entrySet()) {
                    this.internalBuilder = this.internalBuilder.with(entry.getKey(), entry.getValue());
                }
            } else if (initialContent.size() <= 400) {
                this.internalBuilder = new OrderedImmutableMapImpl.HashArrayBackedMap.Builder(256);
                for (Map.Entry<K, V> entry : initialContent.entrySet()) {
                    this.internalBuilder = this.internalBuilder.with(entry.getKey(), entry.getValue());
                }
            } else {
                this.internalBuilder = new OrderedImmutableMapImpl.MapBackedMap.Builder<K, V>(initialContent);
            }
        }

        public Builder<K, V> defaultValue(Function<K, V> defaultSupplier) {
            this.defaultSupplier = defaultSupplier;
            return this;
        }

        public Builder<K, V> with(K key, V value) {
            if (key == null) {
                throw new IllegalArgumentException("null keys are not allowed");
            }
            this.internalBuilder = this.internalBuilder.with(key, value);
            return this;
        }

        public Builder<K, V> with(Map<K, V> map) {
            if (!map.isEmpty()) {
                this.internalBuilder = this.internalBuilder.with(map);
            }
            return this;
        }

        public void put(K key, V value) {
            if (key == null) {
                throw new IllegalArgumentException("null keys are not allowed");
            }
            this.internalBuilder = this.internalBuilder.with(key, value);
        }

        public void putAll(Map<K, V> map) {
            if (!map.isEmpty()) {
                this.internalBuilder = this.internalBuilder.with(map);
            }
        }

        public boolean remove(K e) {
            return this.internalBuilder.remove(e);
        }

        public boolean contains(K e) {
            return this.internalBuilder.contains(e);
        }

        public V get(K k) {
            V result = this.internalBuilder.get(k);
            if (result == null && this.defaultSupplier != null && (result = this.defaultSupplier.apply(k)) != null) {
                this.put(k, result);
            }
            return result;
        }

        public OrderedImmutableMap<K, V> build() {
            return this.internalBuilder.build();
        }

        public <V2> OrderedImmutableMap<K, V2> build(Function<V, V2> valueMappingFunction) {
            return this.internalBuilder.build(valueMappingFunction);
        }

        public int size() {
            return this.internalBuilder.size();
        }

        public Set<K> keySet() {
            return this.internalBuilder.keySet();
        }
    }
}

