/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.ssl.util.config;

import com.floragunn.searchguard.ssl.util.config.GenericSSLConfigException;
import com.floragunn.searchguard.support.PemKeyReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.security.KeyStore;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;

public class TrustStore {
    private KeyStore keyStore;
    private char[] keyPassword;
    private String keyAlias;

    public static Builder from() {
        return new Builder();
    }

    public KeyStore getKeyStore() {
        return this.keyStore;
    }

    public char[] getKeyPassword() {
        return this.keyPassword;
    }

    public String getKeyAlias() {
        return this.keyAlias;
    }

    public static class Builder {
        private X509Certificate[] certificates;
        private KeyStore keyStore;

        public Builder certPem(File file) throws GenericSSLConfigException {
            Builder builder;
            FileInputStream in = new FileInputStream(file);
            try {
                builder = this.certPem(in);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        in.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (FileNotFoundException e) {
                    throw new GenericSSLConfigException("Could not find certificate file " + String.valueOf(file), e);
                }
                catch (IOException | CertificateException e) {
                    throw new GenericSSLConfigException("Error while reading certificate file " + String.valueOf(file), e);
                }
            }
            in.close();
            return builder;
        }

        public Builder certPem(Path path) throws GenericSSLConfigException {
            return this.certPem(path.toFile());
        }

        public Builder certPem(InputStream inputStream) throws CertificateException {
            this.certificates = PemKeyReader.loadCertificatesFromStream(inputStream);
            return this;
        }

        public Builder jks(File file, String password) throws GenericSSLConfigException {
            return this.keyStore(file, password, "JKS");
        }

        public Builder pkcs12(File file, String password) throws GenericSSLConfigException {
            return this.keyStore(file, password, "PKCS12");
        }

        public Builder keyStore(File file, String password) throws GenericSSLConfigException {
            return this.keyStore(file, password, null);
        }

        public Builder keyStore(File file, String password, String type) throws GenericSSLConfigException {
            try {
                if (type == null) {
                    String fileName = file.getName();
                    if (fileName.endsWith(".jks")) {
                        type = "JKS";
                    } else if (fileName.endsWith(".pfx") || fileName.endsWith(".p12")) {
                        type = "PKCS12";
                    } else {
                        throw new IllegalArgumentException("Unknwon file type: " + fileName);
                    }
                }
                this.keyStore = KeyStore.getInstance(type.toUpperCase());
                this.keyStore.load(new FileInputStream(file), password == null ? null : password.toCharArray());
                return this;
            }
            catch (Exception e) {
                throw new GenericSSLConfigException("Error loading client auth key store from " + String.valueOf(file), e);
            }
        }

        public TrustStore build() throws GenericSSLConfigException {
            try {
                TrustStore result = new TrustStore();
                if (this.keyStore != null) {
                    result.keyStore = this.keyStore;
                } else if (this.certificates != null) {
                    result.keyStore = PemKeyReader.toTruststore("al", this.certificates);
                } else {
                    throw new IllegalStateException("Builder not completely initialized: " + String.valueOf(this));
                }
                return result;
            }
            catch (Exception e) {
                throw new GenericSSLConfigException("Error initializing client auth credentials", e);
            }
        }
    }
}

