/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.codova.documents;

import com.floragunn.codova.documents.Document;
import com.floragunn.codova.documents.MetadataAttributeImpl;
import com.floragunn.codova.documents.MetadataListAttributeImpl;
import com.floragunn.codova.documents.Parser;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public interface Metadata<T>
extends Document<Metadata<T>> {
    public String description();

    public Class<T> type();

    public Parser<T, Parser.Context> parser();

    @Override
    public Map<String, Object> toBasicObject();

    public List<Attribute<?>> attributes();

    public static <T> Metadata<T> create(Class<T> type, String description, Parser<T, Parser.Context> parser, Attribute<?> ... attributes) {
        return Metadata.create(type, type.getSimpleName(), description, parser, attributes);
    }

    public static <T> Metadata<T> create(final Class<T> type, String typeName, final String description, final Parser<T, Parser.Context> parser, Attribute<?> ... attributes) {
        final List<Attribute<?>> attributesList = Arrays.asList(attributes);
        final LinkedHashMap<String, Object> basicObject = new LinkedHashMap<String, Object>(4);
        if (description != null) {
            basicObject.put("description", description);
        }
        if (typeName != null) {
            basicObject.put("type", typeName);
        }
        if (attributes != null && attributes.length > 0) {
            LinkedHashMap attributesBasicObject = new LinkedHashMap(attributes.length);
            for (Attribute<?> attribute : attributes) {
                LinkedHashMap<String, String> attributeBasicObject = new LinkedHashMap<String, String>(4);
                if (attribute.description() != null) {
                    attributeBasicObject.put("description", attribute.description());
                } else if (attribute.meta().toBasicObject().containsKey("description")) {
                    attributeBasicObject.put("description", (String)attribute.meta().toBasicObject().get("description"));
                }
                attributeBasicObject.put("cardinality", attribute.cardinalityAsString());
                if (attribute.meta() != null) {
                    for (Map.Entry entry : attribute.meta().toBasicObject().entrySet()) {
                        if (((String)entry.getKey()).equals("description")) continue;
                        attributeBasicObject.put((String)entry.getKey(), (String)entry.getValue());
                    }
                }
                attributesBasicObject.put(attribute.name(), attributeBasicObject);
            }
            basicObject.put("attributes", attributesBasicObject);
        }
        return new Metadata<T>(){

            @Override
            public String description() {
                return description;
            }

            @Override
            public List<Attribute<?>> attributes() {
                return attributesList;
            }

            @Override
            public Class<T> type() {
                return type;
            }

            @Override
            public Parser<T, Parser.Context> parser() {
                return parser;
            }

            @Override
            public Map<String, Object> toBasicObject() {
                return basicObject;
            }
        };
    }

    public static interface ListAttribute<AttributeType>
    extends Attribute<List<AttributeType>> {
        public Metadata<AttributeType> elementMeta();

        public ListAttribute<AttributeType> withEmptyListAsDefault();
    }

    public static interface Attribute<AttributeType> {
        public String name();

        public String description();

        public Metadata<AttributeType> meta();

        public int minCardinality();

        public int maxCardinality();

        public String cardinalityAsString();

        public AttributeType defaultValue();

        public Attribute<AttributeType> defaultValue(AttributeType var1);

        public static <AttributeType> Attribute<AttributeType> required(String name, Metadata<AttributeType> meta, String description) {
            return new MetadataAttributeImpl<AttributeType>(name, description, meta, 1, 1, "1");
        }

        public static <AttributeType> Attribute<AttributeType> required(String name, Class<AttributeType> type, String description) {
            return Attribute.required(name, Metadata.create(type, null, null, new Attribute[0]), description);
        }

        public static <AttributeType> Attribute<AttributeType> optional(String name, Metadata<AttributeType> meta, String description) {
            return new MetadataAttributeImpl<AttributeType>(name, description, meta, 0, 1, "0..1");
        }

        public static <AttributeType> Attribute<AttributeType> optional(String name, Class<AttributeType> type, String description) {
            return Attribute.optional(name, Metadata.create(type, null, null, new Attribute[0]), description);
        }

        public static <AttributeType> ListAttribute<AttributeType> list(String name, Metadata<AttributeType> meta, String description) {
            return new MetadataListAttributeImpl<AttributeType>(name, description, meta, 0, Integer.MAX_VALUE, "0..n");
        }

        public static <AttributeType> ListAttribute<AttributeType> list(String name, Class<AttributeType> type, String description) {
            return Attribute.list(name, Metadata.create(type, null, null, new Attribute[0]), description);
        }
    }
}

