/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.codova.validation.errors;

import com.fasterxml.jackson.core.JsonLocation;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.floragunn.codova.validation.errors.ValidationError;
import java.util.LinkedHashMap;
import java.util.Map;

public class JsonValidationError
extends ValidationError {
    private JsonLocation jsonLocation;
    private String context;

    public JsonValidationError(String attribute, JsonProcessingException jsonProcessingException) {
        super(attribute, "Invalid JSON document: " + jsonProcessingException.getOriginalMessage());
        this.cause(jsonProcessingException);
        this.jsonLocation = jsonProcessingException.getLocation();
        if (jsonProcessingException instanceof JsonParseException) {
            this.context = ((JsonParseException)jsonProcessingException).getRequestPayloadAsString();
        }
    }

    public JsonValidationError(String attribute, String message, JsonLocation jsonLocation, String context) {
        super(attribute, message);
        this.jsonLocation = jsonLocation;
        this.context = context;
    }

    @Override
    public Map<String, Object> toBasicObject() {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        result.put("error", this.getMessage());
        if (this.jsonLocation != null) {
            result.put("line", this.jsonLocation.getLineNr());
            result.put("column", this.jsonLocation.getColumnNr());
        }
        if (this.context != null) {
            result.put("context", this.context);
        }
        return result;
    }

    @Override
    public String toValidationErrorsOverviewString() {
        if (this.jsonLocation != null) {
            return this.getMessage() + "; line: " + this.jsonLocation.getLineNr() + "; column: " + this.jsonLocation.getColumnNr();
        }
        return this.getMessage();
    }
}

