/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.signals.actions.account.put;

import com.floragunn.codova.validation.ConfigValidationException;
import com.floragunn.searchguard.user.User;
import com.floragunn.signals.Signals;
import com.floragunn.signals.accounts.Account;
import com.floragunn.signals.actions.account.config_update.DestinationConfigUpdateAction;
import com.floragunn.signals.actions.account.put.PutAccountRequest;
import com.floragunn.signals.actions.account.put.PutAccountResponse;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.DocWriteResponse;
import org.elasticsearch.action.index.IndexRequestBuilder;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentFactory;

public class TransportPutAccountAction
extends HandledTransportAction<PutAccountRequest, PutAccountResponse> {
    private final Signals signals;
    private final Client client;
    private final ThreadPool threadPool;

    @Inject
    public TransportPutAccountAction(Signals signals, TransportService transportService, ThreadPool threadPool, ActionFilters actionFilters, Client client) {
        super("cluster:admin:searchguard:signals:account/put", transportService, actionFilters, PutAccountRequest::new, (Executor)threadPool.executor("generic"));
        this.signals = signals;
        this.client = client;
        this.threadPool = threadPool;
    }

    protected final void doExecute(Task task, PutAccountRequest request, final ActionListener<PutAccountResponse> listener) {
        final String scopedId = request.getAccountType() + "/" + request.getAccountId();
        try {
            ThreadContext threadContext = this.threadPool.getThreadContext();
            User user = (User)threadContext.getTransient("_sg_user");
            if (user == null) {
                listener.onResponse((Object)new PutAccountResponse(scopedId, -1L, DocWriteResponse.Result.NOOP, RestStatus.UNAUTHORIZED, "Request did not contain user", null));
                return;
            }
            Object remoteAddress = threadContext.getTransient("_sg_remote_address");
            Object origin = threadContext.getTransient("_sg_origin");
            Map originalResponseHeaders = threadContext.getResponseHeaders();
            Account account = Account.parse(request.getAccountType(), request.getAccountId(), request.getBody().utf8ToString());
            try (ThreadContext.StoredContext ctx = this.threadPool.getThreadContext().stashContext();
                 XContentBuilder xContentBuilder = XContentFactory.jsonBuilder();){
                threadContext.putHeader("_sg_conf_request", "true");
                threadContext.putTransient("_sg_user", (Object)user);
                threadContext.putTransient("_sg_remote_address", remoteAddress);
                threadContext.putTransient("_sg_origin", origin);
                originalResponseHeaders.entrySet().forEach(h -> ((List)h.getValue()).forEach(v -> threadContext.addResponseHeader((String)h.getKey(), v)));
                account.toXContent(xContentBuilder, ToXContent.EMPTY_PARAMS);
                ((IndexRequestBuilder)this.client.prepareIndex().setIndex(this.signals.getSignalsSettings().getStaticSettings().getIndexNames().getAccounts())).setId(scopedId).setSource(xContentBuilder).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE).execute((ActionListener)new ActionListener<DocWriteResponse>(){

                    public void onResponse(DocWriteResponse response) {
                        if (response.getResult() == DocWriteResponse.Result.CREATED || response.getResult() == DocWriteResponse.Result.UPDATED) {
                            DestinationConfigUpdateAction.send(TransportPutAccountAction.this.client);
                        }
                        listener.onResponse((Object)new PutAccountResponse(scopedId, response.getVersion(), response.getResult(), response.status(), null, null));
                    }

                    public void onFailure(Exception e) {
                        listener.onFailure(e);
                    }
                });
            }
        }
        catch (ConfigValidationException e) {
            listener.onResponse((Object)new PutAccountResponse(scopedId, -1L, DocWriteResponse.Result.NOOP, RestStatus.BAD_REQUEST, e.getMessage(), e.getValidationErrors().toJsonString()));
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }
}

