/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.signals.actions.summary;

import com.floragunn.codova.documents.DocNode;
import com.floragunn.codova.documents.Document;
import com.floragunn.codova.validation.ConfigValidationException;
import com.floragunn.fluent.collections.ImmutableMap;
import com.floragunn.searchsupport.action.Action;
import com.floragunn.signals.actions.summary.SafeDocNodeReader;
import com.floragunn.signals.actions.summary.WatchActionNames;
import com.google.common.base.Strings;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.temporal.TemporalAccessor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.common.time.DateFormatter;
import org.elasticsearch.rest.RestStatus;

public class LoadOperatorSummaryData
implements Document {
    public static final String FIELD_WATCHES = "watches";
    private static final DateFormatter DATE_FORMATTER = DateFormatter.forPattern((String)"strict_date_time").withZone((ZoneId)ZoneOffset.UTC);
    private final List<WatchSummary> watches;

    LoadOperatorSummaryData(Action.UnparsedMessage message) throws ConfigValidationException {
        DocNode docNode = message.requiredDocNode();
        this.watches = docNode.getAsListFromNodes(FIELD_WATCHES, WatchSummary::parse);
    }

    LoadOperatorSummaryData(List<WatchSummary> watches) {
        this.watches = watches;
    }

    public LoadOperatorSummaryData filterActions(List<WatchActionNames> watchActionNames) {
        Map<String, Set> actionNamesByWatchId = watchActionNames.stream().collect(Collectors.toMap(WatchActionNames::watchIdWithTenantPrefix, WatchActionNames::actionNamesAsSet));
        List<WatchSummary> filteredWatches = this.watches.stream().map(watchSummary -> watchSummary.filterActions((Set)actionNamesByWatchId.get(watchSummary.id))).toList();
        return new LoadOperatorSummaryData(filteredWatches);
    }

    public LoadOperatorSummaryData with(LoadOperatorSummaryData loadOperatorSummaryData) {
        ArrayList<WatchSummary> newWatches = new ArrayList<WatchSummary>(this.watches);
        Set includedIds = this.watches.stream().map(summary -> summary.id).collect(Collectors.toSet());
        for (WatchSummary watch : loadOperatorSummaryData.watches) {
            if (includedIds.contains(watch.id)) continue;
            newWatches.add(watch);
        }
        return new LoadOperatorSummaryData(newWatches);
    }

    public LoadOperatorSummaryData withActive(List<WatchActionNames> watchesWithActive) {
        HashMap<String, Boolean> watchIdToActive = new HashMap<String, Boolean>(watchesWithActive.size());
        for (WatchActionNames watch2 : watchesWithActive) {
            watchIdToActive.put(watch2.watchIdWithTenantPrefix(), watch2.active());
        }
        return new LoadOperatorSummaryData(this.watches.stream().map(watch -> watch.withActive((Boolean)watchIdToActive.get(watch.id))).collect(Collectors.toList()));
    }

    public int getSize() {
        return this.watches.size();
    }

    public Map<String, Object> toBasicObject() {
        List watchesMap = this.watches.stream().map(WatchSummary::toBasicObject).collect(Collectors.toList());
        return ImmutableMap.of((Object)FIELD_WATCHES, watchesMap);
    }

    private static String instantToString(Instant instant) {
        return instant == null ? null : DATE_FORMATTER.format((TemporalAccessor)instant);
    }

    private static Instant stringToInstant(String instant) {
        return Strings.isNullOrEmpty((String)instant) ? null : Instant.from(DATE_FORMATTER.parse(instant));
    }

    static class WatchSummary {
        public static final String FIELD_WATCH_ID = "watch_id";
        public static final String FIELD_TENANT = "tenant";
        public static final String FIELD_STATUS_CODE = "status_code";
        public static final String FIELD_SEVERITY = "severity";
        public static final String FIELD_DESCRIPTION = "description";
        public static final String FIELD_SEVERITY_DETAILS = "severity_details";
        public static final String FIELD_ACTIONS = "actions";
        public static final String FIELD_REASON = "reason";
        public static final String FIELD_ACTIVE = "active";
        private final String id;
        private final String statusCode;
        private final String severity;
        private final String description;
        private final WatchSeverityDetails severityDetails;
        private final Boolean active;
        private final Map<String, ActionSummary> actions;
        private final String reason;

        public WatchSummary(String id, String statusCode, String severity, String description, WatchSeverityDetails severityDetails, Map<String, ActionSummary> actions, String reason, Boolean active) {
            this.id = id;
            this.statusCode = statusCode;
            this.severity = severity;
            this.description = description;
            this.severityDetails = severityDetails;
            this.actions = Objects.requireNonNull(actions);
            this.reason = Objects.requireNonNull(reason);
            this.active = active;
        }

        private static WatchSummary parse(DocNode node) {
            WatchSeverityDetails details = node.containsKey((Object)FIELD_SEVERITY_DETAILS) ? new WatchSeverityDetails(node.getAsNode(FIELD_SEVERITY_DETAILS)) : null;
            DocNode actionsNode = node.getAsNode(FIELD_ACTIONS);
            HashMap<String, ActionSummary> actionsSummary = new HashMap<String, ActionSummary>();
            for (String actionName : actionsNode.keySet()) {
                actionsSummary.put(actionName, ActionSummary.parse(actionsNode.getAsNode(actionName)));
            }
            return new WatchSummary(node.getAsString(FIELD_WATCH_ID), node.getAsString(FIELD_STATUS_CODE), node.getAsString(FIELD_SEVERITY), node.getAsString(FIELD_DESCRIPTION), details, actionsSummary, node.getAsString(FIELD_REASON), null);
        }

        Map<String, Object> toBasicObject() {
            Map severityMap = Optional.ofNullable(this.severityDetails).map(WatchSeverityDetails::toBasicObject).orElse(null);
            Map<String, Object> actionMap = this.createActionSummaryMap();
            return ImmutableMap.of((Object)FIELD_WATCH_ID, (Object)this.getPureId(), (Object)FIELD_STATUS_CODE, (Object)this.statusCode, (Object)FIELD_SEVERITY, (Object)this.severity, (Object)FIELD_DESCRIPTION, (Object)this.description, (Object)FIELD_SEVERITY_DETAILS, (Object)severityMap).with(ImmutableMap.of((Object)FIELD_ACTIONS, actionMap, (Object)FIELD_TENANT, (Object)this.getTenant(), (Object)FIELD_ACTIVE, (Object)this.active, (Object)FIELD_REASON, (Object)this.reason));
        }

        private Map<String, Object> createActionSummaryMap() {
            HashMap<String, Object> actionMap = new HashMap<String, Object>();
            for (Map.Entry<String, ActionSummary> entry : this.actions.entrySet()) {
                actionMap.put(entry.getKey(), entry.getValue().toBasicObject());
            }
            return actionMap;
        }

        public String getPureId() {
            if (Objects.nonNull(this.id)) {
                int tenantSeparator = this.id.indexOf("/");
                if (tenantSeparator == -1) {
                    return this.id;
                }
                return this.id.substring(tenantSeparator + 1);
            }
            return null;
        }

        public String getTenant() {
            if (Objects.nonNull(this.id)) {
                int tenantSeparator = this.id.indexOf("/");
                if (tenantSeparator == -1) {
                    return this.id;
                }
                return this.id.substring(0, tenantSeparator);
            }
            return null;
        }

        public WatchSummary filterActions(Set<String> allowedActionNames) {
            if (allowedActionNames == null) {
                return this;
            }
            LinkedHashMap<String, ActionSummary> newActions = new LinkedHashMap<String, ActionSummary>();
            for (Map.Entry<String, ActionSummary> entry : this.actions.entrySet()) {
                if (!allowedActionNames.contains(entry.getKey())) continue;
                newActions.put(entry.getKey(), entry.getValue());
            }
            return new WatchSummary(this.id, this.statusCode, this.severity, this.description, this.severityDetails, newActions, this.reason, this.active);
        }

        WatchSummary withActive(Boolean watchActive) {
            return new WatchSummary(this.id, this.statusCode, this.severity, this.description, this.severityDetails, this.actions, this.reason, watchActive);
        }
    }

    static class ActionSummary {
        public static final String FIELD_TRIGGERED = "triggered";
        public static final String FIELD_CHECKED = "checked";
        public static final String FIELD_CHECK_RESULT = "check_result";
        public static final String FIELD_EXECUTION = "execution";
        public static final String FIELD_ERROR = "error";
        public static final String FIELD_STATUS_CODE = "status_code";
        public static final String FIELD_STATUS_DETAILS = "status_details";
        public static final String FIELD_ACK_BY_USER = "ack_by";
        public static final String FIELD_ACK_ON = "ack_on";
        private final Instant triggered;
        private final Instant checked;
        private final Boolean checkResult;
        private final Instant execution;
        private final String error;
        private final String statusCode;
        private final String statusDetails;
        private final String ackByUser;
        private final Instant ackTime;

        public ActionSummary(Instant triggered, Instant checked, Boolean checkResult, Instant execution, String error, String statusCode, String statusDetails, String ackByUser, Instant ackTime) {
            this.triggered = triggered;
            this.checked = checked;
            this.checkResult = checkResult;
            this.execution = execution;
            this.error = error;
            this.statusCode = statusCode;
            this.statusDetails = statusDetails;
            this.ackByUser = ackByUser;
            this.ackTime = ackTime;
        }

        public static ActionSummary parse(DocNode node) {
            try {
                return new ActionSummary(LoadOperatorSummaryData.stringToInstant(node.getAsString(FIELD_TRIGGERED)), LoadOperatorSummaryData.stringToInstant(node.getAsString(FIELD_CHECKED)), node.getBoolean(FIELD_CHECK_RESULT), LoadOperatorSummaryData.stringToInstant(node.getAsString(FIELD_EXECUTION)), node.getAsString(FIELD_ERROR), node.getAsString(FIELD_STATUS_CODE), node.getAsString(FIELD_STATUS_DETAILS), node.getAsString(FIELD_ACK_BY_USER), LoadOperatorSummaryData.stringToInstant(node.getAsString(FIELD_ACK_ON)));
            }
            catch (ConfigValidationException e) {
                throw new ElasticsearchStatusException("Cannot parse action summary", RestStatus.INTERNAL_SERVER_ERROR, (Throwable)e, new Object[0]);
            }
        }

        Map<String, Object> toBasicObject() {
            return ImmutableMap.of((Object)FIELD_TRIGGERED, (Object)LoadOperatorSummaryData.instantToString(this.triggered), (Object)FIELD_CHECKED, (Object)LoadOperatorSummaryData.instantToString(this.checked), (Object)FIELD_CHECK_RESULT, (Object)this.checkResult).with(ImmutableMap.of((Object)FIELD_EXECUTION, (Object)LoadOperatorSummaryData.instantToString(this.execution), (Object)FIELD_ERROR, (Object)this.error, (Object)FIELD_STATUS_CODE, (Object)this.statusCode, (Object)FIELD_STATUS_DETAILS, (Object)this.statusDetails)).with(ImmutableMap.of((Object)FIELD_ACK_BY_USER, (Object)this.ackByUser, (Object)FIELD_ACK_ON, (Object)LoadOperatorSummaryData.instantToString(this.ackTime)));
        }
    }

    static class WatchSeverityDetails {
        public static final String FIELD_LEVEL = "level";
        public static final String FIELD_LEVEL_NUMERIC = "level_numeric";
        public static final String FIELD_CURRENT_VALUE = "current_value";
        public static final String FIELD_THRESHOLD = "threshold";
        private final String level;
        private final Long levelNumeric;
        private final Double currentValue;
        private final Double threshold;

        public WatchSeverityDetails(String level, Long levelNumeric, Double currentValue, Double threshold) {
            this.level = level;
            this.levelNumeric = levelNumeric;
            this.currentValue = currentValue;
            this.threshold = threshold;
        }

        public WatchSeverityDetails(DocNode node) {
            this(node.getAsString(FIELD_LEVEL), SafeDocNodeReader.getLongValue(node, FIELD_LEVEL_NUMERIC), SafeDocNodeReader.getDoubleValue(node, FIELD_CURRENT_VALUE), SafeDocNodeReader.getDoubleValue(node, FIELD_THRESHOLD));
        }

        Map<String, Object> toBasicObject() {
            return ImmutableMap.of((Object)FIELD_LEVEL, (Object)this.level, (Object)FIELD_LEVEL_NUMERIC, (Object)this.levelNumeric, (Object)FIELD_CURRENT_VALUE, (Object)this.currentValue, (Object)FIELD_THRESHOLD, (Object)this.threshold);
        }
    }
}

