/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.signals.actions.summary;

import com.floragunn.codova.documents.DocNode;
import com.floragunn.codova.documents.DocumentParseException;
import com.floragunn.codova.documents.UnparsedDocument;
import com.floragunn.codova.validation.ConfigValidationException;
import com.floragunn.fluent.collections.ImmutableMap;
import com.floragunn.searchsupport.action.Action;
import com.floragunn.signals.actions.summary.ActionProperties;
import com.floragunn.signals.actions.summary.LoadOperatorSummaryRequestConstants;
import com.floragunn.signals.actions.summary.RangesFilters;
import com.floragunn.signals.actions.summary.SafeDocNodeReader;
import com.floragunn.signals.actions.summary.WatchFilter;
import com.floragunn.signals.watch.result.Status;
import java.time.Instant;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.rest.RestStatus;

public class LoadOperatorSummaryRequest
extends Action.Request {
    private static final String DEFAULT_SORTING = "-severity_details.level_numeric";
    public static final int DEFAULT_SIZE = 10;
    private final String tenant;
    private final String sorting;
    private final Integer size;
    private final String watchId;
    private final List<String> watchStatusCodes;
    private final List<String> severities;
    private final Integer levelNumericEqualTo;
    private final Integer levelNumericGreaterThan;
    private final Integer levelNumericLessThan;
    private final List<String> actionNames;
    private final RangesFilters ranges;
    private final ActionProperties actionProperties;

    public LoadOperatorSummaryRequest(Action.UnparsedMessage message) throws ConfigValidationException {
        DocNode docNode = message.requiredDocNode();
        this.tenant = docNode.getAsString("tenant");
        this.sorting = docNode.getAsString("sorting");
        this.size = SafeDocNodeReader.getIntValue(docNode, "size");
        this.watchId = docNode.getAsString("watch_id");
        this.watchStatusCodes = Optional.ofNullable(docNode.getAsListOfStrings("watch_status_codes")).orElseGet(Collections::emptyList);
        this.severities = Optional.ofNullable(docNode.getAsListOfStrings("severities")).orElseGet(Collections::emptyList);
        this.levelNumericEqualTo = SafeDocNodeReader.getIntValue(docNode, "level_numeric_equal_to");
        this.levelNumericGreaterThan = SafeDocNodeReader.getIntValue(docNode, "level_numeric_greater_than");
        this.levelNumericLessThan = SafeDocNodeReader.getIntValue(docNode, "level_numeric_less_than");
        this.actionNames = docNode.getAsListOfStrings("actions");
        this.ranges = this.prepareRanges(docNode);
        this.actionProperties = this.prepareActionProperties(docNode);
    }

    private LoadOperatorSummaryRequest(String tenant, String sorting, String size, DocNode requestBody) {
        this.tenant = tenant == null ? requestBody.getAsString("tenant") : tenant;
        this.sorting = sorting;
        this.size = size == null ? null : Integer.valueOf(Integer.parseInt(size));
        this.watchStatusCodes = requestBody.getAsListOfStrings("status_codes");
        this.watchId = requestBody.getAsString("watch_id");
        this.severities = requestBody.getAsListOfStrings("severities");
        this.levelNumericEqualTo = SafeDocNodeReader.getIntValue(requestBody, "level_numeric_equal_to");
        this.levelNumericGreaterThan = SafeDocNodeReader.getIntValue(requestBody, "level_numeric_greater_than");
        this.levelNumericLessThan = SafeDocNodeReader.getIntValue(requestBody, "level_numeric_less_than");
        this.actionNames = requestBody.getAsListOfStrings("actions");
        this.ranges = this.prepareRanges(requestBody);
        this.actionProperties = this.prepareActionProperties(requestBody);
        this.validateRange("level_numeric", this.levelNumericEqualTo, this.levelNumericGreaterThan, this.levelNumericLessThan);
    }

    LoadOperatorSummaryRequest(String tenant, String sorting, Integer size, List<Status.Code> statusCodes, List<String> severities, Integer levelNumericEqualTo, Integer levelNumericGreaterThan, Integer levelNumericLessThan, List<String> actionNames, RangesFilters ranges, ActionProperties actionProperties) {
        this.tenant = tenant;
        this.sorting = sorting;
        this.size = size;
        this.watchStatusCodes = statusCodes.stream().map(Enum::toString).toList();
        this.watchId = null;
        this.severities = severities;
        this.levelNumericEqualTo = levelNumericEqualTo;
        this.levelNumericGreaterThan = levelNumericGreaterThan;
        this.levelNumericLessThan = levelNumericLessThan;
        this.actionNames = actionNames;
        this.ranges = ranges;
        this.actionProperties = actionProperties;
        this.validateRange("level_numeric", levelNumericEqualTo, levelNumericGreaterThan, levelNumericLessThan);
    }

    LoadOperatorSummaryRequest withWatchStatusCodes(List<Status.Code> statusCodes) {
        Objects.requireNonNull(this.watchStatusCodes, "Watch status codes must not be null");
        return new LoadOperatorSummaryRequest(this.tenant, this.sorting, this.size, statusCodes, this.severities, this.levelNumericEqualTo, this.levelNumericGreaterThan, this.levelNumericLessThan, this.actionNames, this.ranges, this.actionProperties);
    }

    private ActionProperties prepareActionProperties(DocNode docNode) {
        String extractedActionNameForCheckResult = SafeDocNodeReader.getActionNameByPattern(docNode, LoadOperatorSummaryRequestConstants.FIELD_ACTIONS_CHECK_RESULT);
        String actionsCheckResultName = "actions." + extractedActionNameForCheckResult + ".last_check_result";
        Boolean actionsCheckResult = SafeDocNodeReader.getBooleanValue(docNode, "actions." + extractedActionNameForCheckResult + ".checkResult");
        String extractedActionNameForError = SafeDocNodeReader.getActionNameByPattern(docNode, LoadOperatorSummaryRequestConstants.FIELD_ACTIONS_ERROR);
        String actionsErrorName = "actions." + extractedActionNameForError + ".last_error";
        String actionsError = SafeDocNodeReader.getStringValue(docNode, "actions." + extractedActionNameForError + ".error");
        String extractedActionNameForStatusCode = SafeDocNodeReader.getActionNameByPattern(docNode, LoadOperatorSummaryRequestConstants.FIELD_ACTIONS_STATUS_CODE);
        String actionsStatusCodeName = "actions." + extractedActionNameForStatusCode + ".last_status.code";
        String actionsStatusCode = SafeDocNodeReader.getStringValue(docNode, "actions." + extractedActionNameForStatusCode + ".statusCode");
        String extractedActionNameForStatusDetails = SafeDocNodeReader.getActionNameByPattern(docNode, LoadOperatorSummaryRequestConstants.FIELD_ACTIONS_STATUS_DETAILS);
        String actionsStatusDetailsName = "actions." + extractedActionNameForStatusDetails + ".last_status.detail";
        String actionsStatusDetails = SafeDocNodeReader.getStringValue(docNode, "actions." + extractedActionNameForStatusDetails + ".statusDetails");
        return new ActionProperties(actionsCheckResultName, actionsCheckResult, actionsErrorName, actionsError, actionsStatusCodeName, actionsStatusCode, actionsStatusDetailsName, actionsStatusDetails);
    }

    private RangesFilters prepareRanges(DocNode requestBody) {
        String extractedActionCheckedRangeName = SafeDocNodeReader.getActionNameByPatterns(requestBody, LoadOperatorSummaryRequestConstants.FIELD_ACTIONS_CHECKED_AFTER, LoadOperatorSummaryRequestConstants.FIELD_ACTIONS_CHECKED_BEFORE);
        String actionsCheckedName = "actions." + extractedActionCheckedRangeName + ".last_check";
        Instant actionsCheckedBefore = SafeDocNodeReader.getInstantValue(requestBody, "actions." + extractedActionCheckedRangeName + ".checkedBefore");
        Instant actionsCheckedAfter = SafeDocNodeReader.getInstantValue(requestBody, "actions." + extractedActionCheckedRangeName + ".checkedAfter");
        String extractedActionTriggeredRangeName = SafeDocNodeReader.getActionNameByPatterns(requestBody, LoadOperatorSummaryRequestConstants.FIELD_ACTIONS_TRIGGERED_AFTER, LoadOperatorSummaryRequestConstants.FIELD_ACTIONS_TRIGGERED_BEFORE);
        String actionsTriggeredName = "actions." + extractedActionTriggeredRangeName + ".last_triggered";
        Instant actionsTriggeredBefore = SafeDocNodeReader.getInstantValue(requestBody, "actions." + extractedActionTriggeredRangeName + ".triggeredBefore");
        Instant actionsTriggeredAfter = SafeDocNodeReader.getInstantValue(requestBody, "actions." + extractedActionTriggeredRangeName + ".triggeredAfter");
        String extractedActionExecutionRangeName = SafeDocNodeReader.getActionNameByPatterns(requestBody, LoadOperatorSummaryRequestConstants.FIELD_ACTIONS_EXECUTION_AFTER, LoadOperatorSummaryRequestConstants.FIELD_ACTIONS_EXECUTION_BEFORE);
        String actionsExecutionName = "actions." + extractedActionExecutionRangeName + ".last_execution";
        Instant actionsExecutionBefore = SafeDocNodeReader.getInstantValue(requestBody, "actions." + extractedActionExecutionRangeName + ".executionBefore");
        Instant actionsExecutionAfter = SafeDocNodeReader.getInstantValue(requestBody, "actions." + extractedActionExecutionRangeName + ".executionAfter");
        WatchFilter.Range<Integer> levelNumericRange = this.rangeOrNull(this.levelNumericEqualTo, this.levelNumericGreaterThan, this.levelNumericLessThan, "last_execution.severity.level_numeric");
        WatchFilter.Range<Instant> actionsCheckedRange = this.rangeOrNull(null, actionsCheckedAfter, actionsCheckedBefore, actionsCheckedName);
        WatchFilter.Range<Instant> actionsTriggeredRange = this.rangeOrNull(null, actionsTriggeredAfter, actionsTriggeredBefore, actionsTriggeredName);
        WatchFilter.Range<Instant> actionsExecutionRange = this.rangeOrNull(null, actionsExecutionAfter, actionsExecutionBefore, actionsExecutionName);
        return new RangesFilters(levelNumericRange, actionsCheckedRange, actionsTriggeredRange, actionsExecutionRange);
    }

    public LoadOperatorSummaryRequest(String tenant, String sorting, String size, UnparsedDocument<?> body) throws DocumentParseException {
        this(tenant, sorting, size, body.parseAsDocNode());
    }

    public String getSortingOrDefault() {
        if (this.sorting == null || this.sorting.isBlank()) {
            return DEFAULT_SORTING;
        }
        return this.sorting;
    }

    public int getSizeOrDefault() {
        if (this.size == null) {
            return 10;
        }
        return this.size;
    }

    public Object toBasicObject() {
        return ImmutableMap.of((Object)"tenant", (Object)this.tenant, (Object)"sorting", (Object)this.sorting, (Object)"watch_status_codes", this.watchStatusCodes).with((Object)"severities", this.severities).with((Object)"level_numeric_equal_to", (Object)this.levelNumericEqualTo).with((Object)"level_numeric_greater_than", (Object)this.levelNumericGreaterThan).with((Object)"level_numeric_less_than", (Object)this.levelNumericLessThan).with((Object)"actions", this.actionNames).with((Object)"ranges", (Object)this.ranges).with((Object)"actionProperties", (Object)this.actionProperties);
    }

    WatchFilter getWatchFilter() {
        return new WatchFilter(this.watchId, this.watchStatusCodes, this.severities, this.actionNames, this.ranges, this.actionProperties);
    }

    String getTenant() {
        return this.tenant;
    }

    private void validateRange(String rangeName, Number equal, Number greater, Number less) {
        if (Objects.nonNull(equal) && (Objects.nonNull(greater) || Objects.nonNull(less))) {
            String message = "Incorrect search criteria for " + rangeName + ". If field equalTo is provided then both fields 'greaterThan' and 'lessThan' must be null";
            throw new ElasticsearchStatusException(message, RestStatus.BAD_REQUEST, new Object[0]);
        }
    }

    private <T> WatchFilter.Range<T> rangeOrNull(T equalTo, T greaterThan, T lessThan, String fieldName) {
        if (Objects.nonNull(equalTo) || Objects.nonNull(greaterThan) || Objects.nonNull(lessThan)) {
            return new WatchFilter.Range<T>(equalTo, greaterThan, lessThan, fieldName);
        }
        return null;
    }
}

