/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.signals.actions.summary;

import com.floragunn.codova.documents.DocNode;
import com.floragunn.codova.validation.ConfigValidationException;
import com.jayway.jsonpath.PathNotFoundException;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.Optional;
import java.util.regex.Pattern;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.common.time.DateFormatter;
import org.elasticsearch.rest.RestStatus;

class SafeDocNodeReader {
    private static final DateFormatter DATE_FORMATTER = DateFormatter.forPattern((String)"strict_date_time").withZone((ZoneId)ZoneOffset.UTC);

    private SafeDocNodeReader() {
    }

    static Long getLongValue(DocNode docNode, String key) {
        try {
            if (docNode.containsKey((Object)key)) {
                Number number = docNode.getNumber(key);
                if (number == null) {
                    return null;
                }
                return number.longValue();
            }
            return null;
        }
        catch (ConfigValidationException e) {
            throw new ElasticsearchStatusException("Key " + key + " is not an numeric value.", RestStatus.INTERNAL_SERVER_ERROR, (Throwable)e, new Object[0]);
        }
    }

    static Integer getIntValue(DocNode docNode, String key) {
        try {
            if (docNode.containsKey((Object)key)) {
                Number number = docNode.getNumber(key);
                if (number == null) {
                    return null;
                }
                return number.intValue();
            }
            return null;
        }
        catch (ConfigValidationException e) {
            throw new ElasticsearchStatusException("Key " + key + " is not an numeric value.", RestStatus.INTERNAL_SERVER_ERROR, (Throwable)e, new Object[0]);
        }
    }

    static Double getDoubleValue(DocNode docNode, String key) {
        try {
            if (docNode.containsKey((Object)key)) {
                Number number = docNode.getNumber(key);
                if (number == null) {
                    return null;
                }
                return number.doubleValue();
            }
            return null;
        }
        catch (ConfigValidationException e) {
            throw new ElasticsearchStatusException("Key " + key + " is not an numeric value.", RestStatus.INTERNAL_SERVER_ERROR, (Throwable)e, new Object[0]);
        }
    }

    static String getStringValue(DocNode node, String key) {
        return Optional.ofNullable(key).map(arg_0 -> ((DocNode)node).getAsString(arg_0)).orElse(null);
    }

    static Boolean getBooleanValue(DocNode node, String key) {
        return Optional.ofNullable(key).map(arg_0 -> ((DocNode)node).getAsString(arg_0)).map(Boolean::valueOf).orElse(null);
    }

    static Instant getInstantValue(DocNode node, String key) {
        return Optional.ofNullable(key).map(arg_0 -> ((DocNode)node).getAsString(arg_0)).map(arg_0 -> ((DateFormatter)DATE_FORMATTER).parse(arg_0)).map(Instant::from).orElse(null);
    }

    static Optional<DocNode> findSingleNodeByJsonPath(DocNode docNode, String jsonPath) {
        try {
            return Optional.ofNullable(docNode.findSingleNodeByJsonPath(jsonPath));
        }
        catch (PathNotFoundException ex) {
            return Optional.empty();
        }
    }

    static String getActionNameByPatterns(DocNode node, Pattern pattern1, Pattern pattern2) {
        String actionNameByPattern1 = SafeDocNodeReader.getActionNameByPattern(node, pattern1);
        if (actionNameByPattern1 != null) {
            return actionNameByPattern1;
        }
        return SafeDocNodeReader.getActionNameByPattern(node, pattern2);
    }

    static String getActionNameByPattern(DocNode node, Pattern pattern) {
        return Optional.ofNullable(pattern).map(p -> p.matcher(node.toJsonString())).map(matcher -> matcher.find() ? matcher.group() : null).map(s -> s.split("\\.")[1]).orElse(null);
    }
}

