/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.signals.actions.tenant.start_stop;

import com.floragunn.searchguard.user.User;
import com.floragunn.signals.Signals;
import com.floragunn.signals.SignalsTenant;
import com.floragunn.signals.actions.tenant.start_stop.StartStopTenantRequest;
import com.floragunn.signals.actions.tenant.start_stop.StartStopTenantResponse;
import java.util.concurrent.Executor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportStartStopTenantAction
extends HandledTransportAction<StartStopTenantRequest, StartStopTenantResponse> {
    private static final Logger log = LogManager.getLogger(TransportStartStopTenantAction.class);
    private final Signals signals;
    private final Client client;
    private final ThreadPool threadPool;

    @Inject
    public TransportStartStopTenantAction(Signals signals, TransportService transportService, ThreadPool threadPool, ActionFilters actionFilters, Client client) {
        super("cluster:admin:searchguard:tenant:signals:tenant/start_stop", transportService, actionFilters, StartStopTenantRequest::new, (Executor)threadPool.executor("generic"));
        this.signals = signals;
        this.client = client;
        this.threadPool = threadPool;
    }

    protected final void doExecute(Task task, StartStopTenantRequest request, ActionListener<StartStopTenantResponse> listener) {
        try {
            ThreadContext threadContext = this.threadPool.getThreadContext();
            User user = (User)threadContext.getTransient("_sg_user");
            if (user == null) {
                throw new RuntimeException("Request did not contain user");
            }
            SignalsTenant signalsTenant = this.signals.getTenant(user);
            if (signalsTenant == null) {
                throw new RuntimeException("No such tenant: " + user.getRequestedTenant());
            }
            this.threadPool.generic().submit(() -> {
                try {
                    this.signals.getSignalsSettings().update(this.client, "tenant." + signalsTenant.getName() + ".active", String.valueOf(request.isActivate()));
                    listener.onResponse((Object)new StartStopTenantResponse());
                }
                catch (Exception e) {
                    log.error("Error while start/stop tenant " + String.valueOf(signalsTenant), (Throwable)e);
                    listener.onFailure(e);
                }
            });
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }
}

