/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.signals.confconv.es;

import com.floragunn.codova.documents.DocNode;
import com.floragunn.codova.validation.ConfigValidationException;
import com.floragunn.codova.validation.ValidatingDocNode;
import com.floragunn.codova.validation.ValidationErrors;
import com.floragunn.codova.validation.errors.InvalidAttributeValue;
import com.floragunn.codova.validation.errors.MissingAttribute;
import com.floragunn.codova.validation.errors.ValidationError;
import com.floragunn.signals.confconv.ConversionResult;
import com.floragunn.signals.confconv.es.MustacheTemplateConverter;
import com.floragunn.signals.confconv.es.PainlessScriptConverter;
import com.floragunn.signals.watch.checks.Check;
import com.floragunn.signals.watch.checks.Condition;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class ConditionConverter {
    private final DocNode conditionJsonNode;

    public ConditionConverter(DocNode conditionJsonNode) {
        this.conditionJsonNode = conditionJsonNode;
    }

    public ConversionResult<List<Check>> convertToSignals() {
        ConversionResult<List<Check>> convertedCondition;
        ValidationErrors validationErrors = new ValidationErrors();
        ArrayList<Condition> result = new ArrayList<Condition>();
        if (this.conditionJsonNode.hasNonNull("never")) {
            result.add(new Condition(null, "false", null, null));
        }
        if (this.conditionJsonNode.hasNonNull("compare")) {
            convertedCondition = this.createCompareCondition(this.conditionJsonNode.getAsNode("compare"));
            result.addAll((Collection)convertedCondition.getElement());
            validationErrors.add("compare", convertedCondition.getSourceValidationErrors());
        }
        if (this.conditionJsonNode.hasNonNull("array_compare")) {
            convertedCondition = this.createArrayCompareCondition(this.conditionJsonNode.getAsNode("array_compare"));
            result.addAll((Collection)convertedCondition.getElement());
            validationErrors.add("array_compare", convertedCondition.getSourceValidationErrors());
        }
        if (this.conditionJsonNode.hasNonNull("script")) {
            convertedCondition = this.createScriptCondition(this.conditionJsonNode.getAsNode("script"));
            result.addAll((Collection)convertedCondition.getElement());
            validationErrors.add("script", convertedCondition.getSourceValidationErrors());
        }
        return new ConversionResult<List<Check>>(result, validationErrors);
    }

    private ConversionResult<List<Check>> createCompareCondition(DocNode jsonNode) {
        ValidationErrors validationErrors = new ValidationErrors();
        ArrayList<Condition> result = new ArrayList<Condition>();
        if (!jsonNode.isMap()) {
            validationErrors.add((ValidationError)new InvalidAttributeValue(null, (Object)jsonNode, (Object)"JSON Object"));
            return new ConversionResult<List<Check>>(result, validationErrors);
        }
        for (Map.Entry entry : jsonNode.toMapOfNodes().entrySet()) {
            String operand1 = (String)entry.getKey();
            if (!((DocNode)entry.getValue()).isMap()) {
                validationErrors.add((ValidationError)new InvalidAttributeValue((String)entry.getKey(), entry.getValue(), (Object)"JSON Object"));
                continue;
            }
            ConversionResult<String> convertedOperand1 = new PainlessScriptConverter(operand1).convertToSignals();
            validationErrors.add(operand1, convertedOperand1.getSourceValidationErrors());
            operand1 = convertedOperand1.getElement();
            for (Map.Entry subEntry : ((DocNode)entry.getValue()).toMapOfNodes().entrySet()) {
                Object operand2;
                String operator;
                try {
                    operator = this.operatorToPainless((String)subEntry.getKey());
                }
                catch (ConfigValidationException e) {
                    validationErrors.add((String)entry.getKey(), e);
                    continue;
                }
                if (((DocNode)subEntry.getValue()).toBasicObject() instanceof Number) {
                    operand2 = ((DocNode)subEntry.getValue()).toString();
                    result.add(new Condition(null, operand1 + " " + operator + " " + (String)operand2, null, null));
                    continue;
                }
                operand2 = ((DocNode)subEntry.getValue()).toString();
                if (((String)operand2).contains("{{")) {
                    operand2 = this.mustacheToPainless((String)operand2);
                    result.add(new Condition(null, operand1 + " " + operator + " " + (String)operand2, null, null));
                    continue;
                }
                if (((String)operand2).startsWith("<") && ((String)operand2).endsWith(">")) {
                    validationErrors.add(new ValidationError((String)entry.getKey(), "Date math is not supported by this import"));
                    operand2 = "\"" + (String)operand2 + "\"";
                    result.add(new Condition(null, operand1 + " " + operator + " " + (String)operand2, null, null));
                    continue;
                }
                operand2 = "\"" + (String)operand2 + "\"";
                result.add(new Condition(null, operand1 + " " + operator + " " + (String)operand2, null, null));
            }
        }
        return new ConversionResult<List<Check>>(result, validationErrors);
    }

    private ConversionResult<List<Check>> createArrayCompareCondition(DocNode jsonNode) {
        ValidationErrors validationErrors = new ValidationErrors();
        ArrayList<Condition> result = new ArrayList<Condition>();
        if (!jsonNode.isMap()) {
            validationErrors.add((ValidationError)new InvalidAttributeValue(null, (Object)jsonNode, (Object)"JSON Object"));
            return new ConversionResult<List<Check>>(result, validationErrors);
        }
        for (Map.Entry entry : jsonNode.toMapOfNodes().entrySet()) {
            String operand1 = (String)entry.getKey();
            ConversionResult<String> convertedOperand1 = new PainlessScriptConverter(operand1).convertToSignals();
            validationErrors.add(operand1, convertedOperand1.getSourceValidationErrors());
            operand1 = convertedOperand1.getElement();
            if (!((DocNode)entry.getValue()).isMap()) {
                validationErrors.add((ValidationError)new InvalidAttributeValue((String)entry.getKey(), entry.getValue(), (Object)"JSON Object"));
                continue;
            }
            String path = null;
            if (((DocNode)entry.getValue()).hasNonNull("path")) {
                path = ((DocNode)entry.getValue()).getAsString("path");
            }
            for (Map.Entry subEntry : ((DocNode)entry.getValue()).toMapOfNodes().entrySet()) {
                Object operand2;
                String operator;
                if (((String)subEntry.getKey()).equals("path")) continue;
                try {
                    operator = this.operatorToPainless((String)subEntry.getKey());
                }
                catch (ConfigValidationException e) {
                    validationErrors.add((String)entry.getKey(), e);
                    continue;
                }
                boolean all = false;
                if (((DocNode)subEntry.getValue()).isMap()) {
                    DocNode operand2Node = (DocNode)subEntry.getValue();
                    if (!operand2Node.hasNonNull("value")) {
                        validationErrors.add((ValidationError)new MissingAttribute((String)entry.getKey() + "." + (String)subEntry.getKey() + ".value", entry.getValue()));
                        continue;
                    }
                    if (operand2Node.get("value") instanceof Number) {
                        operand2 = operand2Node.toString();
                    } else {
                        operand2 = operand2Node.toString();
                        if (((String)operand2).contains("{{")) {
                            ConversionResult<String> convertedOperand2 = new MustacheTemplateConverter((String)operand2).convertToSignals();
                            validationErrors.add((String)entry.getKey() + "." + (String)subEntry.getKey(), convertedOperand2.getSourceValidationErrors());
                            operand2 = convertedOperand2.getElement();
                            operand2 = this.mustacheToPainless((String)operand2);
                        } else if (((String)operand2).startsWith("<") && ((String)operand2).endsWith(">")) {
                            operand2 = "\"" + (String)operand2 + "\"";
                            validationErrors.add(new ValidationError((String)entry.getKey() + "." + (String)subEntry.getKey() + ".value", "Date math is not supported by this import"));
                        } else {
                            operand2 = "\"" + (String)operand2 + "\"";
                        }
                    }
                    if (operand2Node.hasNonNull("quantifier") && operand2Node.getAsString("quantifier").equalsIgnoreCase("all")) {
                        all = true;
                    }
                } else if (((DocNode)subEntry.getValue()).toBasicObject() instanceof Number) {
                    operand2 = ((DocNode)subEntry.getValue()).toBasicObject().toString();
                } else {
                    operand2 = ((DocNode)subEntry.getValue()).toBasicObject().toString();
                    if (((String)operand2).contains("{{")) {
                        ConversionResult<String> convertedOperand2 = new MustacheTemplateConverter((String)operand2).convertToSignals();
                        validationErrors.add((String)entry.getKey() + "." + (String)subEntry.getKey(), convertedOperand2.getSourceValidationErrors());
                        operand2 = convertedOperand2.getElement();
                        operand2 = this.mustacheToPainless((String)operand2);
                    } else if (((String)operand2).startsWith("<") && ((String)operand2).endsWith(">")) {
                        operand2 = "\"" + (String)operand2 + "\"";
                        validationErrors.add(new ValidationError((String)entry.getKey(), "Date math is not supported by this import"));
                    } else {
                        operand2 = "\"" + (String)operand2 + "\"";
                    }
                }
                String matchMethod = all ? "allMatch" : "anyMatch";
                String painless = operand1 + ".stream()." + matchMethod + "(current -> current" + (String)(path != null && path.length() > 0 ? "." + path : "") + " " + operator + " " + (String)operand2 + ")";
                result.add(new Condition(null, painless, null, null));
            }
        }
        return new ConversionResult<List<Check>>(result, validationErrors);
    }

    private ConversionResult<List<Check>> createScriptCondition(DocNode jsonNode) {
        ValidationErrors validationErrors = new ValidationErrors();
        ValidatingDocNode vJsonNode = new ValidatingDocNode(jsonNode, validationErrors);
        ArrayList<Condition> result = new ArrayList<Condition>();
        if (jsonNode.isString()) {
            ConversionResult<String> convertedScript = new PainlessScriptConverter(jsonNode.toString()).convertToSignals();
            result.add(new Condition(null, convertedScript.getElement(), null, null));
            validationErrors.add(null, convertedScript.getSourceValidationErrors());
        } else if (jsonNode.isMap()) {
            if (jsonNode.hasNonNull("id")) {
                validationErrors.add(new ValidationError("id", "Script references are not supported"));
            }
            ConversionResult<String> convertedScript = new PainlessScriptConverter(vJsonNode.get("source").withDefault("").asString()).convertToSignals();
            result.add(new Condition(null, convertedScript.getElement(), vJsonNode.get("lang").asString(), null));
            validationErrors.add("source", convertedScript.getSourceValidationErrors());
        } else {
            validationErrors.add((ValidationError)new InvalidAttributeValue(null, (Object)jsonNode, (Object)"JSON object or string"));
        }
        return new ConversionResult<List<Check>>(result, validationErrors);
    }

    private String mustacheToPainless(String string) {
        StringBuilder result = new StringBuilder();
        int pos = 0;
        while (pos < string.length()) {
            int next = string.indexOf("{{", pos);
            if (next == -1) {
                if (result.length() > 0) {
                    result.append(" + ");
                }
                result.append('\"').append(this.escapeStringFromMustacheForPainless(string.substring(pos))).append('\"');
                break;
            }
            int end = string.indexOf("}}", next + 2);
            if (end == -1) {
                if (result.length() > 0) {
                    result.append(" + ");
                }
                result.append('\"').append(this.escapeStringFromMustacheForPainless(string.substring(pos))).append('\"');
                break;
            }
            if (next != pos) {
                if (result.length() > 0) {
                    result.append(" + ");
                }
                result.append('\"').append(this.escapeStringFromMustacheForPainless(string.substring(pos, next))).append('\"');
            }
            String expr = string.substring(next + 2, end);
            if (result.length() > 0) {
                result.append(" + ");
            }
            result.append(expr);
            pos = end;
        }
        return result.toString();
    }

    private String escapeStringFromMustacheForPainless(String string) {
        return string.replace("\"", "\\\"");
    }

    private String operatorToPainless(String op) throws ConfigValidationException {
        switch (op.toLowerCase()) {
            case "eq": {
                return "==";
            }
            case "not_eq": {
                return "!=";
            }
            case "gt": {
                return ">";
            }
            case "gte": {
                return ">=";
            }
            case "lt": {
                return "<";
            }
            case "lte": {
                return "<=";
            }
        }
        throw new ConfigValidationException(new ValidationError(null, "Invalid comparision operation " + op));
    }
}

