/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.signals.watch.action.handlers;

import com.floragunn.codova.documents.DocNode;
import com.floragunn.codova.documents.Format;
import com.floragunn.codova.validation.ConfigValidationException;
import com.floragunn.codova.validation.ValidatingDocNode;
import com.floragunn.codova.validation.ValidationErrors;
import com.floragunn.codova.validation.errors.InvalidAttributeValue;
import com.floragunn.codova.validation.errors.MissingAttribute;
import com.floragunn.codova.validation.errors.ValidationError;
import com.floragunn.signals.execution.ActionExecutionException;
import com.floragunn.signals.execution.WatchExecutionContext;
import com.floragunn.signals.watch.action.handlers.ActionExecutionResult;
import com.floragunn.signals.watch.action.handlers.IndexAction;
import com.floragunn.signals.watch.action.handlers.WebhookAction;
import com.floragunn.signals.watch.action.handlers.email.EmailAction;
import com.floragunn.signals.watch.action.handlers.slack.SlackAction;
import com.floragunn.signals.watch.common.WatchElement;
import com.floragunn.signals.watch.init.WatchInitializationService;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import org.elasticsearch.common.Strings;
import org.elasticsearch.xcontent.ToXContent;

public abstract class ActionHandler
extends WatchElement {
    public static final FactoryRegistry factoryRegistry = new FactoryRegistry(new IndexAction.Factory(), new WebhookAction.Factory(), new EmailAction.Factory(), new SlackAction.Factory());

    protected ActionHandler() {
    }

    public abstract ActionExecutionResult execute(WatchExecutionContext var1) throws ActionExecutionException;

    public abstract String getType();

    public String toJson() {
        return Strings.toString((ToXContent)this);
    }

    public static ActionHandler create(WatchInitializationService watchInitService, ValidatingDocNode jsonNode) throws ConfigValidationException {
        String type = null;
        if (!jsonNode.hasNonNull("type")) {
            throw new ConfigValidationException((ValidationError)new MissingAttribute("type", (Object)jsonNode));
        }
        type = jsonNode.get("type").asString();
        Factory<?> factory = factoryRegistry.get(type);
        if (factory != null) {
            return factory.create(watchInitService, jsonNode);
        }
        throw new ConfigValidationException((ValidationError)new InvalidAttributeValue("type", (Object)type, (Object)factoryRegistry.getFactoryNames(), (Object)jsonNode));
    }

    public static ActionHandler create(WatchInitializationService watchInitService, DocNode jsonNode) throws ConfigValidationException {
        String type = null;
        if (!jsonNode.hasNonNull("type")) {
            throw new ConfigValidationException((ValidationError)new MissingAttribute("type", (Object)jsonNode));
        }
        type = jsonNode.getAsString("type");
        Factory<?> factory = factoryRegistry.get(type);
        if (factory != null) {
            return factory.create(watchInitService, jsonNode);
        }
        throw new ConfigValidationException((ValidationError)new InvalidAttributeValue("type", (Object)type, (Object)factoryRegistry.getFactoryNames(), (Object)jsonNode));
    }

    public static ActionHandler parseJson(WatchInitializationService ctx, String json) throws ConfigValidationException {
        DocNode jsonNode = DocNode.parse((Format)Format.JSON).from(json);
        return ActionHandler.create(ctx, jsonNode);
    }

    public static final class FactoryRegistry {
        private final Map<String, Factory<?>> factories = new HashMap();
        private String factoryNames;

        FactoryRegistry(Factory<?> ... factories) {
            this.add(factories);
        }

        private void internalAddFactory(Factory<?> factory) {
            if (factory.getType() == null) {
                throw new IllegalArgumentException("type of factory is null: " + String.valueOf(factory));
            }
            if (this.factories.containsKey(factory.getType())) {
                throw new IllegalStateException("Factory of type " + factory.getType() + " (" + String.valueOf(factory) + ") was already installed: " + String.valueOf(this.factories));
            }
            this.factories.put(factory.getType().toLowerCase(), factory);
        }

        public void add(Factory<?> ... factories) {
            for (Factory<?> factory : factories) {
                this.internalAddFactory(factory);
            }
            this.factoryNames = String.join((CharSequence)"|", new TreeSet<String>(this.factories.keySet()));
        }

        public Factory<?> get(String type) {
            return this.factories.get(type.toLowerCase());
        }

        String getFactoryNames() {
            return this.factoryNames;
        }
    }

    public static abstract class Factory<A extends ActionHandler> {
        private final String type;

        protected Factory(String type) {
            this.type = type;
        }

        public final A create(WatchInitializationService watchInitService, DocNode jsonNode) throws ConfigValidationException {
            ValidationErrors validationErrors = new ValidationErrors();
            ValidatingDocNode vJsonNode = new ValidatingDocNode(jsonNode, validationErrors);
            A result = this.create(watchInitService, vJsonNode, validationErrors);
            validationErrors.throwExceptionForPresentErrors();
            return result;
        }

        public final A create(WatchInitializationService watchInitService, ValidatingDocNode vJsonNode) throws ConfigValidationException {
            ValidationErrors validationErrors = new ValidationErrors();
            vJsonNode = new ValidatingDocNode(vJsonNode, validationErrors);
            A result = this.create(watchInitService, vJsonNode, validationErrors);
            validationErrors.throwExceptionForPresentErrors();
            return result;
        }

        protected abstract A create(WatchInitializationService var1, ValidatingDocNode var2, ValidationErrors var3) throws ConfigValidationException;

        public String getType() {
            return this.type;
        }
    }
}

