/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.lpg.open;

import com.floragunn.searchguard.lpg.BCPGInputStream;
import com.floragunn.searchguard.lpg.InputStreamPacket;
import com.floragunn.searchguard.lpg.Packet;
import com.floragunn.searchguard.lpg.PublicKeyEncSessionPacket;
import com.floragunn.searchguard.lpg.SymmetricEncIntegrityPacket;
import com.floragunn.searchguard.lpg.UnsupportedPacketVersionException;
import com.floragunn.searchguard.lpg.open.PGPEncryptedData;
import com.floragunn.searchguard.lpg.open.PGPPublicKeyEncryptedData;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PGPEncryptedDataList
implements Iterable<PGPEncryptedData> {
    private static final Logger LOG = Logger.getLogger(PGPEncryptedDataList.class.getName());
    List<PGPEncryptedData> methods = new ArrayList<PGPEncryptedData>();
    InputStreamPacket data;

    public PGPEncryptedDataList(BCPGInputStream pIn) throws IOException {
        ArrayList<Packet> list = new ArrayList<Packet>();
        while (pIn.nextPacketTag() == 1 || pIn.nextPacketTag() == 3) {
            try {
                list.add(pIn.readPacket());
            }
            catch (UnsupportedPacketVersionException e) {
                if (!LOG.isLoggable(Level.FINE)) continue;
                LOG.fine("skipping unknown session packet: " + e.getMessage());
            }
        }
        Packet packet = pIn.readPacket();
        if (!(packet instanceof InputStreamPacket)) {
            throw new IOException("unexpected packet in stream: " + packet);
        }
        this.data = (InputStreamPacket)packet;
        for (int i = 0; i != list.size(); ++i) {
            this.methods.add(new PGPPublicKeyEncryptedData((PublicKeyEncSessionPacket)list.get(i), this.data));
        }
    }

    public boolean isIntegrityProtected() {
        return this.data instanceof SymmetricEncIntegrityPacket;
    }

    public PGPEncryptedData get(int index) {
        return this.methods.get(index);
    }

    public int size() {
        return this.methods.size();
    }

    public boolean isEmpty() {
        return this.methods.isEmpty();
    }

    public Iterator<PGPEncryptedData> getEncryptedDataObjects() {
        return this.methods.iterator();
    }

    @Override
    public Iterator<PGPEncryptedData> iterator() {
        return this.getEncryptedDataObjects();
    }
}

