/*
 * Decompiled with CFR 0.152.
 */
package com.pivovarit.function;

import com.pivovarit.function.SneakyThrowUtil;
import com.pivovarit.function.ThrowingBiFunction;
import com.pivovarit.function.exception.WrappedException;
import java.util.Objects;
import java.util.function.BiPredicate;

@FunctionalInterface
public interface ThrowingBiPredicate<T, U, E extends Exception> {
    public boolean test(T var1, U var2) throws E;

    public static <T, U> BiPredicate<T, U> unchecked(ThrowingBiPredicate<T, U, ?> predicate) {
        return Objects.requireNonNull(predicate).uncheck();
    }

    public static <T, U> BiPredicate<T, U> sneaky(ThrowingBiPredicate<T, U, ?> predicate) {
        Objects.requireNonNull(predicate);
        return (t, u) -> {
            try {
                return predicate.test(t, u);
            }
            catch (Exception e) {
                return (Boolean)SneakyThrowUtil.sneakyThrow(e);
            }
        };
    }

    default public ThrowingBiPredicate<T, U, E> and(ThrowingBiPredicate<? super T, ? super U, ? extends E> other) {
        Objects.requireNonNull(other);
        return (arg1, arg2) -> this.test(arg1, arg2) && other.test(arg1, arg2);
    }

    default public ThrowingBiPredicate<T, U, E> or(ThrowingBiPredicate<? super T, ? super U, ? extends E> other) {
        Objects.requireNonNull(other);
        return (arg1, arg2) -> this.test(arg1, arg2) || other.test(arg1, arg2);
    }

    default public ThrowingBiPredicate<T, U, E> xor(ThrowingBiPredicate<? super T, ? super U, ? extends E> other) {
        Objects.requireNonNull(other);
        return (arg1, arg2) -> this.test(arg1, arg2) ^ other.test(arg1, arg2);
    }

    default public ThrowingBiPredicate<T, U, E> negate() {
        return (arg1, arg2) -> !this.test(arg1, arg2);
    }

    default public ThrowingBiFunction<T, U, Boolean, E> asFunction() {
        return this::test;
    }

    default public BiPredicate<T, U> uncheck() {
        return (arg1, arg2) -> {
            try {
                return this.test(arg1, arg2);
            }
            catch (Exception e) {
                throw new WrappedException(e);
            }
        };
    }
}

