/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.enterprise.dlsfls;

import com.floragunn.codova.config.templates.AttributeSource;
import com.floragunn.codova.config.templates.ExpressionEvaluationException;
import com.floragunn.codova.config.templates.Template;
import com.floragunn.fluent.collections.ImmutableList;
import com.floragunn.fluent.collections.ImmutableMap;
import com.floragunn.searchguard.authz.PrivilegesEvaluationContext;
import com.floragunn.searchguard.authz.PrivilegesEvaluationException;
import com.floragunn.searchguard.authz.config.Role;
import com.floragunn.searchguard.configuration.SgDynamicConfiguration;
import com.floragunn.searchguard.enterprise.dlsfls.DlsRestriction;
import com.floragunn.searchguard.enterprise.dlsfls.RoleBasedAuthorizationBase;
import com.floragunn.searchsupport.cstate.metrics.Meter;
import com.floragunn.searchsupport.cstate.metrics.MetricsLevel;
import com.floragunn.searchsupport.meta.Meta;
import com.floragunn.searchsupport.queries.Query;
import java.util.Collection;

public class RoleBasedDocumentAuthorization
extends RoleBasedAuthorizationBase<DlsQuery, DlsRestriction> {
    public RoleBasedDocumentAuthorization(SgDynamicConfiguration<Role> roles, Meta indexMetadata, MetricsLevel metricsLevel) {
        super(roles, indexMetadata, metricsLevel, RoleBasedDocumentAuthorization::roleToRule);
    }

    static DlsQuery roleToRule(Role.Index rolePermissions) {
        Template dlsQueryTemplate = rolePermissions.getDls();
        if (dlsQueryTemplate != null) {
            return new DlsQuery((Template<Query>)dlsQueryTemplate);
        }
        return null;
    }

    @Override
    protected DlsRestriction unrestricted() {
        return DlsRestriction.NONE;
    }

    @Override
    protected DlsRestriction fullyRestricted() {
        return DlsRestriction.FULL;
    }

    @Override
    protected DlsRestriction compile(PrivilegesEvaluationContext context, Collection<DlsQuery> rules) throws PrivilegesEvaluationException {
        ImmutableList.Builder renderedQueries = new ImmutableList.Builder(rules.size());
        for (DlsQuery query : rules) {
            try {
                renderedQueries.add((Object)((Query)query.queryTemplate.render((AttributeSource)context.getUser())));
            }
            catch (ExpressionEvaluationException e) {
                throw new PrivilegesEvaluationException("Error while rendering query " + String.valueOf(query), (Throwable)e);
            }
        }
        return new DlsRestriction((ImmutableList<Query>)renderedQueries.build());
    }

    @Override
    protected String hasRestrictionsMetricName() {
        return "has_dls_restrictions";
    }

    @Override
    protected String evaluateRestrictionsMetricName() {
        return "evaluate_dls_restrictions";
    }

    @Override
    protected String componentName() {
        return "role_based_document_authorization";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DlsRestriction.IndexMap getRestriction(PrivilegesEvaluationContext context, Collection<Meta.Index> indices, Meter meter) throws PrivilegesEvaluationException {
        try (Meter subMeter = meter.detail("evaluate_dls");){
            Object object;
            if (this.staticIndexRules.rolesWithIndexWildcardWithoutRule.containsAny((Collection)context.getMappedRoles())) {
                DlsRestriction.IndexMap indexMap = DlsRestriction.IndexMap.NONE;
                return indexMap;
            }
            ImmutableMap.Builder result = new ImmutableMap.Builder(indices.size());
            int restrictedIndices = 0;
            for (Meta.Index index : indices) {
                DlsRestriction restriction = (DlsRestriction)this.getRestrictionImpl(context, index);
                if (!restriction.isUnrestricted()) {
                    ++restrictedIndices;
                }
                result.put((Object)index, (Object)restriction);
            }
            if (restrictedIndices == 0) {
                object = DlsRestriction.IndexMap.NONE;
                return object;
            }
            object = new DlsRestriction.IndexMap((ImmutableMap<Meta.Index, DlsRestriction>)result.build());
            return object;
        }
        catch (PrivilegesEvaluationException e) {
            this.componentState.addLastException("get_dls_restriction", (Throwable)e);
            throw e;
        }
        catch (RuntimeException e) {
            this.componentState.addLastException("get_dls_restriction_u", (Throwable)e);
            throw e;
        }
    }

    static class DlsQuery {
        final Template<Query> queryTemplate;

        DlsQuery(Template<Query> queryTemplate) {
            this.queryTemplate = queryTemplate;
        }

        public int hashCode() {
            return this.queryTemplate.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DlsQuery)) {
                return false;
            }
            DlsQuery other = (DlsQuery)obj;
            return !(this.queryTemplate == null ? other.queryTemplate != null : !this.queryTemplate.equals(other.queryTemplate));
        }
    }
}

