/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.forgerockds.controls;

import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.forgerockds.controls.ControlMessages;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class TransactionIDRequestControl
extends Control {
    @NotNull
    public static final String TRANSACTION_ID_REQUEST_OID = "1.3.6.1.4.1.36733.2.1.5.1";
    private static final long serialVersionUID = 7792760251213801179L;
    @NotNull
    private final String transactionID;

    public TransactionIDRequestControl(@NotNull String transactionID) {
        this(false, transactionID);
    }

    public TransactionIDRequestControl(boolean isCritical, @NotNull String transactionID) {
        super(TRANSACTION_ID_REQUEST_OID, isCritical, new ASN1OctetString(transactionID));
        this.transactionID = transactionID;
    }

    public TransactionIDRequestControl(@NotNull Control control) throws LDAPException {
        super(control);
        if (!control.hasValue()) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_TRANSACTION_ID_REQUEST_MISSING_VALUE.get());
        }
        this.transactionID = control.getValue().stringValue();
    }

    @NotNull
    public String getTransactionID() {
        return this.transactionID;
    }

    @Override
    @NotNull
    public String getControlName() {
        return ControlMessages.INFO_CONTROL_NAME_TRANSACTION_ID_REQUEST.get();
    }

    @Override
    public void toString(@NotNull StringBuilder buffer) {
        buffer.append("TransactionIDRequestControl(id='");
        buffer.append(this.transactionID);
        buffer.append("')");
    }
}

