/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.enterprise.femt.datamigration880.service.steps;

import com.floragunn.searchguard.enterprise.femt.datamigration880.service.DataMigrationContext;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.MigrationStep;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.StepExecutionStatus;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.StepResult;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.steps.StepException;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.steps.StepRepository;
import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Collectors;
import org.elasticsearch.action.admin.indices.stats.IndexStats;
import org.elasticsearch.action.admin.indices.stats.IndicesStatsResponse;
import org.elasticsearch.cluster.health.ClusterHealthStatus;

class CheckIndicesStateStep
implements MigrationStep {
    private final StepRepository repository;

    public CheckIndicesStateStep(StepRepository repository) {
        this.repository = Objects.requireNonNull(repository, "Step repository is required");
    }

    @Override
    public StepResult execute(DataMigrationContext context) throws StepException {
        String[] dataAndBackupIndices = (String[])context.getDataIndicesNames().with(context.getBackupIndices()).toArray(String[]::new);
        StringBuilder stringBuilder = new StringBuilder();
        IndicesStatsResponse response = this.repository.findIndexState(dataAndBackupIndices);
        boolean success = true;
        for (String index : dataAndBackupIndices) {
            IndexStats indexStats = response.getIndex(index);
            if (indexStats == null) {
                success = false;
                stringBuilder.append("Cannot retrieve index '").append(index).append("' status. ");
                continue;
            }
            ClusterHealthStatus indexStatsHealth = indexStats.getHealth();
            if (context.areYellowDataIndicesAllowed() && ClusterHealthStatus.YELLOW.equals((Object)indexStatsHealth) || ClusterHealthStatus.GREEN.equals((Object)indexStatsHealth)) continue;
            success = false;
            stringBuilder.append("Index '").append(index).append("' status is '").append(indexStatsHealth).append("' but GREEN status is required. ");
        }
        if (success) {
            String examinedIndices = Arrays.stream(dataAndBackupIndices).map(name -> "'" + name + "'").collect(Collectors.joining(", "));
            return new StepResult(StepExecutionStatus.OK, "Indices are healthy", "Examined indices " + examinedIndices);
        }
        return new StepResult(StepExecutionStatus.UNHEALTHY_INDICES_ERROR, "Unhealthy indices were found", stringBuilder.toString());
    }

    @Override
    public String name() {
        return "check index state";
    }
}

