/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.license.legacy;

import com.floragunn.searchguard.license.legacy.LicenseInfoNodeResponse;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.elasticsearch.action.FailedNodeException;
import org.elasticsearch.action.support.nodes.BaseNodesResponse;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;

@Deprecated
public class LicenseInfoResponse
extends BaseNodesResponse<LicenseInfoNodeResponse>
implements ToXContent {
    public LicenseInfoResponse(StreamInput in) throws IOException {
        super(in);
    }

    public LicenseInfoResponse(ClusterName clusterName, List<LicenseInfoNodeResponse> nodes, List<FailedNodeException> failures) {
        super(clusterName, nodes, failures);
    }

    public List<LicenseInfoNodeResponse> readNodesFrom(StreamInput in) throws IOException {
        return in.readCollectionAsList(LicenseInfoNodeResponse::readNodeResponse);
    }

    public void writeNodesTo(StreamOutput out, List<LicenseInfoNodeResponse> nodes) throws IOException {
        out.writeCollection(nodes);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        List allNodes = this.getNodes();
        if (allNodes.isEmpty()) {
            throw new IOException("All nodes failed");
        }
        List nonNullLicenseNodes = allNodes.stream().filter(r -> r != null && r.getLicense() != null).collect(Collectors.toList());
        builder.startObject("sg_license");
        if (nonNullLicenseNodes.size() != allNodes.size() && nonNullLicenseNodes.size() > 0) {
            license = ((LicenseInfoNodeResponse)((Object)nonNullLicenseNodes.get(0))).getLicense();
            builder.field("uid", license.getUid());
            builder.field("type", (Enum)license.getType());
            builder.field("features", (Object)license.getFeatures());
            builder.field("issue_date", license.getIssueDate());
            builder.field("expiry_date", license.getExpiryDate());
            builder.field("issued_to", license.getIssuedTo());
            builder.field("issuer", license.getIssuer());
            builder.field("start_date", license.getStartDate());
            builder.field("major_version", license.getMajorVersion());
            builder.field("cluster_name", license.getClusterName());
            builder.field("msgs", new String[]{"License mismatch across some nodes"});
            builder.field("expiry_in_days", license.getExpiresInDays());
            builder.field("is_expired", license.isExpired());
            builder.field("is_valid", false);
            builder.field("action", "Enable or disable enterprise modules on all your nodes");
            builder.field("prod_usage", "No");
            builder.field("license_required", true);
            builder.field("allowed_node_count_per_cluster", license.getAllowedNodeCount() > 1500 ? "unlimited" : String.valueOf(license.getAllowedNodeCount()));
        } else if (nonNullLicenseNodes.size() == 0) {
            builder.field("msgs", new String[]{"No license required because enterprise modules not enabled."});
            builder.field("license_required", false);
        } else {
            license = ((LicenseInfoNodeResponse)((Object)nonNullLicenseNodes.get(0))).getLicense();
            builder.field("uid", license.getUid());
            builder.field("type", (Enum)license.getType());
            builder.field("features", (Object)license.getFeatures());
            builder.field("issue_date", license.getIssueDate());
            builder.field("expiry_date", license.getExpiryDate());
            builder.field("issued_to", license.getIssuedTo());
            builder.field("issuer", license.getIssuer());
            builder.field("start_date", license.getStartDate());
            builder.field("major_version", license.getMajorVersion());
            builder.field("cluster_name", license.getClusterName());
            builder.field("msgs", license.getMsgs());
            builder.field("expiry_in_days", license.getExpiresInDays());
            builder.field("is_expired", license.isExpired());
            builder.field("is_valid", license.isValid());
            builder.field("action", license.getAction());
            builder.field("prod_usage", license.getProdUsage());
            builder.field("license_required", true);
            builder.field("allowed_node_count_per_cluster", license.getAllowedNodeCount() > 1500 ? "unlimited" : String.valueOf(license.getAllowedNodeCount()));
        }
        builder.endObject();
        builder.startObject("modules");
        LinkedList<ModuleInfo> mod0 = new LinkedList<ModuleInfo>(((LicenseInfoNodeResponse)((Object)allNodes.get(0))).getModules());
        HashSet<String> encounteredTypes = new HashSet<String>();
        for (ModuleInfo moduleInfo : mod0) {
            Map<String, String> infoAsMap = moduleInfo.getAsMap();
            Object type = moduleInfo.getModuleType().name();
            int count = 0;
            while (encounteredTypes.contains(type)) {
                type = (String)type + "_" + ++count;
            }
            encounteredTypes.add((String)type);
            builder.field((String)type, infoAsMap);
        }
        boolean mismatch = false;
        LinkedList<String> mismatchedNodes = new LinkedList<String>();
        block2: for (LicenseInfoNodeResponse node : allNodes) {
            for (ModuleInfo nodeModuleInfo : node.getModules()) {
                if (mod0.contains(nodeModuleInfo)) continue;
                mismatch = true;
                mismatchedNodes.add(node.getNode().getName());
                continue block2;
            }
        }
        builder.endObject();
        builder.startObject("compatibility");
        builder.field("modules_mismatch", mismatch);
        builder.endObject();
        return builder;
    }

    public String toString() {
        return Strings.toString((ToXContent)this, (boolean)true, (boolean)true);
    }

    @Deprecated
    static class ModuleInfo
    implements Writeable {
        private ModuleType moduleType;
        private String classname;
        private String classpath = "";
        private String version = "";
        private String buildTime = "";
        private String gitsha1 = "";

        public ModuleInfo(ModuleType moduleType, String classname) {
            assert (moduleType != null);
            this.moduleType = moduleType;
            this.classname = classname;
        }

        public ModuleInfo(StreamInput in) throws IOException {
            this.moduleType = (ModuleType)in.readEnum(ModuleType.class);
            this.classname = in.readString();
            this.classpath = in.readString();
            this.version = in.readString();
            this.buildTime = in.readString();
            this.gitsha1 = in.readString();
            assert (this.moduleType != null);
        }

        public void setClasspath(String classpath) {
            this.classpath = classpath;
        }

        public void setVersion(String version) {
            this.version = version;
        }

        public void setBuildTime(String buildTime) {
            this.buildTime = buildTime;
        }

        public String getGitsha1() {
            return this.gitsha1;
        }

        public void setGitsha1(String gitsha1) {
            this.gitsha1 = gitsha1;
        }

        public ModuleType getModuleType() {
            return this.moduleType;
        }

        public Map<String, String> getAsMap() {
            HashMap<String, String> infoMap = new HashMap<String, String>();
            infoMap.put("type", this.moduleType.name());
            infoMap.put("description", this.moduleType.getDescription());
            infoMap.put("is_enterprise", this.moduleType.isEnterprise().toString());
            infoMap.put("default_implementation", this.moduleType.getDefaultImplClass());
            infoMap.put("actual_implementation", this.classname);
            infoMap.put("version", this.version);
            infoMap.put("buildTime", this.buildTime);
            infoMap.put("gitsha1", this.gitsha1);
            return infoMap;
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeEnum((Enum)this.moduleType);
            out.writeString(this.classname);
            out.writeString(this.classpath);
            out.writeString(this.version);
            out.writeString(this.buildTime);
            out.writeString(this.gitsha1);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.buildTime == null ? 0 : this.buildTime.hashCode());
            result = 31 * result + (this.classname == null ? 0 : this.classname.hashCode());
            result = 31 * result + (this.moduleType == null ? 0 : this.moduleType.hashCode());
            result = 31 * result + (this.version == null ? 0 : this.version.hashCode());
            result = 31 * result + (this.gitsha1 == null ? 0 : this.gitsha1.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof ModuleInfo)) {
                return false;
            }
            ModuleInfo other = (ModuleInfo)obj;
            if (this.buildTime == null ? other.buildTime != null : !this.buildTime.equals(other.buildTime)) {
                return false;
            }
            if (this.classname == null ? other.classname != null : !this.classname.equals(other.classname)) {
                return false;
            }
            if (!this.moduleType.equals((Object)other.moduleType)) {
                return false;
            }
            if (this.version == null ? other.version != null : !this.version.equals(other.version)) {
                return false;
            }
            return !(this.gitsha1 == null ? other.gitsha1 != null : !this.gitsha1.equals(other.gitsha1));
        }

        public String toString() {
            return "Module [type=" + this.moduleType.name() + ", implementing class=" + this.classname + "]";
        }
    }

    @Deprecated
    static enum ModuleType {
        REST_MANAGEMENT_API("REST Management API", "com.floragunn.searchguard.dlic.rest.api.SearchGuardRestApiActions", Boolean.TRUE),
        DLSFLS("Document- and Field-Level Security", "com.floragunn.searchguard.dlsfls.legacy.lucene.SearchGuardFlsDlsIndexSearcherWrapper", Boolean.TRUE),
        AUDITLOG("Audit Logging", "com.floragunn.searchguard.auditlog.impl.AuditLogImpl", Boolean.TRUE),
        MULTITENANCY("Kibana Multitenancy", "com.floragunn.searchguard.enterprise.femt.FeMultiTenancyModule", Boolean.TRUE),
        LDAP_AUTHENTICATION_BACKEND("LDAP authentication backend", "com.floragunn.dlic.auth.ldap.backend.LDAPAuthenticationBackend", Boolean.TRUE),
        LDAP_AUTHORIZATION_BACKEND("LDAP authorization backend", "com.floragunn.dlic.auth.ldap.backend.LDAPAuthorizationBackend", Boolean.TRUE),
        KERBEROS_AUTHENTICATION_BACKEND("Kerberos authentication backend", "com.floragunn.searchguard.enterprise.auth.kerberos.HTTPSpnegoAuthenticator", Boolean.TRUE),
        JWT_AUTHENTICATION_BACKEND("JWT authentication backend", "com.floragunn.dlic.auth.http.jwt.HTTPJwtAuthenticator", Boolean.TRUE),
        OPENID_AUTHENTICATION_BACKEND("OpenID authentication backend", "com.floragunn.dlic.auth.http.jwt.keybyoidc.HTTPJwtKeyByOpenIdConnectAuthenticator", Boolean.TRUE),
        SAML_AUTHENTICATION_BACKEND("SAML authentication backend", "com.floragunn.dlic.auth.http.saml.HTTPSamlAuthenticator", Boolean.TRUE),
        INTERNAL_USERS_AUTHENTICATION_BACKEND("Internal users authentication backend", "", Boolean.FALSE),
        HTTP_BASIC_AUTHENTICATOR("HTTP Basic Authenticator", "", Boolean.FALSE),
        HTTP_CLIENTCERT_AUTHENTICATOR("HTTP Client Certificate Authenticator", "", Boolean.FALSE),
        CUSTOM_HTTP_AUTHENTICATOR("Custom HTTP authenticator", null, Boolean.TRUE),
        CUSTOM_AUTHENTICATION_BACKEND("Custom authentication backend", null, Boolean.TRUE),
        CUSTOM_AUTHORIZATION_BACKEND("Custom authorization backend", null, Boolean.TRUE),
        CUSTOM_INTERCLUSTER_REQUEST_EVALUATOR("Intercluster Request Evaluator", null, Boolean.FALSE),
        CUSTOM_PRINCIPAL_EXTRACTOR("TLS Principal Extractor", null, Boolean.FALSE),
        AUTH_TOKEN_AUTHENTICATION_BACKEND("Search Guard Auth Token authentication backend", "com.floragunn.searchguard.authtoken.AuthTokenAuthenticationBackend", Boolean.TRUE),
        AUTH_TOKEN_HTTP_AUTHENTICATOR("Search Guard Auth Token HTTP authenticator", "com.floragunn.searchguard.authtoken.AuthTokenHttpJwtAuthenticator", Boolean.TRUE),
        SG_STD_MODULE("Search Guard Standard Module", null, Boolean.FALSE),
        UNKNOWN("Unknown type", null, Boolean.TRUE);

        private String description;
        private String defaultImplClass;
        private Boolean isEnterprise = Boolean.TRUE;

        private ModuleType(String description, String defaultImplClass, Boolean isEnterprise) {
            this.description = description;
            this.defaultImplClass = defaultImplClass;
            this.isEnterprise = isEnterprise;
        }

        public String getDescription() {
            return this.description;
        }

        public String getDefaultImplClass() {
            return this.defaultImplClass;
        }

        public Boolean isEnterprise() {
            return this.isEnterprise;
        }
    }
}

