/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.privileges.extended_action_handling;

import com.floragunn.searchguard.authz.PrivilegesEvaluationContext;
import com.floragunn.searchguard.authz.actions.Action;
import com.floragunn.searchguard.privileges.extended_action_handling.ResourceOwnerService;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.support.ActionFilterChain;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.tasks.Task;

public class ExtendedActionHandlingService {
    private final ResourceOwnerService resourceOwnerService;

    public ExtendedActionHandlingService(ResourceOwnerService resourceOwnerService, Settings settings) {
        this.resourceOwnerService = resourceOwnerService;
    }

    public <Request extends ActionRequest, Response extends ActionResponse> void apply(Action.WellKnownAction<Request, ?, ?> actionConfig, Task task, String action, PrivilegesEvaluationContext context, Request actionRequest, ActionListener<Response> actionListener, ActionFilterChain<Request, Response> chain) {
        actionListener = this.applyPostAction(actionConfig, context, actionRequest, actionListener);
        this.applyPreAction(actionConfig, task, action, context, actionRequest, actionListener, chain);
    }

    public <Request extends ActionRequest, Response extends ActionResponse> void applyPreAction(Action.WellKnownAction<Request, ?, ?> actionConfig, Task task, String action, PrivilegesEvaluationContext context, Request actionRequest, ActionListener<Response> listener, ActionFilterChain<Request, Response> chain) {
        ActionFilterChain<Request, Response> extendedChain = chain;
        extendedChain = this.resourceOwnerService.applyOwnerCheckPreAction(actionConfig, context, actionRequest, listener, extendedChain);
        extendedChain.proceed(task, action, actionRequest, listener);
    }

    public <Request extends ActionRequest, R extends ActionResponse> ActionListener<R> applyPostAction(Action.WellKnownAction<Request, ?, ?> actionConfig, PrivilegesEvaluationContext context, Request actionRequest, ActionListener<R> actionListener) {
        if (actionConfig.getResources() != null) {
            if (actionConfig.getResources().getCreatesResource() != null) {
                actionListener = this.resourceOwnerService.applyCreatePostAction(actionConfig, context.getUser(), actionListener);
            }
            for (Action.WellKnownAction.Resource resource : actionConfig.getResources().getUsesResources()) {
                if (!resource.isDeleteAction()) continue;
                actionListener = this.resourceOwnerService.applyDeletePostAction(actionConfig, resource, context.getUser(), actionRequest, actionListener);
            }
        }
        return actionListener;
    }

    public abstract class PreAction<Request extends ActionRequest, Response extends ActionResponse>
    implements ActionFilterChain<Request, Response> {
        protected final ActionFilterChain<Request, Response> next;

        PreAction(ActionFilterChain<Request, Response> next) {
            this.next = next;
        }
    }
}

