/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.lpg.open.operator.bc;

import com.floragunn.searchguard.lpg.AsymmetricKeyParameter;
import com.floragunn.searchguard.lpg.PublicKeyPacket;
import com.floragunn.searchguard.lpg.RSAKeyParameters;
import com.floragunn.searchguard.lpg.RSAPublicBCPGKey;
import com.floragunn.searchguard.lpg.open.PGPException;
import com.floragunn.searchguard.lpg.open.PGPPublicKey;

public class BcPGPKeyConverter {
    public AsymmetricKeyParameter getPublicKey(PGPPublicKey publicKey) throws PGPException {
        PublicKeyPacket publicPk = publicKey.getPublicKeyPacket();
        try {
            switch (publicPk.getAlgorithm()) {
                case 1: 
                case 2: 
                case 3: {
                    RSAPublicBCPGKey rsaK = (RSAPublicBCPGKey)publicPk.getKey();
                    return new RSAKeyParameters(false, rsaK.getModulus(), rsaK.getPublicExponent());
                }
            }
            throw new PGPException("unknown public key algorithm encountered: " + publicKey.getAlgorithm());
        }
        catch (PGPException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PGPException("exception constructing public key", e);
        }
    }
}

