/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.enterprise.dlsfls;

import com.floragunn.codova.documents.DocNode;
import com.floragunn.codova.documents.Document;
import com.floragunn.codova.documents.Parser;
import com.floragunn.codova.documents.UnexpectedDocumentStructureException;
import com.floragunn.codova.documents.patch.PatchableDocument;
import com.floragunn.codova.validation.ConfigValidationException;
import com.floragunn.codova.validation.ValidatingDocNode;
import com.floragunn.codova.validation.ValidationErrors;
import com.floragunn.codova.validation.ValidationResult;
import com.floragunn.codova.validation.errors.ValidationError;
import com.floragunn.searchguard.configuration.CType;
import com.floragunn.searchguard.configuration.ConfigurationRepository;
import com.floragunn.searchsupport.cstate.metrics.MetricsLevel;
import com.google.common.io.BaseEncoding;
import java.util.Arrays;

public class DlsFlsConfig
implements PatchableDocument<DlsFlsConfig> {
    public static CType<DlsFlsConfig> TYPE = new CType("authz_dlsfls", "Document Level Security and Field Level Security", 10011, DlsFlsConfig.class, DlsFlsConfig::parse, CType.Storage.OPTIONAL, CType.Arity.SINGLE);
    public static final DlsFlsConfig DEFAULT = new DlsFlsConfig(null, FieldMasking.DEFAULT, false, MetricsLevel.BASIC, false, Mode.ADAPTIVE, false);
    private final DocNode source;
    private final FieldMasking fieldMasking;
    private final boolean debugEnabled;
    private final MetricsLevel metricsLevel;
    private final boolean nowAllowedInQueries;
    private final Mode dlsMode;
    private final boolean forceMinDocCountToOne;

    DlsFlsConfig(DocNode source, FieldMasking fieldMasking, boolean debugEnabled, MetricsLevel metricsLevel, boolean nowAllowedInQueries, Mode dlsMode, boolean forceMinDocCountToOne) {
        this.source = source;
        this.fieldMasking = fieldMasking;
        this.debugEnabled = debugEnabled;
        this.metricsLevel = metricsLevel;
        this.nowAllowedInQueries = nowAllowedInQueries;
        this.dlsMode = dlsMode;
        this.forceMinDocCountToOne = forceMinDocCountToOne;
    }

    public static ValidationResult<DlsFlsConfig> parse(DocNode docNode, Parser.Context context) {
        ValidatingDocNode vNode;
        ValidationErrors validationErrors = new ValidationErrors();
        try {
            vNode = new ValidatingDocNode(docNode.splitDottedAttributeNamesToTree(), validationErrors);
        }
        catch (UnexpectedDocumentStructureException e) {
            return new ValidationResult(e.getValidationErrors());
        }
        FieldMasking fieldMasking = (FieldMasking)vNode.get("field_anonymization").withDefault((Object)FieldMasking.DEFAULT).by(FieldMasking::parse);
        boolean debugEnabled = vNode.get("debug").withDefault(false).asBoolean();
        MetricsLevel metricsLevel = (MetricsLevel)vNode.get("metrics").withDefault((Enum)MetricsLevel.BASIC).asEnum(MetricsLevel.class);
        vNode.get("use_impl").withDefault("flx").asString();
        boolean nowAllowedInQueries = vNode.get("dls.allow_now").withDefault(false).asBoolean();
        Mode dlsMode = (Mode)vNode.get("dls.mode").withDefault((Enum)Mode.ADAPTIVE).asEnum(Mode.class);
        boolean forceMinDocCountToOne = vNode.get("dls.force_min_doc_count_to_1").withDefault(false).asBoolean();
        vNode.checkForUnusedAttributes();
        if (!validationErrors.hasErrors()) {
            return new ValidationResult((Object)new DlsFlsConfig(docNode, fieldMasking, debugEnabled, metricsLevel, nowAllowedInQueries, dlsMode, forceMinDocCountToOne));
        }
        return new ValidationResult(validationErrors);
    }

    public Object toBasicObject() {
        return this.source;
    }

    public DlsFlsConfig parseI(DocNode docNode, Parser.Context context) throws ConfigValidationException {
        return (DlsFlsConfig)DlsFlsConfig.parse(docNode, (Parser.Context)((ConfigurationRepository.Context)context)).get();
    }

    public boolean isDebugEnabled() {
        return this.debugEnabled;
    }

    public MetricsLevel getMetricsLevel() {
        return this.metricsLevel;
    }

    public boolean isNowAllowedInQueries() {
        return this.nowAllowedInQueries;
    }

    public FieldMasking getFieldMasking() {
        return this.fieldMasking;
    }

    public boolean isForceMinDocCountToOne() {
        return this.forceMinDocCountToOne;
    }

    public Mode getDlsMode() {
        return this.dlsMode;
    }

    public static class FieldMasking
    implements Document<FieldMasking> {
        static final String DEFAULT_SALT = "7A4EB67D40536EB6B107AF3202EA6275";
        static final String DEFAULT_PERSONALISATION = "searchguard-flx1";
        public static final FieldMasking DEFAULT = new FieldMasking(null, FieldMasking.bytesFromHex("7A4EB67D40536EB6B107AF3202EA6275"), "searchguard-flx1".getBytes(), null);
        private final DocNode source;
        private final byte[] salt;
        private final byte[] personalization;
        private final String prefix;

        public FieldMasking(DocNode source, byte[] salt, byte[] personalization, String prefix) {
            this.source = source;
            this.salt = salt;
            this.personalization = personalization;
            this.prefix = prefix;
        }

        public static FieldMasking parse(DocNode docNode, Parser.Context context) throws ConfigValidationException {
            ValidationErrors validationErrors = new ValidationErrors();
            ValidatingDocNode vNode = new ValidatingDocNode(docNode, validationErrors);
            byte[] salt = (byte[])vNode.get("salt").withDefault((Object)FieldMasking.DEFAULT.salt).byString(s -> FieldMasking.bytesFromHex(s));
            byte[] personalization = (byte[])vNode.get("personalisation").withDefault((Object)FieldMasking.DEFAULT.personalization).byString(s -> s.getBytes());
            String prefix = vNode.get("prefix").asString();
            if (salt.length != 16) {
                validationErrors.add(new ValidationError("salt", "Must define exactly 16 bytes using a 32 character hexadecimal string"));
            }
            if (personalization.length != 16) {
                personalization = Arrays.copyOf(personalization, 16);
            }
            vNode.checkForUnusedAttributes();
            validationErrors.throwExceptionForPresentErrors();
            return new FieldMasking(docNode, salt, personalization, prefix);
        }

        private static byte[] bytesFromHex(String hexString) {
            return BaseEncoding.base16().decode((CharSequence)hexString);
        }

        public Object toBasicObject() {
            return this.source;
        }

        public DocNode getSource() {
            return this.source;
        }

        public byte[] getSalt() {
            return this.salt;
        }

        public byte[] getPersonalization() {
            return this.personalization;
        }

        public String getPrefix() {
            return this.prefix;
        }
    }

    public static enum Mode {
        ADAPTIVE,
        LUCENE_LEVEL,
        FILTER_LEVEL;

    }
}

