/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.signals.truststore.service;

import com.floragunn.codova.validation.ConfigValidationException;
import com.floragunn.codova.validation.errors.ValidationError;
import com.floragunn.fluent.collections.ImmutableList;
import com.floragunn.searchsupport.action.StandardRequests;
import com.floragunn.searchsupport.action.StandardResponse;
import com.floragunn.signals.truststore.rest.CertificateRepresentation;
import com.floragunn.signals.truststore.rest.CreateOrReplaceTruststoreAction;
import com.floragunn.signals.truststore.rest.TruststoreRepresentation;
import com.floragunn.signals.truststore.service.CertificateParser;
import com.floragunn.signals.truststore.service.ConversionService;
import com.floragunn.signals.truststore.service.NoSuchTruststoreException;
import com.floragunn.signals.truststore.service.persistence.TruststoreData;
import com.floragunn.signals.truststore.service.persistence.TruststoreRepository;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

public class TruststoreCrudService {
    private final CertificateParser certificateParser;
    private final ConversionService conversionService;
    private final TruststoreRepository truststoreRepository;

    public TruststoreCrudService(TruststoreRepository truststoreRepository) {
        this.truststoreRepository = Objects.requireNonNull(truststoreRepository, "Repository must not be null");
        this.certificateParser = new CertificateParser();
        this.conversionService = new ConversionService();
    }

    public StandardResponse createOrReplace(CreateOrReplaceTruststoreAction.CreateOrReplaceTruststoreRequest request) throws ConfigValidationException {
        TruststoreRepresentation representation = this.createUploadCertificateResponse(request);
        TruststoreData truststoreData = this.conversionService.representationToTruststoreData(representation);
        String truststoreId = request.getId();
        this.truststoreRepository.createOrReplace(truststoreId, truststoreData);
        return new StandardResponse(200).data(representation.toBasicObject());
    }

    private TruststoreRepresentation createUploadCertificateResponse(CreateOrReplaceTruststoreAction.CreateOrReplaceTruststoreRequest request) throws ConfigValidationException {
        List<String> certificates = request.getCertificates();
        if (certificates.isEmpty()) {
            ValidationError error = new ValidationError(null, "Cannot extract certificates from provided PEM string.");
            throw new ConfigValidationException(error);
        }
        ImmutableList<CertificateRepresentation> certificateRepresentations = this.certificateParser.parse(certificates);
        return new TruststoreRepresentation(request.getId(), request.getName(), request.getPem(), certificateRepresentations);
    }

    public StandardResponse findOne(StandardRequests.IdRequest request) throws NoSuchTruststoreException {
        Objects.requireNonNull(request, "Get truststore request is required");
        String notFoundMessage = "Truststore with id " + request.getId() + " not found.";
        return this.truststoreRepository.findOneById(request.getId()).map(this.conversionService::truststoreDataToRepresentation).map(TruststoreRepresentation::toBasicObject).map(truststoreRepresentation -> new StandardResponse(200).data(truststoreRepresentation)).orElseThrow(() -> new NoSuchTruststoreException(notFoundMessage));
    }

    public StandardResponse findAll() {
        List truststores = this.truststoreRepository.findAll().stream().map(this.conversionService::truststoreDataToRepresentation).map(TruststoreRepresentation::toBasicObject).collect(Collectors.toList());
        return new StandardResponse(200).data(truststores);
    }

    public StandardResponse delete(StandardRequests.IdRequest request) {
        if (this.truststoreRepository.isTruststoreUsedByAnyWatch(request.getId())) {
            return new StandardResponse(409).error("The truststore is still in use");
        }
        boolean deleted = this.truststoreRepository.deleteById(request.getId());
        return deleted ? new StandardResponse(200) : new StandardResponse(404);
    }

    List<TruststoreData> loadAll() {
        return this.truststoreRepository.findAll();
    }

    Optional<TruststoreData> findOneById(String truststoreId) {
        return this.truststoreRepository.findOneById(truststoreId);
    }
}

