/*
 * Decompiled with CFR 0.152.
 */
package com.pivovarit.function;

import com.pivovarit.function.SneakyThrowUtil;
import com.pivovarit.function.ThrowingFunction;
import com.pivovarit.function.exception.WrappedException;
import java.util.Objects;
import java.util.function.UnaryOperator;

@FunctionalInterface
public interface ThrowingUnaryOperator<T, E extends Exception>
extends ThrowingFunction<T, T, E> {
    public static <T> UnaryOperator<T> unchecked(ThrowingUnaryOperator<T, ?> operator) {
        return Objects.requireNonNull(operator).uncheck();
    }

    public static <T> UnaryOperator<T> sneaky(ThrowingUnaryOperator<T, ?> operator) {
        Objects.requireNonNull(operator);
        return t -> {
            try {
                return operator.apply(t);
            }
            catch (Exception e) {
                return SneakyThrowUtil.sneakyThrow(e);
            }
        };
    }

    default public UnaryOperator<T> uncheck() {
        return t -> {
            try {
                return this.apply(t);
            }
            catch (Exception e) {
                throw new WrappedException(e);
            }
        };
    }
}

