/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.lpg;

import com.floragunn.searchguard.lpg.Arrays;
import com.floragunn.searchguard.lpg.BCPGInputStream;
import com.floragunn.searchguard.lpg.InputStreamPacket;
import com.floragunn.searchguard.lpg.StreamUtil;
import com.floragunn.searchguard.lpg.Strings;
import java.io.IOException;

public class LiteralDataPacket
extends InputStreamPacket {
    int format;
    byte[] fileName;
    long modDate;

    LiteralDataPacket(BCPGInputStream in) throws IOException {
        this(in, false);
    }

    LiteralDataPacket(BCPGInputStream in, boolean newPacketFormat) throws IOException {
        super(in, 11, newPacketFormat);
        this.format = in.read();
        int l = in.read();
        this.fileName = new byte[l];
        for (int i = 0; i != this.fileName.length; ++i) {
            int ch = in.read();
            if (ch < 0) {
                throw new IOException("literal data truncated in header");
            }
            this.fileName[i] = (byte)ch;
        }
        this.modDate = StreamUtil.readTime(in);
        if (this.modDate < 0L) {
            throw new IOException("literal data truncated in header");
        }
    }

    public int getFormat() {
        return this.format;
    }

    public long getModificationTime() {
        return this.modDate;
    }

    public String getFileName() {
        return Strings.fromUTF8ByteArray(this.fileName);
    }

    public byte[] getRawFileName() {
        return Arrays.clone(this.fileName);
    }
}

