/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.lpg;

import com.floragunn.searchguard.lpg.StreamUtil;
import com.floragunn.searchguard.lpg.UserAttributeSubpacket;
import com.floragunn.searchguard.lpg.UserAttributeSubpacketTags;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

public class UserAttributeSubpacketInputStream
extends InputStream
implements UserAttributeSubpacketTags {
    InputStream in;

    public UserAttributeSubpacketInputStream(InputStream in) {
        this.in = in;
    }

    @Override
    public int available() throws IOException {
        return this.in.available();
    }

    @Override
    public int read() throws IOException {
        return this.in.read();
    }

    private void readFully(byte[] buf, int off, int len) throws IOException {
        if (len > 0) {
            int b = this.read();
            if (b < 0) {
                throw new EOFException();
            }
            buf[off] = (byte)b;
            ++off;
            --len;
        }
        while (len > 0) {
            int l = this.in.read(buf, off, len);
            if (l < 0) {
                throw new EOFException();
            }
            off += l;
            len -= l;
        }
    }

    public UserAttributeSubpacket readPacket() throws IOException {
        boolean[] flags = new boolean[3];
        int bodyLen = StreamUtil.readBodyLen(this, flags);
        if (flags[StreamUtil.flag_eof]) {
            return null;
        }
        if (flags[StreamUtil.flag_partial]) {
            throw new IOException("unrecognised length reading user attribute sub packet");
        }
        boolean longLength = flags[StreamUtil.flag_isLongLength];
        int tag = this.in.read();
        if (tag < 0) {
            throw new EOFException("unexpected EOF reading user attribute sub packet");
        }
        byte[] data = new byte[bodyLen - 1];
        this.readFully(data, 0, data.length);
        int type = tag;
        return new UserAttributeSubpacket(type, longLength, data);
    }
}

