/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.lpg.open;

import com.floragunn.searchguard.lpg.UserAttributeSubpacket;
import com.floragunn.searchguard.lpg.open.PGPException;
import com.floragunn.searchguard.lpg.open.PGPPublicKey;
import com.floragunn.searchguard.lpg.open.PGPRuntimeOperationException;
import com.floragunn.searchguard.lpg.open.PGPUserAttributeSubpacketVector;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

abstract class PGPDefaultSignatureGenerator {
    protected byte lastb;
    protected OutputStream sigOut;
    protected int sigType;
    protected final int version;

    public PGPDefaultSignatureGenerator(int version) {
        this.version = version;
    }

    public void update(byte b) {
        if (this.sigType == 1) {
            if (b == 13) {
                this.byteUpdate((byte)13);
                this.byteUpdate((byte)10);
            } else if (b == 10) {
                if (this.lastb != 13) {
                    this.byteUpdate((byte)13);
                    this.byteUpdate((byte)10);
                }
            } else {
                this.byteUpdate(b);
            }
            this.lastb = b;
        } else {
            this.byteUpdate(b);
        }
    }

    public void update(byte[] b) {
        this.update(b, 0, b.length);
    }

    public void update(byte[] b, int off, int len) {
        if (this.sigType == 1) {
            int finish = off + len;
            for (int i = off; i != finish; ++i) {
                this.update(b[i]);
            }
        } else {
            this.blockUpdate(b, off, len);
        }
    }

    private void byteUpdate(byte b) {
        try {
            this.sigOut.write(b);
        }
        catch (IOException e) {
            throw new PGPRuntimeOperationException(e.getMessage(), e);
        }
    }

    protected void blockUpdate(byte[] block, int off, int len) {
        try {
            this.sigOut.write(block, off, len);
        }
        catch (IOException e) {
            throw new PGPRuntimeOperationException("unable to update signature: " + e.getMessage(), e);
        }
    }

    protected void updateWithIdData(int header, byte[] idBytes) {
        this.update((byte)header);
        this.update((byte)(idBytes.length >> 24));
        this.update((byte)(idBytes.length >> 16));
        this.update((byte)(idBytes.length >> 8));
        this.update((byte)idBytes.length);
        this.update(idBytes);
    }

    protected void updateWithPublicKey(PGPPublicKey key) throws PGPException {
        byte[] keyBytes = this.getEncodedPublicKey(key);
        if (this.version == 4) {
            this.update((byte)-103);
            this.update((byte)(keyBytes.length >> 8));
            this.update((byte)keyBytes.length);
        } else if (this.version == 5) {
            this.update((byte)-102);
            this.update((byte)(keyBytes.length >> 24));
            this.update((byte)(keyBytes.length >> 16));
            this.update((byte)(keyBytes.length >> 8));
            this.update((byte)keyBytes.length);
        } else if (this.version == 6) {
            this.update((byte)-101);
            this.update((byte)(keyBytes.length >> 24));
            this.update((byte)(keyBytes.length >> 16));
            this.update((byte)(keyBytes.length >> 8));
            this.update((byte)keyBytes.length);
        }
        this.update(keyBytes);
    }

    private byte[] getEncodedPublicKey(PGPPublicKey pubKey) throws PGPException {
        byte[] keyBytes;
        try {
            keyBytes = pubKey.publicPk.getEncodedContents();
        }
        catch (IOException e) {
            throw new PGPException("exception preparing key.", e);
        }
        return keyBytes;
    }

    protected void getAttributesHash(PGPUserAttributeSubpacketVector userAttributes) throws PGPException {
        try {
            ByteArrayOutputStream bOut = new ByteArrayOutputStream();
            UserAttributeSubpacket[] packets = userAttributes.toSubpacketArray();
            for (int i = 0; i != packets.length; ++i) {
                packets[i].encode(bOut);
            }
            this.updateWithIdData(209, bOut.toByteArray());
        }
        catch (IOException e) {
            throw new PGPException("cannot encode subpacket array", e);
        }
    }
}

