/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.lpg.open;

import com.floragunn.searchguard.lpg.BCPGInputStream;
import com.floragunn.searchguard.lpg.KeyIdentifier;
import com.floragunn.searchguard.lpg.Packet;
import com.floragunn.searchguard.lpg.PacketFormat;
import com.floragunn.searchguard.lpg.SignaturePacket;
import com.floragunn.searchguard.lpg.TrustPacket;
import com.floragunn.searchguard.lpg.UnsupportedPacketVersionException;
import com.floragunn.searchguard.lpg.UserAttributePacket;
import com.floragunn.searchguard.lpg.UserDataPacket;
import com.floragunn.searchguard.lpg.UserIDPacket;
import com.floragunn.searchguard.lpg.open.PGPPublicKey;
import com.floragunn.searchguard.lpg.open.PGPSignature;
import com.floragunn.searchguard.lpg.open.PGPUserAttributeSubpacketVector;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class PGPKeyRing {
    private static final Logger LOG = Logger.getLogger(PGPKeyRing.class.getName());

    PGPKeyRing() {
    }

    static TrustPacket readOptionalTrustPacket(BCPGInputStream pIn) throws IOException {
        int tag = pIn.skipMarkerAndPaddingPackets();
        return tag == 12 ? (TrustPacket)pIn.readPacket() : null;
    }

    static List<PGPSignature> readSignaturesAndTrust(BCPGInputStream pIn) throws IOException {
        ArrayList<PGPSignature> sigList = new ArrayList<PGPSignature>();
        while (pIn.skipMarkerAndPaddingPackets() == 2) {
            try {
                SignaturePacket signaturePacket = (SignaturePacket)pIn.readPacket();
                TrustPacket trustPacket = PGPKeyRing.readOptionalTrustPacket(pIn);
                sigList.add(new PGPSignature(signaturePacket, trustPacket));
            }
            catch (UnsupportedPacketVersionException e) {
                if (!LOG.isLoggable(Level.FINE)) continue;
                LOG.fine("skipping unknown signature: " + e.getMessage());
            }
        }
        return sigList;
    }

    static void readUserIDs(BCPGInputStream pIn, List<UserDataPacket> ids, List<TrustPacket> idTrusts, List<List<PGPSignature>> idSigs) throws IOException {
        while (PGPKeyRing.isUserTag(pIn.skipMarkerAndPaddingPackets())) {
            Packet obj = pIn.readPacket();
            if (obj instanceof UserIDPacket) {
                UserIDPacket id = (UserIDPacket)obj;
                ids.add(id);
            } else {
                UserAttributePacket user = (UserAttributePacket)obj;
                ids.add(new PGPUserAttributeSubpacketVector(user.getSubpackets()));
            }
            idTrusts.add(PGPKeyRing.readOptionalTrustPacket(pIn));
            idSigs.add(PGPKeyRing.readSignaturesAndTrust(pIn));
        }
    }

    public abstract PGPPublicKey getPublicKey();

    public abstract Iterator<PGPPublicKey> getPublicKeys();

    public abstract PGPPublicKey getPublicKey(long var1);

    public abstract PGPPublicKey getPublicKey(byte[] var1);

    public abstract PGPPublicKey getPublicKey(KeyIdentifier var1);

    public abstract Iterator<PGPPublicKey> getPublicKeys(KeyIdentifier var1);

    public abstract Iterator<PGPPublicKey> getKeysWithSignaturesBy(long var1);

    public abstract Iterator<PGPPublicKey> getKeysWithSignaturesBy(KeyIdentifier var1);

    public abstract int size();

    public abstract void encode(OutputStream var1) throws IOException;

    public abstract byte[] getEncoded() throws IOException;

    public abstract byte[] getEncoded(PacketFormat var1) throws IOException;

    private static boolean isUserTag(int tag) {
        switch (tag) {
            case 13: 
            case 17: {
                return true;
            }
        }
        return false;
    }
}

