/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.lpg.open.operator.bc;

import com.floragunn.searchguard.lpg.CipherParameters;
import com.floragunn.searchguard.lpg.Digest;
import com.floragunn.searchguard.lpg.RSADigestSigner;
import com.floragunn.searchguard.lpg.SHA256Digest;
import com.floragunn.searchguard.lpg.SHA512Digest;
import com.floragunn.searchguard.lpg.Signer;
import com.floragunn.searchguard.lpg.open.PGPException;

class BcImplProvider {
    BcImplProvider() {
    }

    static Digest createDigest(int algorithm) throws PGPException {
        switch (algorithm) {
            case 8: {
                return new SHA256Digest();
            }
            case 10: {
                return new SHA512Digest();
            }
        }
        throw new PGPException("cannot recognise digest " + algorithm);
    }

    static Signer createSigner(int keyAlgorithm, int hashAlgorithm, CipherParameters keyParam) throws PGPException {
        switch (keyAlgorithm) {
            case 1: 
            case 3: {
                return new RSADigestSigner(BcImplProvider.createDigest(hashAlgorithm));
            }
        }
        throw new PGPException("cannot recognise keyAlgorithm: " + keyAlgorithm);
    }
}

