/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.lpg.sig;

import com.floragunn.searchguard.lpg.Arrays;
import com.floragunn.searchguard.lpg.SignatureSubpacket;
import com.floragunn.searchguard.lpg.Strings;

public class RegularExpression
extends SignatureSubpacket {
    public RegularExpression(boolean critical, boolean isLongLength, byte[] data) {
        super(6, critical, isLongLength, data);
        if (data[data.length - 1] != 0) {
            throw new IllegalArgumentException("data in regex missing null termination");
        }
    }

    public RegularExpression(boolean critical, String regex) {
        super(6, critical, false, RegularExpression.toNullTerminatedUTF8ByteArray(regex));
    }

    public String getRegex() {
        return Strings.fromUTF8ByteArray(this.data, 0, this.data.length - 1);
    }

    public byte[] getRawRegex() {
        return Arrays.clone(this.data);
    }

    private static byte[] toNullTerminatedUTF8ByteArray(String string) {
        byte[] utf8 = Strings.toUTF8ByteArray(string);
        return Arrays.append(utf8, (byte)0);
    }
}

