/*
 * Decompiled with CFR 0.152.
 */
package com.sanctionco.jmail.net;

import com.sanctionco.jmail.net.InvalidAddressException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;

public final class InternetProtocolAddress {
    private static final Set<Character> ALLOWED_HEX_CHARACTERS = new HashSet<Character>(Arrays.asList(Character.valueOf('A'), Character.valueOf('B'), Character.valueOf('C'), Character.valueOf('D'), Character.valueOf('E'), Character.valueOf('F'), Character.valueOf('a'), Character.valueOf('b'), Character.valueOf('c'), Character.valueOf('d'), Character.valueOf('e'), Character.valueOf('f'), Character.valueOf('0'), Character.valueOf('1'), Character.valueOf('2'), Character.valueOf('3'), Character.valueOf('4'), Character.valueOf('5'), Character.valueOf('6'), Character.valueOf('7'), Character.valueOf('8'), Character.valueOf('9')));

    private InternetProtocolAddress() {
    }

    public static boolean isValid(String ip) {
        return InternetProtocolAddress.validate(ip).isPresent();
    }

    public static void enforceValid(String ip) {
        if (!InternetProtocolAddress.validate(ip).isPresent()) {
            throw new InvalidAddressException();
        }
    }

    public static Optional<String> validate(String ip) {
        Optional<String> ipv4Validated = InternetProtocolAddress.validateIpv4(ip);
        if (ipv4Validated.isPresent()) {
            return ipv4Validated;
        }
        return InternetProtocolAddress.validateIpv6(ip);
    }

    public static Optional<String> validateIpv4(String ip) {
        StringBuilder currentPart = new StringBuilder();
        int partCount = 0;
        int size = ip.length();
        for (int i = 0; i < size; ++i) {
            char c = ip.charAt(i);
            if (c == '.') {
                if (InternetProtocolAddress.isInvalidIpv4Part(currentPart.toString())) {
                    return Optional.empty();
                }
                ++partCount;
                currentPart = new StringBuilder();
                continue;
            }
            if (c < '0' || c > '9') {
                return Optional.empty();
            }
            currentPart.append(c);
        }
        if (InternetProtocolAddress.isInvalidIpv4Part(currentPart.toString())) {
            return Optional.empty();
        }
        if (++partCount != 4) {
            return Optional.empty();
        }
        return Optional.of(ip);
    }

    public static Optional<String> validateIpv6(String ip) {
        int len = ip.length();
        if (len < 2) {
            return Optional.empty();
        }
        if (ip.charAt(0) == ':' && ip.charAt(1) != ':') {
            return Optional.empty();
        }
        if (ip.charAt(len - 1) == ':' && ip.charAt(len - 2) != ':') {
            return Optional.empty();
        }
        StringBuilder currentPart = new StringBuilder();
        int partCount = 0;
        boolean previousColon = false;
        boolean doubleColon = false;
        boolean isDual = false;
        int size = ip.length();
        for (int i = 0; i < size; ++i) {
            char c = ip.charAt(i);
            if (c == '.') {
                isDual = true;
                if (partCount > 6) {
                    return Optional.empty();
                }
                String remainingSubstring = ip.substring(i);
                Optional<String> ipv4 = InternetProtocolAddress.validateIpv4(currentPart + remainingSubstring);
                if (ipv4.isPresent()) break;
                return Optional.empty();
            }
            if (c == ':') {
                if (previousColon && doubleColon) {
                    return Optional.empty();
                }
                if (previousColon) {
                    doubleColon = true;
                    continue;
                }
                if (currentPart.length() > 0) {
                    if (InternetProtocolAddress.isInvalidIpv6Part(currentPart.toString())) {
                        return Optional.empty();
                    }
                    ++partCount;
                }
                currentPart = new StringBuilder();
                previousColon = true;
                continue;
            }
            previousColon = false;
            if (!ALLOWED_HEX_CHARACTERS.contains(Character.valueOf(c))) {
                return Optional.empty();
            }
            currentPart.append(c);
        }
        if (currentPart.length() > 0) {
            if (InternetProtocolAddress.isInvalidIpv6Part(currentPart.toString())) {
                return Optional.empty();
            }
            ++partCount;
        }
        if (isDual ? !doubleColon && partCount != 7 || doubleColon && partCount > 6 : !doubleColon && partCount != 8 || doubleColon && partCount > 7) {
            return Optional.empty();
        }
        return Optional.of(ip);
    }

    private static boolean isInvalidIpv4Part(String part) {
        if (part.length() > 3) {
            return true;
        }
        try {
            if (Integer.parseInt(part) > 255) {
                return true;
            }
        }
        catch (NumberFormatException e) {
            return true;
        }
        return false;
    }

    private static boolean isInvalidIpv6Part(String part) {
        return part.length() > 4;
    }
}

