/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard;

import com.floragunn.fluent.collections.ImmutableList;
import com.floragunn.searchguard.BaseDependencies;
import com.floragunn.searchguard.SearchGuardModule;
import com.floragunn.searchguard.TypedComponentRegistry;
import com.floragunn.searchguard.auditlog.AuditLog;
import com.floragunn.searchguard.authc.AuthenticationBackend;
import com.floragunn.searchguard.authc.AuthenticationDomain;
import com.floragunn.searchguard.authc.rest.HttpAuthenticationFrontend;
import com.floragunn.searchguard.authc.rest.authenticators.AnonymousAuthenticationFrontend;
import com.floragunn.searchguard.authc.rest.authenticators.BasicAuthenticationFrontend;
import com.floragunn.searchguard.authc.rest.authenticators.HttpClientCertAuthenticationFrontend;
import com.floragunn.searchguard.authc.rest.authenticators.HttpTrustedOriginAuthenticationFrontend;
import com.floragunn.searchguard.authc.session.ApiAuthenticationFrontend;
import com.floragunn.searchguard.authc.session.LinkApiAuthenticationFrontend;
import com.floragunn.searchguard.authz.SyncAuthorizationFilter;
import com.floragunn.searchguard.authz.TenantAccessMapper;
import com.floragunn.searchguard.authz.config.MultiTenancyConfigurationProvider;
import com.floragunn.searchguard.configuration.validation.ConfigModificationValidator;
import com.floragunn.searchsupport.cstate.ComponentState;
import com.floragunn.searchsupport.cstate.ComponentStateProvider;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.index.DirectoryReader;
import org.elasticsearch.action.support.ActionFilter;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.IndexScopedSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.SettingsFilter;
import org.elasticsearch.core.CheckedFunction;
import org.elasticsearch.features.NodeFeature;
import org.elasticsearch.index.IndexService;
import org.elasticsearch.index.shard.IndexingOperationListener;
import org.elasticsearch.index.shard.SearchOperationListener;
import org.elasticsearch.plugins.ActionPlugin;
import org.elasticsearch.plugins.FieldPredicate;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.script.ScriptContext;
import org.elasticsearch.script.ScriptService;

public class SearchGuardModulesRegistry {
    public static final Setting<List<String>> DISABLED_MODULES = Setting.listSetting((String)"searchguard.modules.disabled", Collections.emptyList(), Function.identity(), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    private static final Logger log = LogManager.getLogger(SearchGuardModulesRegistry.class);
    private List<SearchGuardModule> modules = new ArrayList<SearchGuardModule>();
    private List<ComponentStateProvider> componentStateProviders = new ArrayList<ComponentStateProvider>();
    private ImmutableList<SearchOperationListener> searchOperationListeners;
    private ImmutableList<IndexingOperationListener> indexOperationListeners;
    private ImmutableList<ActionFilter> actionFilters;
    private ImmutableList<SyncAuthorizationFilter> syncAuthorizationFilters;
    private ImmutableList<SyncAuthorizationFilter> prePrivilegeEvaluationSyncAuthorizationFilters;
    private ImmutableList<Function<String, FieldPredicate>> fieldFilters;
    private ImmutableList<SearchGuardModule.QueryCacheWeightProvider> queryCacheWeightProviders;
    private ImmutableList<Function<IndexService, CheckedFunction<DirectoryReader, DirectoryReader, IOException>>> directoryReaderWrappersForNormalOperations;
    private ImmutableList<Function<IndexService, CheckedFunction<DirectoryReader, DirectoryReader, IOException>>> directoryReaderWrappersForAllOperations;
    private MultiTenancyConfigurationProvider multiTenancyConfigurationProvider;
    private TenantAccessMapper tenantAccessMapper;
    private Set<String> moduleNames = new HashSet<String>();
    private ImmutableList<ConfigModificationValidator<?>> configModificationValidators;
    private final Set<String> disabledModules;
    private final Settings settings;
    private final TypedComponentRegistry typedComponentRegistry = SearchGuardModulesRegistry.createTypedComponentRegistryWithDefaults();

    public SearchGuardModulesRegistry(Settings settings) {
        this.disabledModules = new HashSet<String>((Collection)DISABLED_MODULES.get(settings));
        this.settings = settings;
    }

    public void add(String ... classes) {
        if (this.disabledModules.contains("all")) {
            log.info("All Search Guard modules are disabled by configuration");
            return;
        }
        for (String clazz : classes) {
            try {
                if (this.disabledModules.contains(clazz)) {
                    log.info("Disabled:  " + clazz);
                    continue;
                }
                if (this.moduleNames.contains(clazz)) {
                    throw new IllegalStateException(clazz + " is already registered");
                }
                this.moduleNames.add(clazz);
                Object object = this.createModule(clazz);
                if (object instanceof SearchGuardModule) {
                    this.modules.add((SearchGuardModule)object);
                } else {
                    log.error(String.valueOf(object) + " does not implement SearchGuardSubModule");
                }
                if (object instanceof ComponentStateProvider) {
                    this.componentStateProviders.add((ComponentStateProvider)object);
                }
                log.info("Active:    " + clazz);
            }
            catch (ClassNotFoundException e) {
                log.warn("Not found: " + clazz);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                log.error("Error:    " + clazz, (Throwable)e);
            }
        }
    }

    public void addComponentStateProvider(ComponentStateProvider componentStateProvider) {
        this.componentStateProviders.add(componentStateProvider);
    }

    public List<RestHandler> getRestHandlers(Settings settings, RestController restController, ClusterSettings clusterSettings, IndexScopedSettings indexScopedSettings, SettingsFilter settingsFilter, IndexNameExpressionResolver indexNameExpressionResolver, ScriptService scriptService, Supplier<DiscoveryNodes> nodesInCluster, Predicate<NodeFeature> clusterSupportsFeature) {
        ArrayList<RestHandler> result = new ArrayList<RestHandler>();
        for (SearchGuardModule module : this.modules) {
            result.addAll(module.getRestHandlers(settings, restController, clusterSettings, indexScopedSettings, settingsFilter, indexNameExpressionResolver, scriptService, nodesInCluster, clusterSupportsFeature));
        }
        return result;
    }

    public List<ActionPlugin.ActionHandler> getActions() {
        ArrayList<ActionPlugin.ActionHandler> result = new ArrayList<ActionPlugin.ActionHandler>();
        for (SearchGuardModule module : this.modules) {
            result.addAll(module.getActions());
        }
        return result;
    }

    public List<ScriptContext<?>> getContexts() {
        ArrayList result = new ArrayList();
        for (SearchGuardModule module : this.modules) {
            result.addAll(module.getContexts());
        }
        return result;
    }

    public Collection<Object> createComponents(BaseDependencies baseDependencies) {
        ArrayList<Object> result = new ArrayList<Object>();
        for (SearchGuardModule module : this.modules) {
            result.addAll(module.createComponents(baseDependencies));
            this.typedComponentRegistry.register(module.getTypedComponents());
        }
        this.multiTenancyConfigurationProvider = this.getMultiTenancyConfigurationProvider(result);
        this.tenantAccessMapper = this.getTenantAccessMapper(result);
        return result;
    }

    public ImmutableList<Function<IndexService, CheckedFunction<DirectoryReader, DirectoryReader, IOException>>> getDirectoryReaderWrappersForNormalOperations() {
        ImmutableList result = this.directoryReaderWrappersForNormalOperations;
        if (result == null) {
            result = ImmutableList.empty();
            for (SearchGuardModule module : this.modules) {
                result = result.with(module.getDirectoryReaderWrappersForNormalOperations());
            }
            this.directoryReaderWrappersForNormalOperations = result;
        }
        return result;
    }

    public ImmutableList<Function<IndexService, CheckedFunction<DirectoryReader, DirectoryReader, IOException>>> getDirectoryReaderWrappersForAllOperations() {
        ImmutableList result = this.directoryReaderWrappersForAllOperations;
        if (result == null) {
            result = ImmutableList.empty();
            for (SearchGuardModule module : this.modules) {
                result = result.with(module.getDirectoryReaderWrappersForAllOperations());
            }
            this.directoryReaderWrappersForAllOperations = result;
        }
        return result;
    }

    public ImmutableList<SearchOperationListener> getSearchOperationListeners() {
        ImmutableList result = this.searchOperationListeners;
        if (result == null) {
            result = ImmutableList.empty();
            for (SearchGuardModule module : this.modules) {
                result = result.with(module.getSearchOperationListeners());
            }
            this.searchOperationListeners = result;
        }
        return result;
    }

    public ImmutableList<IndexingOperationListener> getIndexOperationListeners() {
        ImmutableList result = this.indexOperationListeners;
        if (result == null) {
            result = ImmutableList.empty();
            for (SearchGuardModule module : this.modules) {
                result = result.with(module.getIndexOperationListeners());
            }
            this.indexOperationListeners = result;
        }
        return result;
    }

    public ImmutableList<ActionFilter> getActionFilters() {
        ImmutableList result = this.actionFilters;
        if (result == null) {
            result = ImmutableList.empty();
            for (SearchGuardModule module : this.modules) {
                result = result.with(module.getActionFilters());
            }
            this.actionFilters = result;
        }
        return result;
    }

    public List<ConfigModificationValidator<?>> getConfigModificationValidators() {
        ImmutableList result = this.configModificationValidators;
        if (result == null) {
            result = ImmutableList.empty();
            for (SearchGuardModule module : this.modules) {
                result = result.with(module.getConfigModificationValidators());
            }
            this.configModificationValidators = result;
        }
        return result;
    }

    public ImmutableList<SyncAuthorizationFilter> getSyncAuthorizationFilters() {
        ImmutableList result = this.syncAuthorizationFilters;
        if (result == null) {
            result = ImmutableList.empty();
            for (SearchGuardModule module : this.modules) {
                result = result.with(module.getSyncAuthorizationFilters());
            }
        }
        return result;
    }

    public ImmutableList<SyncAuthorizationFilter> getPrePrivilegeSyncAuthorizationFilters() {
        ImmutableList result = this.prePrivilegeEvaluationSyncAuthorizationFilters;
        if (result == null) {
            result = ImmutableList.empty();
            for (SearchGuardModule module : this.modules) {
                result = result.with(module.getPrePrivilegeEvaluationSyncAuthorizationFilters());
            }
        }
        return result;
    }

    public ImmutableList<Function<String, FieldPredicate>> getFieldFilters() {
        ImmutableList result = this.fieldFilters;
        if (result == null) {
            result = ImmutableList.empty();
            for (SearchGuardModule module : this.modules) {
                result = result.with(module.getFieldFilters());
            }
        }
        return result;
    }

    public ImmutableList<SearchGuardModule.QueryCacheWeightProvider> getQueryCacheWeightProviders() {
        ImmutableList result = this.queryCacheWeightProviders;
        if (result == null) {
            result = ImmutableList.empty();
            for (SearchGuardModule module : this.modules) {
                result = result.with(module.getQueryCacheWeightProviders());
            }
        }
        return result;
    }

    public List<Setting<?>> getSettings() {
        ArrayList result = new ArrayList();
        for (SearchGuardModule module : this.modules) {
            result.addAll((Collection<Setting<?>>)module.getSettings().toPlatform());
        }
        return result;
    }

    public ImmutableList<AuthenticationDomain<HttpAuthenticationFrontend>> getImplicitHttpAuthenticationDomains() {
        ImmutableList.Builder result = new ImmutableList.Builder();
        for (SearchGuardModule module : this.modules) {
            result.with(module.getImplicitHttpAuthenticationDomains());
        }
        return result.build();
    }

    public AuditLog getAuditLog() {
        for (SearchGuardModule module : this.modules) {
            AuditLog auditLog = module.getAuditLog();
            if (auditLog == null) continue;
            return auditLog;
        }
        return null;
    }

    public void onNodeStarted() {
        for (SearchGuardModule module : this.modules) {
            module.onNodeStarted();
        }
    }

    public List<ComponentState> getComponentStates() {
        ArrayList<ComponentState> result = new ArrayList<ComponentState>(this.componentStateProviders.size());
        for (ComponentStateProvider provider : this.componentStateProviders) {
            try {
                ComponentState componentState = provider.getComponentState();
                if (componentState == null) continue;
                componentState.updateStateFromParts();
                result.add(componentState);
            }
            catch (Exception e) {
                log.error("Error while retrieving component state from " + String.valueOf(provider));
            }
        }
        return result;
    }

    public ComponentState getComponentState(String moduleName) {
        for (ComponentStateProvider provider : this.componentStateProviders) {
            ComponentState componentState = provider.getComponentState();
            if (componentState == null || !componentState.getName().equals(moduleName)) continue;
            componentState.updateStateFromParts();
            return componentState;
        }
        return null;
    }

    private Object createModule(String className) throws ClassNotFoundException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        Class<?> clazz = Class.forName(className);
        try {
            Constructor<?> constructor = clazz.getDeclaredConstructor(Settings.class);
            return constructor.newInstance(this.settings);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return Class.forName(className).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
    }

    public MultiTenancyConfigurationProvider getMultiTenancyConfigurationProvider() {
        return this.multiTenancyConfigurationProvider;
    }

    public TenantAccessMapper getTenantAccessMapper() {
        return this.tenantAccessMapper;
    }

    private static TypedComponentRegistry createTypedComponentRegistryWithDefaults() {
        TypedComponentRegistry typedComponentRegistry = new TypedComponentRegistry();
        typedComponentRegistry.registerInstance(AuthenticationBackend.class, "noop", AuthenticationBackend.NOOP);
        typedComponentRegistry.register(HttpAuthenticationFrontend.class, "basic", BasicAuthenticationFrontend::new);
        typedComponentRegistry.registerInstance(HttpAuthenticationFrontend.class, "anonymous", new AnonymousAuthenticationFrontend());
        typedComponentRegistry.registerInstance(HttpAuthenticationFrontend.class, "trusted_origin", new HttpTrustedOriginAuthenticationFrontend(null, null));
        typedComponentRegistry.registerInstance(HttpAuthenticationFrontend.class, "clientcert", new HttpClientCertAuthenticationFrontend(null, null));
        typedComponentRegistry.register(ApiAuthenticationFrontend.class, "basic", BasicAuthenticationFrontend::new);
        typedComponentRegistry.register(ApiAuthenticationFrontend.class, "link", LinkApiAuthenticationFrontend::new);
        return typedComponentRegistry;
    }

    public TypedComponentRegistry getTypedComponentRegistry() {
        return this.typedComponentRegistry;
    }

    public List<SearchGuardModule> getModules() {
        return Collections.unmodifiableList(this.modules);
    }

    private MultiTenancyConfigurationProvider getMultiTenancyConfigurationProvider(List<Object> componentsList) {
        List<Object> multiTenancyConfigurationProviders = componentsList.stream().filter(o -> MultiTenancyConfigurationProvider.class.isAssignableFrom(o.getClass())).toList();
        if (!multiTenancyConfigurationProviders.isEmpty()) {
            return (MultiTenancyConfigurationProvider)multiTenancyConfigurationProviders.get(0);
        }
        return MultiTenancyConfigurationProvider.DEFAULT;
    }

    private TenantAccessMapper getTenantAccessMapper(List<Object> componentsList) {
        List<Object> tenantAccessMappers = componentsList.stream().filter(o -> TenantAccessMapper.class.isAssignableFrom(o.getClass())).toList();
        if (!tenantAccessMappers.isEmpty()) {
            return (TenantAccessMapper)tenantAccessMappers.get(0);
        }
        return TenantAccessMapper.NO_OP;
    }
}

