/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.authc.base;

import com.floragunn.codova.config.text.Pattern;
import com.floragunn.codova.documents.DocNode;
import com.floragunn.codova.documents.Document;
import com.floragunn.codova.documents.Metadata;
import com.floragunn.codova.documents.Parser;
import com.floragunn.codova.validation.ConfigValidationException;
import com.floragunn.codova.validation.ValidatingDocNode;
import com.floragunn.codova.validation.ValidationErrors;
import com.floragunn.searchguard.authc.RequestMetaData;
import com.floragunn.searchguard.support.IPAddressCollection;
import com.floragunn.searchguard.user.AuthCredentials;
import inet.ipaddr.IPAddress;

public class AcceptanceRules {
    private final Criteria accept;
    private final Criteria skip;

    public AcceptanceRules(Criteria accept, Criteria skip) {
        this.accept = accept;
        this.skip = skip;
    }

    public boolean accept(RequestMetaData<?> requestMetaData) {
        IPAddress directIpAddress = requestMetaData.getDirectIpAddress();
        if (this.accept != null && this.accept.directIps != null && !this.accept.directIps.contains(directIpAddress)) {
            return false;
        }
        if (this.skip != null && this.skip.directIps != null && this.skip.directIps.contains(directIpAddress)) {
            return false;
        }
        IPAddress originatingIpAddress = requestMetaData.getOriginatingIpAddress();
        if (this.accept != null && this.accept.originatingIps != null && !this.accept.originatingIps.contains(originatingIpAddress)) {
            return false;
        }
        if (this.skip != null && this.skip.originatingIps != null && this.skip.originatingIps.contains(originatingIpAddress)) {
            return false;
        }
        if (this.accept != null && this.accept.trustedIps && !requestMetaData.isTrustedProxy()) {
            return false;
        }
        String dn = requestMetaData.getClientCertSubject();
        if (dn == null && (this.accept != null && this.accept.clientCerts != null || this.skip != null && this.skip.clientCerts != null)) {
            return false;
        }
        if (this.accept != null && this.accept.clientCerts != null && !this.accept.clientCerts.matches(dn)) {
            return false;
        }
        return this.skip == null || this.skip.clientCerts == null || !this.skip.clientCerts.matches(dn);
    }

    public boolean accept(AuthCredentials authCredentials) {
        if (this.accept != null && this.accept.users != null && !this.accept.users.matches(authCredentials.getName())) {
            return false;
        }
        return this.skip == null || this.skip.users == null || !this.skip.users.matches(authCredentials.getName());
    }

    public static class Criteria
    implements Document<Criteria> {
        public static final Metadata<Criteria> META = Metadata.create(Criteria.class, (String)"Acceptance rules criteria", Criteria::parse, (Metadata.Attribute[])new Metadata.Attribute[]{Metadata.Attribute.list((String)"originating_ips", String.class, (String)"Matches the actual IP address of the client where request originates from. You can specify CIDR expressions like 10.10.10.0/24"), Metadata.Attribute.list((String)"ips", String.class, (String)"Matches the direct IP address of the host connecting to the node. You can specify CIDR expressions like 10.10.10.0/24"), Metadata.Attribute.optional((String)"trusted_ips", Boolean.class, (String)"Matches only trusted IPs according to network.trusted_proxies").defaultValue((Object)false), Metadata.Attribute.list((String)"users", String.class, (String)"Matches the user names"), Metadata.Attribute.list((String)"client_certs", String.class, (String)"Matches the DNs of client certificates")});
        private final DocNode source;
        private final IPAddressCollection originatingIps;
        private final IPAddressCollection directIps;
        private final Pattern users;
        private final Pattern clientCerts;
        private final boolean trustedIps;

        public Criteria(DocNode source, IPAddressCollection originatingIps, IPAddressCollection directIps, boolean trustedIps, Pattern users, Pattern clientCerts) {
            this.source = source;
            this.originatingIps = originatingIps;
            this.directIps = directIps;
            this.users = users;
            this.clientCerts = clientCerts;
            this.trustedIps = trustedIps;
        }

        public static Criteria parse(DocNode docNode, Parser.Context context) throws ConfigValidationException {
            ValidationErrors validationErrors = new ValidationErrors();
            ValidatingDocNode vNode = new ValidatingDocNode(docNode, validationErrors, context);
            IPAddressCollection originatingIps = (IPAddressCollection)vNode.get("originating_ips").by(IPAddressCollection::parse);
            IPAddressCollection directIps = (IPAddressCollection)vNode.get("ips").by(IPAddressCollection::parse);
            boolean trustedIps = vNode.get("trusted_ips").withDefault(false).asBoolean();
            Pattern users = (Pattern)vNode.get("users").by(Pattern::parse);
            Pattern clientCerts = (Pattern)vNode.get("client_certs").by(Pattern::parse);
            validationErrors.throwExceptionForPresentErrors();
            return new Criteria(docNode, originatingIps, directIps, trustedIps, users, clientCerts);
        }

        public Pattern getUsers() {
            return this.users;
        }

        public IPAddressCollection getOriginatingIps() {
            return this.originatingIps;
        }

        public IPAddressCollection getDirectIps() {
            return this.directIps;
        }

        public Pattern getClientCerts() {
            return this.clientCerts;
        }

        public boolean isTrustedIps() {
            return this.trustedIps;
        }

        public Object toBasicObject() {
            return this.source;
        }
    }
}

