/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.authc.base;

import com.floragunn.codova.documents.BasicJsonPathDefaultConfiguration;
import com.floragunn.codova.documents.DocNode;
import com.floragunn.codova.documents.Parser;
import com.floragunn.codova.validation.ConfigValidationException;
import com.floragunn.codova.validation.ValidatingDocNode;
import com.floragunn.codova.validation.ValidationErrors;
import com.floragunn.codova.validation.errors.InvalidAttributeValue;
import com.floragunn.codova.validation.errors.ValidationError;
import com.floragunn.fluent.collections.ImmutableList;
import com.floragunn.fluent.collections.ImmutableMap;
import com.floragunn.fluent.collections.ImmutableSet;
import com.floragunn.searchguard.authc.AuthenticationBackend;
import com.floragunn.searchguard.authc.AuthenticationDomain;
import com.floragunn.searchguard.authc.CredentialsException;
import com.floragunn.searchguard.authc.base.AuthcResult;
import com.floragunn.searchguard.user.AuthCredentials;
import com.floragunn.searchguard.user.User;
import com.google.common.base.Splitter;
import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.InvalidPathException;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Option;
import com.jayway.jsonpath.PathNotFoundException;
import com.jayway.jsonpath.Predicate;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class UserMapping
implements AuthenticationBackend.UserMapper,
AuthenticationDomain.CredentialsMapper {
    private static final Logger log = LogManager.getLogger(UserMapping.class);
    private final DocNode source;
    private final ImmutableList<MappingSpecification> userName;
    private final ImmutableList<MappingSpecification> userNameFromBackend;
    private final ImmutableList<MappingSpecification> roles;
    private final ImmutableList<MapMappingSpecification> attrs;

    @Override
    public AuthCredentials mapCredentials(AuthCredentials authCredentials) throws CredentialsException {
        if (log.isDebugEnabled()) {
            log.debug("Mapping user using attributes " + String.valueOf(authCredentials.getAttributesForUserMapping()) + " for " + String.valueOf(authCredentials));
        }
        if (this.userName == null || this.userName.isEmpty()) {
            return authCredentials;
        }
        ImmutableMap debugDetails = ImmutableMap.of((Object)"user_mapping_attributes", authCredentials.getAttributesForUserMapping(), (Object)"user_mapping", (Object)this.source);
        ImmutableSet<String> newUserNames = MappingSpecification.apply(this.userName, authCredentials);
        if (newUserNames.size() == 0) {
            throw new CredentialsException(new AuthcResult.DebugInfo(null, false, "No user name found", (Map<String, Object>)debugDetails));
        }
        if (newUserNames.size() != 1) {
            throw new CredentialsException(new AuthcResult.DebugInfo(null, false, "More than one candidate for the user name was found", (Map<String, Object>)debugDetails.with((Object)"user_name_candidates", newUserNames)));
        }
        if (log.isDebugEnabled()) {
            log.debug("Mapped user name: " + (String)newUserNames.only());
        }
        return authCredentials.userName((String)newUserNames.only());
    }

    @Override
    public User map(AuthCredentials authCredentials) throws CredentialsException {
        if (log.isDebugEnabled()) {
            log.debug("Mapping user using attributes " + String.valueOf(authCredentials.getAttributesForUserMapping()) + " for " + String.valueOf(authCredentials));
        }
        AuthCredentials.Builder result = authCredentials.copy();
        ImmutableMap debugDetails = ImmutableMap.of((Object)"user_mapping_attributes", authCredentials.getAttributesForUserMapping(), (Object)"user_mapping", (Object)this.source);
        if (this.userNameFromBackend != null && !this.userNameFromBackend.isEmpty()) {
            ImmutableSet<String> newUserNames = MappingSpecification.apply(this.userNameFromBackend, authCredentials);
            if (newUserNames.size() == 0) {
                throw new CredentialsException(new AuthcResult.DebugInfo(null, false, "No user name found", (Map<String, Object>)debugDetails));
            }
            if (newUserNames.size() != 1) {
                throw new CredentialsException(new AuthcResult.DebugInfo(null, false, "More than one candidate for the user name was found", (Map<String, Object>)debugDetails.with((Object)"user_name_candidates", newUserNames)));
            }
            if (log.isDebugEnabled()) {
                log.debug("Mapped user name: " + (String)newUserNames.only());
            }
            result.userName((String)newUserNames.only());
        }
        if (this.roles != null && !this.roles.isEmpty()) {
            ImmutableSet<String> backendRoles = MappingSpecification.apply(this.roles, authCredentials);
            result.backendRoles((Collection<String>)backendRoles);
            if (log.isDebugEnabled()) {
                log.debug("Mapped roles: " + String.valueOf(backendRoles));
            }
        }
        if (this.attrs != null && !this.attrs.isEmpty()) {
            ImmutableMap<String, Object> attributes = MapMappingSpecification.apply(this.attrs, authCredentials);
            if (log.isDebugEnabled()) {
                log.debug("Mapped attributes: " + String.valueOf(attributes));
            }
            try {
                result.attributes((Map<String, Object>)attributes);
            }
            catch (IllegalArgumentException e) {
                throw new CredentialsException(new AuthcResult.DebugInfo(null, false, e.getMessage(), (Map<String, Object>)debugDetails), (Throwable)e);
            }
        }
        return User.forUser(result.getUserName()).with(result.build()).build();
    }

    public static UserMapping parse(DocNode docNode, Parser.Context context) throws ConfigValidationException {
        ValidationErrors validationErrors = new ValidationErrors();
        ValidatingDocNode vNode = new ValidatingDocNode(docNode, validationErrors, context);
        ImmutableList userName = (ImmutableList)vNode.get("user_name").by(MappingSpecification::parseUserNameMapping);
        ImmutableList userNameFromBackend = (ImmutableList)vNode.get("user_name").by(MappingSpecification::parseUserNameFromBackendMapping);
        ImmutableList roles = (ImmutableList)vNode.get("roles").by(MappingSpecification::parseRoleMapping);
        ImmutableList attributes = (ImmutableList)vNode.get("attrs").by(MapMappingSpecification::parse);
        vNode.checkForUnusedAttributes();
        validationErrors.throwExceptionForPresentErrors();
        return new UserMapping(docNode, (ImmutableList<MappingSpecification>)userName, (ImmutableList<MappingSpecification>)userNameFromBackend, (ImmutableList<MappingSpecification>)roles, (ImmutableList<MapMappingSpecification>)attributes);
    }

    public UserMapping(DocNode source, ImmutableList<MappingSpecification> userName, ImmutableList<MappingSpecification> userNameFromBackend, ImmutableList<MappingSpecification> roles, ImmutableList<MapMappingSpecification> attrs) {
        this.source = source;
        this.userName = userName;
        this.userNameFromBackend = userNameFromBackend;
        this.roles = roles;
        this.attrs = attrs;
    }

    public List<MappingSpecification> getUserName() {
        return this.userName;
    }

    public List<MappingSpecification> getRoles() {
        return this.roles;
    }

    public List<MapMappingSpecification> getAttrs() {
        return this.attrs;
    }

    public static abstract class MappingSpecification {
        static ImmutableList<MappingSpecification> parseUserNameMapping(DocNode docNode, Parser.Context context) throws ConfigValidationException {
            ValidationErrors validationErrors = new ValidationErrors();
            ValidatingDocNode vNode = new ValidatingDocNode(docNode, validationErrors, context);
            ImmutableList from = vNode.get("from").asList().withEmptyListAsDefault().ofObjectsParsedBy(FromAttribute::parse);
            ImmutableList staticValues = vNode.get("static").asList().withEmptyListAsDefault().ofObjectsParsedBy(Static::parse);
            vNode.used(new String[]{"from_backend"});
            vNode.checkForUnusedAttributes();
            validationErrors.throwExceptionForPresentErrors();
            return ImmutableList.concat((Collection)from, (Collection)staticValues);
        }

        static ImmutableList<MappingSpecification> parseUserNameFromBackendMapping(DocNode docNode, Parser.Context context) throws ConfigValidationException {
            ValidationErrors validationErrors = new ValidationErrors();
            ValidatingDocNode vNode = new ValidatingDocNode(docNode, validationErrors, context);
            ImmutableList from = vNode.get("from_backend").asList().withEmptyListAsDefault().ofObjectsParsedBy(FromAttribute::parse);
            validationErrors.throwExceptionForPresentErrors();
            return from;
        }

        static ImmutableList<MappingSpecification> parseRoleMapping(DocNode docNode, Parser.Context context) throws ConfigValidationException {
            ValidationErrors validationErrors = new ValidationErrors();
            ValidatingDocNode vNode = new ValidatingDocNode(docNode, validationErrors, context);
            ImmutableList from = vNode.get("from").asList().withEmptyListAsDefault().ofObjectsParsedBy(FromAttribute::parse);
            ImmutableList fromCsv = vNode.get("from_comma_separated_string").asList().withEmptyListAsDefault().ofObjectsParsedBy(FromAttribute::parseCommaSeparated);
            ImmutableList staticValues = vNode.get("static").asList().withEmptyListAsDefault().ofObjectsParsedBy(Static::parse);
            vNode.checkForUnusedAttributes();
            validationErrors.throwExceptionForPresentErrors();
            return ImmutableList.concat((Collection)from, (Collection)fromCsv, (Collection)staticValues);
        }

        abstract ImmutableSet<String> apply(AuthCredentials var1);

        static ImmutableSet<String> apply(Collection<MappingSpecification> mappingSpecifications, AuthCredentials authCredentials) {
            ImmutableSet result = ImmutableSet.empty();
            for (MappingSpecification mappingSpecification : mappingSpecifications) {
                result = result.with(mappingSpecification.apply(authCredentials));
            }
            return result;
        }
    }

    public static abstract class MapMappingSpecification {
        static ImmutableList<MapMappingSpecification> parse(DocNode docNode, Parser.Context context) throws ConfigValidationException {
            ValidationErrors validationErrors = new ValidationErrors();
            ValidatingDocNode vNode = new ValidatingDocNode(docNode, validationErrors, context);
            ImmutableList from = vNode.get("from").asList().withEmptyListAsDefault().ofObjectsParsedBy(FromAttributeMap::parseFrom);
            ImmutableList staticValues = vNode.get("static").asList().withEmptyListAsDefault().ofObjectsParsedBy(StaticMap::parseStatic);
            validationErrors.throwExceptionForPresentErrors();
            return ImmutableList.concat((Collection)from, (Collection)staticValues);
        }

        static ImmutableMap<String, Object> apply(Collection<MapMappingSpecification> mappingSpecifications, AuthCredentials authCredentials) {
            ImmutableMap.Builder result = new ImmutableMap.Builder();
            for (MapMappingSpecification mappingSpecification : mappingSpecifications) {
                mappingSpecification.apply(authCredentials, (ImmutableMap.Builder<String, Object>)result);
            }
            return result.build();
        }

        abstract void apply(AuthCredentials var1, ImmutableMap.Builder<String, Object> var2);
    }

    public static class FromAttributeMap
    extends MapMappingSpecification {
        private final Map<String, JsonPath> attributePathMap;
        private static final Configuration attributePathConfiguration = BasicJsonPathDefaultConfiguration.defaultConfiguration();

        FromAttributeMap(Map<String, JsonPath> attributePathMap) {
            this.attributePathMap = attributePathMap;
        }

        static FromAttributeMap parseFrom(DocNode docNode, Parser.Context context) throws ConfigValidationException {
            if (docNode.isMap()) {
                ValidationErrors validationErrors = new ValidationErrors();
                ImmutableMap.Builder result = new ImmutableMap.Builder();
                for (Map.Entry entry : docNode.toMap().entrySet()) {
                    try {
                        result.put((Object)((String)entry.getKey()), (Object)JsonPath.compile((String)String.valueOf(entry.getValue()), (Predicate[])new Predicate[0]));
                    }
                    catch (InvalidPathException e) {
                        validationErrors.add(new InvalidAttributeValue((String)entry.getKey(), entry.getValue(), (Object)"JSON Path").message(e.getMessage()).cause((Throwable)e));
                    }
                }
                validationErrors.throwExceptionForPresentErrors();
                return new FromAttributeMap((Map<String, JsonPath>)result.build());
            }
            throw new ConfigValidationException((ValidationError)new InvalidAttributeValue(null, (Object)docNode, (Object)"A mapping from attribute names to JSON Path"));
        }

        @Override
        void apply(AuthCredentials authCredentials, ImmutableMap.Builder<String, Object> result) {
            for (Map.Entry<String, JsonPath> entry : this.attributePathMap.entrySet()) {
                try {
                    JsonPath jsonPath = entry.getValue();
                    Object value = JsonPath.using((Configuration)attributePathConfiguration).parse(authCredentials.getAttributesForUserMapping()).read(jsonPath);
                    result.with((Object)entry.getKey(), value);
                }
                catch (PathNotFoundException e) {
                    if (!log.isDebugEnabled()) continue;
                    log.debug("Attribute mapping path not found: " + String.valueOf(entry), (Throwable)e);
                }
                catch (Exception e) {
                    log.error("Error while evaluating map attribute mapping " + String.valueOf(entry), (Throwable)e);
                }
            }
        }
    }

    public static class StaticMap
    extends MapMappingSpecification {
        private final ImmutableMap<String, Object> map;

        StaticMap(Map<String, Object> map) {
            this.map = ImmutableMap.of(map);
        }

        static StaticMap parseStatic(DocNode docNode, Parser.Context context) throws ConfigValidationException {
            if (docNode.isMap()) {
                return new StaticMap((Map<String, Object>)docNode.toMap());
            }
            throw new ConfigValidationException((ValidationError)new InvalidAttributeValue(null, (Object)docNode, (Object)"A mapping from attribute names to values"));
        }

        @Override
        void apply(AuthCredentials authCredentials, ImmutableMap.Builder<String, Object> result) {
            result.putAll(this.map);
        }
    }

    public static class FromAttribute
    extends MappingSpecification {
        private final JsonPath attributePath;
        private final Pattern pattern;
        private final Splitter splitter;
        private static final Configuration attributePathConfiguration = BasicJsonPathDefaultConfiguration.listDefaultConfiguration().addOptions(new Option[]{Option.SUPPRESS_EXCEPTIONS});

        FromAttribute(JsonPath attributePath, Pattern pattern, String split) {
            this.pattern = pattern;
            this.attributePath = attributePath;
            this.splitter = split != null ? Splitter.on((String)split).trimResults() : null;
        }

        static FromAttribute parse(DocNode docNode, Parser.Context context) throws ConfigValidationException {
            if (docNode.isString()) {
                try {
                    return new FromAttribute(JsonPath.compile((String)docNode.toString(), (Predicate[])new Predicate[0]), null, null);
                }
                catch (InvalidPathException e) {
                    throw new ConfigValidationException(new InvalidAttributeValue(null, (Object)docNode, (Object)"JSON Path").message(e.getMessage()).cause((Throwable)e));
                }
            }
            if (docNode.isMap()) {
                ValidationErrors validationErrors = new ValidationErrors();
                ValidatingDocNode vNode = new ValidatingDocNode(docNode, validationErrors, context);
                JsonPath path = vNode.get("json_path").required().asJsonPath();
                Pattern pattern = vNode.get("pattern").asPattern();
                String split = vNode.get("split").asString();
                validationErrors.throwExceptionForPresentErrors();
                return new FromAttribute(path, pattern, split);
            }
            throw new ConfigValidationException((ValidationError)new InvalidAttributeValue(null, (Object)docNode, (Object)"JSON Path"));
        }

        static FromAttribute parseCommaSeparated(DocNode docNode, Parser.Context context) throws ConfigValidationException {
            if (docNode.isString()) {
                try {
                    return new FromAttribute(JsonPath.compile((String)docNode.toString(), (Predicate[])new Predicate[0]), null, ",");
                }
                catch (InvalidPathException e) {
                    throw new ConfigValidationException(new InvalidAttributeValue(null, (Object)docNode, (Object)"JSON Path").message(e.getMessage()).cause((Throwable)e));
                }
            }
            throw new ConfigValidationException((ValidationError)new InvalidAttributeValue(null, (Object)docNode, (Object)"JSON Path"));
        }

        @Override
        ImmutableSet<String> apply(AuthCredentials authCredentials) {
            try {
                List elements = (List)JsonPath.using((Configuration)attributePathConfiguration).parse(authCredentials.getAttributesForUserMapping()).read(this.attributePath);
                if (this.splitter != null) {
                    return ImmutableSet.flattenDeep((Collection)elements, String::valueOf).mapFlat(e -> this.splitAndApplyPattern((String)e));
                }
                return ImmutableSet.flattenDeep((Collection)elements, o -> this.applyPattern(o));
            }
            catch (PathNotFoundException e2) {
                return ImmutableSet.empty();
            }
        }

        private Collection<String> splitAndApplyPattern(String string) {
            return this.splitter.splitToStream((CharSequence)string).map(e -> this.applyPattern(e)).filter(Objects::nonNull).collect(Collectors.toList());
        }

        private String applyPattern(Object object) {
            String string = object.toString();
            if (this.pattern == null) {
                return string;
            }
            Matcher matcher = this.pattern.matcher(string);
            if (!matcher.matches()) {
                return null;
            }
            if (matcher.groupCount() == 1) {
                return matcher.group(1);
            }
            if (matcher.groupCount() > 1) {
                StringBuilder subjectBuilder = new StringBuilder();
                for (int i = 1; i <= matcher.groupCount(); ++i) {
                    if (matcher.group(i) == null) continue;
                    subjectBuilder.append(matcher.group(i));
                }
                if (subjectBuilder.length() != 0) {
                    return subjectBuilder.toString();
                }
                return null;
            }
            return null;
        }
    }

    public static class Static
    extends MappingSpecification {
        private final ImmutableSet<String> valueAsSet;

        Static(String value) {
            this.valueAsSet = ImmutableSet.of((Object)value);
        }

        static Static parse(DocNode docNode, Parser.Context context) throws ConfigValidationException {
            return new Static(docNode.toString());
        }

        @Override
        ImmutableSet<String> apply(AuthCredentials authCredentials) {
            return this.valueAsSet;
        }
    }
}

