/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.configuration.validation;

import com.floragunn.codova.config.templates.Template;
import com.floragunn.codova.config.text.Pattern;
import com.floragunn.codova.validation.errors.ValidationError;
import com.floragunn.fluent.collections.ImmutableSet;
import com.floragunn.searchguard.authz.config.Role;
import com.floragunn.searchguard.authz.config.Tenant;
import com.floragunn.searchguard.configuration.CType;
import com.floragunn.searchguard.configuration.ConfigMap;
import com.floragunn.searchguard.configuration.ConfigurationRepository;
import com.floragunn.searchguard.configuration.SgDynamicConfiguration;
import com.floragunn.searchguard.configuration.validation.ConfigModificationValidator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RoleRelationsValidator
extends ConfigModificationValidator<Role> {
    private static final Logger log = LogManager.getLogger(RoleRelationsValidator.class);
    private ConfigMap configMap;

    public RoleRelationsValidator(ConfigurationRepository configurationRepository) {
        super(CType.ROLES, configurationRepository);
    }

    @Override
    public List<ValidationError> validateConfigs(List<SgDynamicConfiguration<?>> newConfigs) {
        List<SgDynamicConfiguration<?>> notNullConfigs = ((List)Optional.ofNullable(newConfigs).orElse(new ArrayList())).stream().filter(Objects::nonNull).collect(Collectors.toList());
        ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
        Optional<SgDynamicConfiguration<Role>> newRolesConfig = this.findConfigOfType(Role.class, notNullConfigs);
        errors.addAll(newRolesConfig.map(roles -> this.validateRolesRelations((SgDynamicConfiguration<Role>)roles, notNullConfigs)).orElse(Collections.emptyList()));
        return errors;
    }

    @Override
    public List<ValidationError> validateConfig(SgDynamicConfiguration<?> newConfig) {
        return this.validateConfigs(Collections.singletonList(newConfig));
    }

    @Override
    public <T> List<ValidationError> validateConfigEntry(T newConfigEntry) {
        if (Objects.nonNull(newConfigEntry)) {
            ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
            if (Role.class.isAssignableFrom(newConfigEntry.getClass())) {
                SgDynamicConfiguration<Tenant> tenantsConfig = this.getConfigFromMap(CType.TENANTS);
                errors.addAll(this.validateRoleEntryRelations(null, (Role)newConfigEntry, tenantsConfig));
            }
            return errors;
        }
        return Collections.emptyList();
    }

    private List<ValidationError> validateRolesRelations(SgDynamicConfiguration<Role> newRolesConfig, List<SgDynamicConfiguration<?>> newConfigs) {
        ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
        SgDynamicConfiguration<Tenant> existingTenantsConfig = this.getConfigFromMap(CType.TENANTS);
        SgDynamicConfiguration<Tenant> newTenantsConfig = this.findConfigOfType(CType.TENANTS.getType(), newConfigs).map(newTenants -> newTenants.with(this.getStaticConfigEntries(existingTenantsConfig))).orElse(existingTenantsConfig);
        newRolesConfig.getCEntries().forEach((roleName, role) -> errors.addAll(this.validateRoleEntryRelations((String)roleName, (Role)role, newTenantsConfig)));
        return errors;
    }

    private List<ValidationError> validateRoleEntryRelations(String configEntryKey, Role roleConfig, SgDynamicConfiguration<Tenant> tenantsConfig) {
        ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
        ImmutableSet tenantNames = tenantsConfig.getCEntries().keySet().with((Object)"SGS_GLOBAL_TENANT");
        roleConfig.getTenantPermissions().forEach(tenant -> tenant.getTenantPatterns().forEach(tenantPattern -> {
            if (!this.tenantPatternMatchesAnyTenant((Template<Pattern>)tenantPattern, (ImmutableSet<String>)tenantNames)) {
                String msg = String.format("Tenant pattern: '%s' does not match any tenant", tenantPattern.getSource());
                errors.add(this.toValidationError(configEntryKey, msg));
            }
        }));
        return errors;
    }

    private <T> SgDynamicConfiguration<T> getConfigFromMap(CType<T> typeToLoad) {
        return this.findCurrentConfiguration(typeToLoad).orElseGet(() -> {
            log.debug("Config of type {} is unavailable, an empty config will be used instead", (Object)typeToLoad.getName());
            return SgDynamicConfiguration.empty(typeToLoad);
        });
    }

    private boolean tenantPatternMatchesAnyTenant(Template<Pattern> tenantPattern, ImmutableSet<String> tenantNames) {
        return !tenantNames.isEmpty() && !((Pattern)tenantPattern.getConstantValue()).getMatching(tenantNames).isEmpty();
    }

    private <T> Map<String, T> getStaticConfigEntries(SgDynamicConfiguration<T> config) {
        ImmutableSet nonStaticConfigNames = config.withoutStatic().getCEntries().keySet();
        return config.getCEntries().entrySet().stream().filter(arg_0 -> RoleRelationsValidator.lambda$getStaticConfigEntries$6((Set)nonStaticConfigNames, arg_0)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private static /* synthetic */ boolean lambda$getStaticConfigEntries$6(Set nonStaticConfigNames, Map.Entry configEntry) {
        return !nonStaticConfigNames.contains(configEntry.getKey());
    }
}

