/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.util.ratetracking;

import com.floragunn.searchguard.util.ratetracking.HeapBasedRateTracker;
import com.floragunn.searchguard.util.ratetracking.SingleTryRateTracker;

public interface RateTracker<ClientIdType> {
    public boolean track(ClientIdType var1);

    public void reset(ClientIdType var1);

    public static <ClientIdType> RateTracker<ClientIdType> create(long timeWindowMs, int allowedTries, int maxEntries) {
        if (allowedTries == 1) {
            return new SingleTryRateTracker();
        }
        if (allowedTries > 1) {
            return new HeapBasedRateTracker(timeWindowMs, allowedTries, maxEntries);
        }
        throw new IllegalArgumentException("allowedTries must be > 0: " + allowedTries);
    }
}

