/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.signals.actions.account.config_update;

import com.floragunn.signals.Signals;
import com.floragunn.signals.actions.account.config_update.DestinationConfigUpdateRequest;
import com.floragunn.signals.actions.account.config_update.DestinationConfigUpdateResponse;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.FailedNodeException;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.nodes.BaseNodeResponse;
import org.elasticsearch.action.support.nodes.TransportNodesAction;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.AbstractTransportRequest;
import org.elasticsearch.transport.TransportService;

public class TransportDestinationConfigUpdateAction
extends TransportNodesAction<DestinationConfigUpdateRequest, DestinationConfigUpdateResponse, NodeRequest, NodeResponse, Void> {
    private static final Logger log = LogManager.getLogger(TransportDestinationConfigUpdateAction.class);
    final Client client;
    private final Signals signals;

    @Inject
    public TransportDestinationConfigUpdateAction(Signals signals, Settings settings, ThreadPool threadPool, ClusterService clusterService, TransportService transportService, ActionFilters actionFilters, Client client) {
        super("cluster:admin:searchguard:signals:destination/update", clusterService, transportService, actionFilters, NodeRequest::new, (Executor)threadPool.executor("management"));
        this.client = client;
        this.signals = signals;
    }

    protected DestinationConfigUpdateResponse newResponse(DestinationConfigUpdateRequest request, List<NodeResponse> responses, List<FailedNodeException> failures) {
        return new DestinationConfigUpdateResponse(this.clusterService.getClusterName(), responses, failures);
    }

    protected NodeResponse nodeOperation(NodeRequest request, Task task) {
        DiscoveryNode localNode = this.clusterService.localNode();
        try {
            this.signals.getAccountRegistry().updateAtomic(this.client);
            return new NodeResponse(localNode, NodeResponse.Status.SUCCESS, "");
        }
        catch (Exception e) {
            log.error("Error while updating destinations", (Throwable)e);
            return new NodeResponse(localNode, NodeResponse.Status.EXCEPTION, e.toString());
        }
    }

    protected NodeRequest newNodeRequest(DestinationConfigUpdateRequest request) {
        return new NodeRequest(request);
    }

    protected NodeResponse newNodeResponse(StreamInput in, DiscoveryNode node) throws IOException {
        return new NodeResponse(in);
    }

    public static class NodeResponse
    extends BaseNodeResponse {
        private Status status;
        private String message;

        public NodeResponse(DiscoveryNode node, Status status, String message) {
            super(node);
            this.status = status;
            this.message = message;
        }

        public NodeResponse(StreamInput in) throws IOException {
            super(in);
            this.status = (Status)in.readEnum(Status.class);
            this.message = in.readOptionalString();
        }

        public static NodeResponse readNodeResponse(StreamInput in) throws IOException {
            NodeResponse result = new NodeResponse(in);
            return result;
        }

        public String getMessage() {
            return this.message;
        }

        public Status getStatus() {
            return this.status;
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeEnum((Enum)this.status);
            out.writeOptionalString(this.message);
        }

        public String toString() {
            return "NodeResponse [status=" + String.valueOf((Object)this.status) + ", message=" + this.message + "]";
        }

        public static enum Status {
            SUCCESS,
            EXCEPTION;

        }
    }

    public static class NodeRequest
    extends AbstractTransportRequest {
        public NodeRequest(DestinationConfigUpdateRequest request) {
        }

        public NodeRequest(StreamInput in) throws IOException {
            super(in);
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
        }
    }
}

