/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.enterprise.dlsfls;

import com.floragunn.codova.config.templates.Template;
import com.floragunn.codova.documents.DocNode;
import com.floragunn.searchguard.authz.PrivilegesEvaluationContext;
import com.floragunn.searchguard.authz.config.Role;
import com.floragunn.searchguard.configuration.SgDynamicConfiguration;
import com.floragunn.searchguard.enterprise.dlsfls.DlsFlsModule;
import com.floragunn.searchguard.enterprise.dlsfls.DlsFlsProcessedConfig;
import com.floragunn.searchsupport.StaticSettings;
import com.google.common.hash.Hashing;
import java.nio.charset.StandardCharsets;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.elasticsearch.common.util.concurrent.ThreadContext;

class ThreadContextAuthzHashProvider {
    static final String THREAD_CONTEXT_HEADER = "_sg_dls_fls_authz";
    private final boolean active;
    private final ThreadContext threadContext;

    ThreadContextAuthzHashProvider(StaticSettings staticSettings, ThreadContext threadContext) {
        this.active = (Boolean)staticSettings.get(DlsFlsModule.PROVIDE_THREAD_CONTEXT_AUTHZ_HASH);
        this.threadContext = threadContext;
    }

    void noRestrictions() {
        if (this.active && this.threadContext.getHeader(THREAD_CONTEXT_HEADER) == null) {
            this.threadContext.putHeader(THREAD_CONTEXT_HEADER, "0");
        }
    }

    void restrictions(PrivilegesEvaluationContext context, DlsFlsProcessedConfig config) {
        if (this.active && this.threadContext.getHeader(THREAD_CONTEXT_HEADER) == null) {
            String restrictionsInfo = this.restrictionsInfo(context, config);
            this.threadContext.putHeader(THREAD_CONTEXT_HEADER, Hashing.sha256().hashString((CharSequence)restrictionsInfo, StandardCharsets.UTF_8).toString());
        }
    }

    String restrictionsInfo(PrivilegesEvaluationContext context, DlsFlsProcessedConfig config) {
        SgDynamicConfiguration rolesConfig = context.getSpecialPrivilegesEvaluationContext() != null ? context.getSpecialPrivilegesEvaluationContext().getRolesConfig() : config.getRoleConfig();
        return this.restrictionsInfo(context, (SgDynamicConfiguration<Role>)rolesConfig);
    }

    String restrictionsInfo(PrivilegesEvaluationContext context, SgDynamicConfiguration<Role> rolesConfig) {
        if (this.usesTemplates(context, rolesConfig)) {
            return this.userBasedRestrictionsInfo(context);
        }
        return this.roleBasedRestrictionInfo(context, rolesConfig);
    }

    boolean usesTemplates(PrivilegesEvaluationContext context, SgDynamicConfiguration<Role> rolesConfig) {
        for (String roleName : context.getMappedRoles()) {
            Role role = (Role)rolesConfig.getCEntry(roleName);
            if (role == null) continue;
            for (Role.Index indexPermissions : role.getIndexPermissions()) {
                if (!indexPermissions.usesTemplates()) continue;
                return true;
            }
        }
        return false;
    }

    String userBasedRestrictionsInfo(PrivilegesEvaluationContext context) {
        return context.getUser().getName() + "::" + DocNode.wrap((Object)context.getUser().getStructuredAttributes()).toJsonString() + "::" + String.valueOf(context.getMappedRoles());
    }

    String roleBasedRestrictionInfo(PrivilegesEvaluationContext context, SgDynamicConfiguration<Role> rolesConfig) {
        TreeSet unprotectedIndices = new TreeSet();
        TreeMap<String, Set> protectedIndices = new TreeMap<String, Set>();
        for (String roleName : context.getMappedRoles()) {
            Role role = (Role)rolesConfig.getCEntry(roleName);
            if (role == null) continue;
            for (Role.Index indexPermissions : role.getIndexPermissions()) {
                if (indexPermissions.getDls() == null && (indexPermissions.getFls() == null || indexPermissions.getFls().isEmpty()) && (indexPermissions.getMaskedFields() == null || indexPermissions.getMaskedFields().isEmpty())) {
                    unprotectedIndices.addAll(indexPermissions.getIndexPatterns().getSource().map(Template::toString));
                    continue;
                }
                for (String indexPattern : indexPermissions.getIndexPatterns().getSource().map(Template::toString)) {
                    Set rules = protectedIndices.computeIfAbsent(indexPattern, k -> new TreeSet());
                    rules.add("dls:" + String.valueOf(indexPermissions.getDls()));
                    rules.add("fls: " + String.valueOf(indexPermissions.getFls()));
                    rules.add("fm: " + String.valueOf(indexPermissions.getMaskedFields()));
                }
            }
        }
        for (String unprotectedIndex : unprotectedIndices) {
            protectedIndices.remove(unprotectedIndex);
        }
        return String.valueOf(unprotectedIndices) + "::" + String.valueOf(protectedIndices);
    }
}

