/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchsupport.cstate;

import com.floragunn.codova.documents.DocNode;
import com.floragunn.codova.documents.DocReader;
import com.floragunn.codova.documents.Document;
import com.floragunn.codova.documents.DocumentParseException;
import com.floragunn.codova.validation.ConfigValidationException;
import com.floragunn.fluent.collections.ImmutableList;
import com.floragunn.fluent.collections.ImmutableMap;
import com.floragunn.fluent.collections.OrderedImmutableMap;
import com.floragunn.searchsupport.cstate.metrics.Measurement;
import com.google.common.base.Strings;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.jar.Manifest;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ComponentState
implements Document<ComponentState> {
    private static final Logger log = LogManager.getLogger(ComponentState.class);
    private final String type;
    private final String name;
    private String className;
    private volatile State state = State.INITIALIZING;
    private volatile String subState;
    private volatile int tries;
    private volatile String message;
    private List<Object> detailJsonElements = Collections.synchronizedList(new ArrayList());
    private volatile ImmutableList<String> initException;
    private Instant startedAt = Instant.now();
    private volatile Instant initializedAt;
    private volatile Instant changedAt;
    private Instant failedAt;
    private volatile Instant nextTryAt;
    private Map<String, ExceptionRecord> lastExceptions = new ConcurrentHashMap<String, ExceptionRecord>();
    private boolean mandatory = true;
    private String jarFileName;
    private String jarVersion;
    private String jarBuildTime;
    private String nodeId;
    private String nodeName;
    private byte licenseRequired;
    private int sortPrio;
    private String configVersion;
    private ImmutableMap<String, Measurement<?>> metrics = ImmutableMap.empty();
    private ImmutableMap<String, Object> moreConfigProperties;
    private List<ComponentState> parts = new ArrayList<ComponentState>();

    public ComponentState(String name) {
        this.type = null;
        this.name = name;
        this.sortPrio = 0;
    }

    public ComponentState(int sortPrio, String type, String name) {
        this.type = type;
        this.name = name;
        this.sortPrio = sortPrio;
    }

    public ComponentState(int sortPrio, String type, String name, Class<?> referenceClass) {
        this.type = type;
        this.name = name;
        this.sortPrio = sortPrio;
        if (referenceClass != null) {
            this.setReferenceClass(referenceClass);
        }
    }

    public ComponentState(DocNode docNode) {
        this.type = docNode.getAsString("type");
        this.name = docNode.getAsString("name");
        this.className = docNode.getAsString("class_name");
        this.nodeId = docNode.getAsString("node_id");
        this.nodeName = docNode.getAsString("node_name");
        this.state = docNode.hasNonNull("state") ? State.valueOf(docNode.getAsString("state")) : null;
        this.subState = docNode.getAsString("sub_state");
        try {
            this.tries = docNode.hasNonNull("tries") ? docNode.getNumber("tries").intValue() : 0;
        }
        catch (ConfigValidationException e) {
            log.error("Invalid value for tries", (Throwable)e);
        }
        this.message = docNode.getAsString("message");
        if (docNode.hasNonNull("detail")) {
            Object detail = docNode.get("detail");
            if (detail instanceof List) {
                this.detailJsonElements.addAll((List)detail);
            } else {
                this.detailJsonElements.add(detail);
            }
        }
        this.startedAt = docNode.hasNonNull("started_at") ? Instant.parse(docNode.getAsString("started_at")) : null;
        this.initializedAt = docNode.hasNonNull("initialized_at") ? Instant.parse(docNode.getAsString("initialized_at")) : null;
        this.changedAt = docNode.hasNonNull("changed_at") ? Instant.parse(docNode.getAsString("changed_at")) : null;
        this.failedAt = docNode.hasNonNull("failed_at") ? Instant.parse(docNode.getAsString("failed_at")) : null;
        this.nextTryAt = docNode.hasNonNull("next_try_at") ? Instant.parse(docNode.getAsString("next_try_at")) : null;
        boolean bl = this.mandatory = docNode.get("mandatory") instanceof Boolean ? (Boolean)docNode.get("mandatory") : false;
        if (docNode.hasNonNull("build")) {
            DocNode build = docNode.getAsNode("build");
            this.jarFileName = build.getAsString("file");
            this.jarVersion = build.getAsString("version");
            this.jarBuildTime = build.getAsString("time");
        }
        this.initException = docNode.getAsListOfStrings("init_exception");
        if (docNode.hasNonNull("last_exceptions")) {
            DocNode lastExceptions = docNode.getAsNode("last_exceptions");
            for (String key : lastExceptions.keySet()) {
                this.lastExceptions.put(key, new ExceptionRecord(lastExceptions.getAsNode(key)));
            }
        }
        if (docNode.hasNonNull("config")) {
            DocNode config = docNode.getAsNode("config");
            ImmutableMap.Builder moreConfigProperties = new ImmutableMap.Builder();
            for (String key : config.keySet()) {
                if (key.equals("version")) {
                    this.configVersion = config.getAsString("version");
                    continue;
                }
                moreConfigProperties.put((Object)key, config.get(key));
            }
            this.moreConfigProperties = moreConfigProperties.build();
        }
        if (docNode.hasNonNull("metrics")) {
            DocNode metricsNode = docNode.getAsNode("metrics");
            ImmutableMap.Builder metrics = new ImmutableMap.Builder(metricsNode.size());
            for (String key : metricsNode.keySet()) {
                metrics.put((Object)key, Measurement.parse(metricsNode.getAsNode(key)));
            }
            this.metrics = metrics.build();
        }
        if (docNode.hasNonNull("parts")) {
            for (DocNode part : docNode.getAsListOfNodes("parts")) {
                this.parts.add(new ComponentState(part));
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public String getKey() {
        return this.type + "::" + this.name;
    }

    public String getTypeAndName() {
        if (this.type == null) {
            return this.name;
        }
        return this.type + "/" + this.name;
    }

    public String getSortingKey() {
        return Strings.padStart((String)String.valueOf(this.sortPrio), (int)10, (char)'0') + "::" + this.getKey();
    }

    public PartsStats updateStateFromParts() {
        try {
            int total = this.parts.size();
            PartsStats result = new PartsStats();
            if (total == 0) {
                return result;
            }
            for (ComponentState part : this.parts) {
                part.updateStateFromParts();
            }
            int failed = 0;
            int initialized = 0;
            int disabled = 0;
            int initializing = 0;
            int mandatory = 0;
            Instant lastInitialized = this.initializedAt;
            Instant lastFailed = this.failedAt;
            Instant lastChanged = this.changedAt;
            for (ComponentState part : this.parts) {
                lastChanged = ComponentState.max(lastChanged, part.changedAt);
                if (part.state == State.INITIALIZING) {
                    ++initializing;
                }
                if (!part.isMandatory()) continue;
                ++mandatory;
                switch (part.getState().ordinal()) {
                    case 1: {
                        ++initialized;
                        lastInitialized = ComponentState.max(lastInitialized, part.getInitializedAt());
                        break;
                    }
                    case 3: {
                        ++failed;
                        lastFailed = ComponentState.max(lastFailed, part.getFailedAt());
                        break;
                    }
                    case 4: {
                        ++disabled;
                        break;
                    }
                    case 0: {
                        break;
                    }
                    case 5: {
                        ++initialized;
                        break;
                    }
                }
            }
            if (initializing > 0) {
                this.setState(State.INITIALIZING);
            } else if (initialized == mandatory) {
                this.setInitialized();
                this.initializedAt = lastInitialized;
            } else if (disabled == mandatory) {
                this.setState(State.DISABLED);
            } else if (failed > 0) {
                this.setState(State.FAILED);
                this.failedAt = lastFailed;
            } else if (failed == 0) {
                this.setInitialized();
                this.initializedAt = lastInitialized;
            }
            this.changedAt = lastChanged;
            result.setTotal(total);
            result.setFailed(failed);
            result.setInitialized(initialized);
            result.setInitializing(initializing);
            result.setMandatory(mandatory);
            return result;
        }
        catch (Exception e) {
            log.error("Error in updateStateFromParts()", (Throwable)e);
            return new PartsStats();
        }
    }

    public State getState() {
        return this.state;
    }

    public boolean isFailed() {
        return this.state == State.FAILED;
    }

    public boolean isInitialized() {
        return this.state == State.INITIALIZED;
    }

    public void setState(State state) {
        if (state.equals((Object)this.state)) {
            return;
        }
        this.state = state;
        this.changedAt = Instant.now();
        this.subState = null;
        this.tries = 0;
    }

    public void setState(State state, String subState) {
        if (state.equals((Object)this.state) && Objects.equals(subState, this.subState)) {
            return;
        }
        this.state = state;
        this.subState = subState;
        this.changedAt = Instant.now();
        this.tries = 0;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setFailed(Throwable initException) {
        Instant now = Instant.now();
        this.initException = ComponentState.exceptionToString(initException);
        this.state = State.FAILED;
        this.subState = null;
        this.failedAt = now;
        this.changedAt = now;
    }

    public void setFailed(String message) {
        Instant now = Instant.now();
        this.message = message;
        this.state = State.FAILED;
        this.subState = null;
        this.failedAt = now;
        this.changedAt = now;
    }

    public void setInitialized() {
        Instant now = Instant.now();
        this.state = State.INITIALIZED;
        this.subState = null;
        this.initializedAt = now;
        this.changedAt = now;
    }

    public ComponentState initialized() {
        this.setInitialized();
        return this;
    }

    public void setInitException(Exception initException) {
        this.initException = ComponentState.exceptionToString(initException);
    }

    public Map<String, ExceptionRecord> getLastExceptions() {
        return this.lastExceptions;
    }

    public void addLastException(String key, ExceptionRecord exceptionRecord) {
        this.lastExceptions.put(key, exceptionRecord);
    }

    public void addLastException(String key, Throwable t) {
        this.addLastException(key, new ExceptionRecord(t));
    }

    public Instant getStartedAt() {
        return this.startedAt;
    }

    public void setStartedAt(Instant startedAt) {
        this.startedAt = startedAt;
    }

    public Instant getInitializedAt() {
        return this.initializedAt;
    }

    public void setInitializedAt(Instant initializedAt) {
        this.initializedAt = initializedAt;
    }

    public Instant getFailedAt() {
        return this.failedAt;
    }

    public void setFailedAt(Instant failedAt) {
        this.failedAt = failedAt;
    }

    public Instant getNextTryAt() {
        return this.nextTryAt;
    }

    public void setNextTryAt(Instant nextTryAt) {
        this.nextTryAt = nextTryAt;
    }

    public String getSubState() {
        return this.subState;
    }

    public void setSubState(String subState) {
        this.subState = subState;
    }

    public void addDetail(Object detail) {
        this.detailJsonElements.add(detail);
    }

    public void setDetailJson(String detailJson) {
        try {
            Object parsedDetailJson = DocReader.json().read(detailJson);
            this.detailJsonElements.clear();
            this.detailJsonElements.add(parsedDetailJson);
        }
        catch (DocumentParseException e) {
            log.error("Error while parsing detail JSON\n" + detailJson, (Throwable)e);
        }
    }

    public Object toBasicObject() {
        OrderedImmutableMap.Builder result = new OrderedImmutableMap.Builder(40);
        if (this.nodeId != null) {
            result.put((Object)"node_id", (Object)this.nodeId);
        }
        if (this.nodeName != null) {
            result.put((Object)"node_name", (Object)this.nodeName);
        }
        if (this.type != null) {
            result.put((Object)"type", (Object)this.type);
        }
        result.put((Object)"name", (Object)this.name);
        result.put((Object)"state", (Object)this.state);
        if (this.subState != null) {
            result.put((Object)"sub_state", (Object)this.subState);
        }
        if (this.message != null) {
            result.put((Object)"message", (Object)this.message);
        }
        if (this.detailJsonElements != null && this.detailJsonElements.size() != 0) {
            if (this.detailJsonElements.size() == 1) {
                result.put((Object)"detail", this.detailJsonElements.get(0));
            } else {
                result.put((Object)"detail", this.detailJsonElements);
            }
        }
        if (this.startedAt != null) {
            result.put((Object)"started_at", (Object)this.startedAt.toString());
        }
        if (this.changedAt != null && (this.startedAt == null || this.changedAt.isAfter(this.startedAt))) {
            result.put((Object)"changed_at", (Object)this.changedAt.toString());
        }
        if (this.initializedAt != null) {
            result.put((Object)"initialized_at", (Object)this.initializedAt.toString());
        }
        if (this.failedAt != null) {
            result.put((Object)"failed_at", (Object)this.failedAt.toString());
        }
        if (this.nextTryAt != null) {
            result.put((Object)"next_try_at", (Object)this.nextTryAt.toString());
        }
        if (this.initException != null) {
            result.put((Object)"init_exception", this.initException);
        }
        if (this.licenseRequired != 0) {
            result.put((Object)"license_required", (Object)this.getLicenseRequiredInfo());
        }
        if (this.jarFileName != null || this.jarVersion != null || this.jarBuildTime != null) {
            result.put((Object)"build", (Object)OrderedImmutableMap.ofNonNull((Object)"file", (Object)this.jarFileName, (Object)"version", (Object)this.jarVersion, (Object)"time", (Object)this.jarBuildTime));
        }
        if (this.configVersion != null || this.moreConfigProperties != null && !this.moreConfigProperties.isEmpty()) {
            OrderedImmutableMap.Builder config = new OrderedImmutableMap.Builder();
            if (this.configVersion != null) {
                config.put((Object)"version", (Object)this.configVersion);
            }
            if (this.moreConfigProperties != null && !this.moreConfigProperties.isEmpty()) {
                for (Map.Entry entry : this.moreConfigProperties.entrySet()) {
                    config.put((Object)((String)entry.getKey()), entry.getValue());
                }
            }
            result.put((Object)"config", (Object)config.build());
        }
        if (this.metrics != null && this.metrics.size() != 0) {
            result.put((Object)"metrics", (Object)this.metrics.mapValues(v -> OrderedImmutableMap.of((Object)v.getType(), (Object)v)));
        }
        if (this.parts.size() > 0) {
            result.put((Object)"parts", this.parts);
        }
        if (this.lastExceptions.size() != 0) {
            result.put((Object)"last_exceptions", this.lastExceptions);
        }
        return result.build();
    }

    private static ImmutableList<String> exceptionToString(Throwable e) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        e.printStackTrace(printWriter);
        return ImmutableList.ofArray((Object[])stringWriter.toString().replace('\t', ' ').split("\n"));
    }

    public List<ComponentState> getParts() {
        return Collections.unmodifiableList(this.parts);
    }

    public void addPart(ComponentState moduleState) {
        this.parts.add(moduleState);
    }

    public void addParts(ComponentState ... parts) {
        for (ComponentState part : parts) {
            this.parts.add(part);
        }
    }

    public ComponentState getPart(String type, String name) {
        for (ComponentState part : this.parts) {
            if (!Objects.equals(name, part.getName()) || !Objects.equals(type, part.type)) continue;
            return part;
        }
        return null;
    }

    public ComponentState getOrCreatePart(String type, String name) {
        ComponentState part = this.getPart(type, name);
        if (part == null) {
            part = new ComponentState(0, type, name);
            this.parts.add(part);
        }
        return part;
    }

    public synchronized void replacePart(ComponentState part) {
        ComponentState existing = this.getPart(part.getType(), part.getName());
        if (existing != null) {
            this.parts.remove(existing);
        }
        this.parts.add(part);
    }

    public synchronized void clearParts() {
        this.parts.clear();
    }

    public synchronized void replacePartsWithType(String type, ComponentState newPart) {
        Iterator<ComponentState> iter = this.parts.iterator();
        while (iter.hasNext()) {
            ComponentState part = iter.next();
            if (!type.equals(part.getType())) continue;
            iter.remove();
        }
        this.parts.add(newPart);
    }

    public synchronized void replacePartsWithType(String type, Collection<ComponentState> newParts) {
        Iterator<ComponentState> iter = this.parts.iterator();
        while (iter.hasNext()) {
            ComponentState part = iter.next();
            if (!type.equals(part.getType())) continue;
            iter.remove();
        }
        this.parts.addAll(newParts);
    }

    public void addMetrics(String key, Measurement<?> measurement) {
        this.metrics = this.metrics.with((Object)key, measurement);
    }

    public void addMetrics(String key1, Measurement<?> measurement1, String key2, Measurement<?> measurement2) {
        this.metrics = this.metrics.with(ImmutableMap.of((Object)key1, measurement1, (Object)key2, measurement2));
    }

    public void addMetrics(String key1, Measurement<?> measurement1, String key2, Measurement<?> measurement2, String key3, Measurement<?> measurement3) {
        this.metrics = this.metrics.with(ImmutableMap.of((Object)key1, measurement1, (Object)key2, measurement2, (Object)key3, measurement3));
    }

    public void addMetrics(String key1, Measurement<?> measurement1, String key2, Measurement<?> measurement2, String key3, Measurement<?> measurement3, String key4, Measurement<?> measurement4) {
        this.metrics = this.metrics.with(ImmutableMap.of((Object)key1, measurement1, (Object)key2, measurement2, (Object)key3, measurement3, (Object)key4, measurement4));
    }

    public void addMetrics(Map<String, Measurement<?>> measurements) {
        this.metrics = this.metrics.with(ImmutableMap.of(measurements));
    }

    public void setConfigProperty(String property, Object value) {
        this.moreConfigProperties = this.moreConfigProperties == null ? ImmutableMap.of((Object)property, (Object)value) : this.moreConfigProperties.with((Object)property, value);
    }

    public int getTries() {
        return this.tries;
    }

    public void startNextTry() {
        ++this.tries;
        this.changedAt = Instant.now();
    }

    private static Instant max(Instant i1, Instant i2) {
        if (i1 == null) {
            return i2;
        }
        if (i2 == null) {
            return i1;
        }
        if (i1.isAfter(i2)) {
            return i1;
        }
        return i2;
    }

    private static Instant min(Instant i1, Instant i2) {
        if (i1 == null) {
            return i2;
        }
        if (i2 == null) {
            return i1;
        }
        if (i1.isBefore(i2)) {
            return i1;
        }
        return i2;
    }

    public boolean isMandatory() {
        return this.mandatory;
    }

    public void setMandatory(boolean mandatory) {
        this.mandatory = mandatory;
    }

    public ComponentState mandatory(boolean mandatory) {
        this.mandatory = mandatory;
        return this;
    }

    public String getJarFileName() {
        return this.jarFileName;
    }

    public String getJarVersion() {
        return this.jarVersion;
    }

    public String getJarBuildTime() {
        return this.jarBuildTime;
    }

    public Instant getMinStartForInitializingState() {
        Instant result = this.state == State.INITIALIZING ? this.startedAt : null;
        for (ComponentState part : this.parts) {
            Instant start = part.getMinStartForInitializingState();
            result = ComponentState.min(result, start);
        }
        return result;
    }

    public void setReferenceClass(Class<?> referenceClass) {
        try {
            this.className = referenceClass.getName();
            URL locationInJarUrl = referenceClass.getResource("/" + referenceClass.getName().replace(".", "/") + ".class");
            if (locationInJarUrl == null) {
                return;
            }
            String locationInJar = locationInJarUrl.toString();
            String jarFilePath = this.getJarFilePath(locationInJar);
            if (jarFilePath != null) {
                this.jarFileName = this.getFilename(jarFilePath);
                try {
                    Manifest manifest = this.getManifest(jarFilePath);
                    this.jarVersion = manifest.getMainAttributes().getValue("Implementation-Version");
                    this.jarBuildTime = manifest.getMainAttributes().getValue("Build-Time");
                }
                catch (Exception e) {
                    log.error("Error while reading manifest " + jarFilePath, (Throwable)e);
                }
            } else {
                this.jarFileName = locationInJar;
            }
        }
        catch (Throwable e) {
            log.error("Error while getting class info for " + String.valueOf(referenceClass), e);
        }
    }

    private String getFilename(String url) {
        int slash = url.lastIndexOf(47);
        if (slash != -1) {
            return url.substring(slash + 1);
        }
        return url;
    }

    private Manifest getManifest(String jarFilePath) throws MalformedURLException, IOException {
        String manifestPath = jarFilePath + "!/META-INF/MANIFEST.MF";
        try (InputStream stream = new URL(manifestPath).openStream();){
            Manifest manifest = new Manifest(stream);
            return manifest;
        }
    }

    private String getJarFilePath(String locationInJar) {
        if (!locationInJar.startsWith("jar:")) {
            return null;
        }
        int index = locationInJar.lastIndexOf(33);
        if (index != -1) {
            return locationInJar.substring(0, index);
        }
        return null;
    }

    public ComponentState findPart(Function<ComponentState, Boolean> predicate) {
        for (ComponentState part : this.parts) {
            if (!predicate.apply(part).booleanValue()) continue;
            return part;
        }
        return null;
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public void setNodeId(String node) {
        this.nodeId = node;
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public void setNodeName(String nodeName) {
        this.nodeName = nodeName;
    }

    public String getClassName() {
        return this.className;
    }

    public int getSortPrio() {
        return this.sortPrio;
    }

    public void setSortPrio(int sortPrio) {
        this.sortPrio = sortPrio;
    }

    public String getConfigVersion() {
        return this.configVersion;
    }

    public void setConfigVersion(String configVersion) {
        this.configVersion = configVersion;
    }

    public void setConfigVersion(long configVersion) {
        this.configVersion = Long.toString(configVersion);
    }

    public byte getLicenseRequired() {
        return this.licenseRequired;
    }

    public String getLicenseRequiredInfo() {
        switch (this.licenseRequired) {
            case 0: {
                return "no";
            }
            case 1: {
                return "enterprise";
            }
        }
        return String.valueOf(this.licenseRequired);
    }

    public void setLicenseRequired(byte licenseRequired) {
        this.licenseRequired = licenseRequired;
    }

    public ComponentState requiresEnterpriseLicense() {
        this.licenseRequired = 1;
        return this;
    }

    public ImmutableMap<String, Measurement<?>> getMetrics() {
        return this.metrics;
    }

    public static enum State {
        INITIALIZING,
        INITIALIZED,
        PARTIALLY_INITIALIZED,
        FAILED,
        DISABLED,
        SUSPENDED;

    }

    public static class ExceptionRecord
    implements Document<ExceptionRecord> {
        private final ImmutableList<String> exception;
        private final String message;
        private final Instant occuredAt;

        public ExceptionRecord(Throwable exception, String message) {
            this.exception = ComponentState.exceptionToString(exception);
            this.message = message;
            this.occuredAt = Instant.now();
        }

        public ExceptionRecord(DocNode docNode) {
            this.message = docNode.getAsString("message");
            this.exception = docNode.getAsListOfStrings("exception");
            this.occuredAt = docNode.hasNonNull("occured_at") ? Instant.parse(docNode.getAsString("occured_at")) : null;
        }

        public ExceptionRecord(Throwable exception) {
            this(exception, null);
        }

        public String getMessage() {
            return this.message;
        }

        public Instant getOccuredAt() {
            return this.occuredAt;
        }

        public Object toBasicObject() {
            return OrderedImmutableMap.ofNonNull((Object)"message", (Object)this.message, (Object)"exception", this.exception, (Object)"occured_at", (Object)this.occuredAt);
        }
    }

    public static class PartsStats {
        private int total = 0;
        private int failed = 0;
        private int initialized = 0;
        private int disabled = 0;
        private int initializing = 0;
        private int mandatory = 0;

        public int getFailed() {
            return this.failed;
        }

        public void setFailed(int failed) {
            this.failed = failed;
        }

        public int getInitialized() {
            return this.initialized;
        }

        public void setInitialized(int initialized) {
            this.initialized = initialized;
        }

        public int getDisabled() {
            return this.disabled;
        }

        public void setDisabled(int disabled) {
            this.disabled = disabled;
        }

        public int getInitializing() {
            return this.initializing;
        }

        public void setInitializing(int initializing) {
            this.initializing = initializing;
        }

        public int getMandatory() {
            return this.mandatory;
        }

        public void setMandatory(int mandatory) {
            this.mandatory = mandatory;
        }

        public int getTotal() {
            return this.total;
        }

        public void setTotal(int total) {
            this.total = total;
        }
    }
}

