/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.ssl.http;

import io.netty.channel.EventLoop;
import io.netty.handler.ssl.SslHandler;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.http.HttpBody;
import org.elasticsearch.http.HttpRequest;
import org.elasticsearch.http.HttpResponse;
import org.elasticsearch.rest.ChunkedRestResponseBodyPart;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestStatus;

public class AttributedHttpRequest
implements HttpRequest {
    private final HttpRequest httpRequest;
    private final SslHandler sslHandler;
    private final EventLoop eventLoop;

    private AttributedHttpRequest(HttpRequest httpRequest, SslHandler sslHandler, EventLoop eventLoop) {
        this.httpRequest = Objects.requireNonNull(httpRequest, "Http request is required.");
        this.sslHandler = sslHandler;
        this.eventLoop = Objects.requireNonNull(eventLoop, "Event loop is required.");
    }

    public static AttributedHttpRequest create(HttpRequest httpRequest, SslHandler sslhandler, EventLoop eventLoop) {
        Objects.requireNonNull(httpRequest, "Http request is required.");
        Objects.requireNonNull(eventLoop, "Event loop is required.");
        if (httpRequest instanceof AttributedHttpRequest) {
            AttributedHttpRequest request = (AttributedHttpRequest)httpRequest;
            return request.withSslHandler(sslhandler).withEventLoop(eventLoop);
        }
        return new AttributedHttpRequest(httpRequest, sslhandler, eventLoop);
    }

    private AttributedHttpRequest withSslHandler(SslHandler sslhandler) {
        return new AttributedHttpRequest(this.httpRequest, sslhandler, this.eventLoop);
    }

    private AttributedHttpRequest withEventLoop(EventLoop eventLoop) {
        return new AttributedHttpRequest(this.httpRequest, this.sslHandler, eventLoop);
    }

    public SslHandler getSslHandler() {
        return this.sslHandler;
    }

    public EventLoop getEventLoop() {
        return this.eventLoop;
    }

    public String uri() {
        return this.httpRequest.uri();
    }

    public HttpBody body() {
        return this.httpRequest.body();
    }

    public void setBody(HttpBody body) {
        this.httpRequest.setBody(body);
    }

    public List<String> strictCookies() {
        return this.httpRequest.strictCookies();
    }

    public HttpRequest removeHeader(String header) {
        return this.httpRequest.removeHeader(header);
    }

    public boolean hasContent() {
        return this.httpRequest.hasContent();
    }

    public void release() {
        this.httpRequest.release();
    }

    public HttpRequest.HttpVersion protocolVersion() {
        return this.httpRequest.protocolVersion();
    }

    public RestRequest.Method method() {
        return this.httpRequest.method();
    }

    public Exception getInboundException() {
        return this.httpRequest.getInboundException();
    }

    public Map<String, List<String>> getHeaders() {
        return this.httpRequest.getHeaders();
    }

    public HttpResponse createResponse(RestStatus status, BytesReference content) {
        return this.httpRequest.createResponse(status, content);
    }

    public HttpResponse createResponse(RestStatus status, ChunkedRestResponseBodyPart content) {
        return this.httpRequest.createResponse(status, content);
    }
}

