/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.codova.documents;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.floragunn.codova.documents.BasicJsonPathDefaultConfiguration;
import com.floragunn.codova.documents.ContentType;
import com.floragunn.codova.documents.DocNodeFlattener;
import com.floragunn.codova.documents.DocReader;
import com.floragunn.codova.documents.DocWriter;
import com.floragunn.codova.documents.Document;
import com.floragunn.codova.documents.DocumentParseException;
import com.floragunn.codova.documents.Format;
import com.floragunn.codova.documents.UnexpectedDocumentStructureException;
import com.floragunn.codova.documents.UnparsedDocument;
import com.floragunn.codova.validation.ConfigValidationException;
import com.floragunn.codova.validation.ValidatingFunction;
import com.floragunn.codova.validation.ValidationErrors;
import com.floragunn.codova.validation.errors.InvalidAttributeValue;
import com.floragunn.codova.validation.errors.ValidationError;
import com.floragunn.fluent.collections.ImmutableList;
import com.floragunn.fluent.collections.ImmutableMap;
import com.floragunn.fluent.collections.ImmutableSet;
import com.floragunn.fluent.collections.OrderedImmutableMap;
import com.floragunn.fluent.collections.views.MapView;
import com.google.common.collect.Maps;
import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DocNode
implements Map<String, Object>,
Document<Object> {
    private static final Logger log = LoggerFactory.getLogger(DocNode.class);
    public static final DocNode EMPTY = new PlainJavaObjectAdapter(Collections.EMPTY_MAP);
    public static final DocNode NULL = new PlainJavaObjectAdapter(null);
    protected String key;

    public static DocNodeParserBuilder parse(Format format) {
        return new DocNodeParserBuilder(format);
    }

    public static DocNodeParserBuilder parse(ContentType contentType) {
        return new DocNodeParserBuilder(contentType.getFormat());
    }

    public static DocNode parse(UnparsedDocument<?> unparsedDoc) throws DocumentParseException {
        return DocNode.wrap(unparsedDoc.parse());
    }

    public static DocNode of(String key, Object value) {
        int separator = key.indexOf(46);
        if (separator == -1) {
            return new PlainJavaObjectAdapter(Collections.singletonMap(key, value));
        }
        return DocNode.of(key.substring(0, separator), DocNode.of(key.substring(separator + 1), value));
    }

    public static DocNode of(String k1, Object v1, String k2, Object v2) {
        int s1 = k1.indexOf(46);
        int s2 = k2.indexOf(46);
        if (s1 != -1 && s2 != -1) {
            String k2b;
            String k1b = k1.substring(0, s1);
            if (k1b.equals(k2b = k2.substring(0, s2))) {
                return new PlainJavaObjectAdapter(OrderedImmutableMap.of((Object)k1b, (Object)DocNode.of(k1.substring(s1 + 1), v1, k2.substring(s2 + 1), v2)));
            }
            return new PlainJavaObjectAdapter(OrderedImmutableMap.of((Object)k1b, (Object)DocNode.of(k1.substring(s1 + 1), v1), (Object)k2b, (Object)DocNode.of(k2.substring(s2 + 1), v2)));
        }
        if (s1 != -1) {
            return new PlainJavaObjectAdapter(OrderedImmutableMap.of((Object)k1.substring(0, s1), (Object)DocNode.of(k1.substring(s1 + 1), v1), (Object)k2, (Object)v2));
        }
        if (s2 != -1) {
            return new PlainJavaObjectAdapter(OrderedImmutableMap.of((Object)k1, (Object)v1, (Object)k2.substring(0, s2), (Object)DocNode.of(k2.substring(s2 + 1), v2)));
        }
        return new PlainJavaObjectAdapter(OrderedImmutableMap.of((Object)k1, (Object)v1, (Object)k2, (Object)v2));
    }

    public static DocNode of(String k1, Object v1, String k2, Object v2, String k3, Object v3) {
        int s1 = k1.indexOf(46);
        int s2 = k2.indexOf(46);
        int s3 = k3.indexOf(46);
        if (s1 != -1) {
            if (s2 != -1) {
                String k2b;
                if (s3 != -1) {
                    String k1b = k1.substring(0, s1);
                    String k2b2 = k2.substring(0, s2);
                    String k3b = k3.substring(0, s3);
                    if (k1b.equals(k2b2)) {
                        if (k2b2.equals(k3b)) {
                            return new PlainJavaObjectAdapter(OrderedImmutableMap.of((Object)k1b, (Object)DocNode.of(k1.substring(s1 + 1), v1, k2.substring(s2 + 1), v2, k3.substring(s3 + 1), v3)));
                        }
                        return new PlainJavaObjectAdapter(OrderedImmutableMap.of((Object)k1b, (Object)DocNode.of(k1.substring(s1 + 1), v1, k2.substring(s2 + 1), v2), (Object)k3b, (Object)DocNode.of(k3.substring(s3 + 1), v3)));
                    }
                    if (k2b2.equals(k3b)) {
                        return new PlainJavaObjectAdapter(OrderedImmutableMap.of((Object)k1b, (Object)DocNode.of(k1.substring(s1 + 1), v1), (Object)k2b2, (Object)DocNode.of(k2.substring(s2 + 1), v2, k3.substring(s3 + 1), v3)));
                    }
                    if (k1b.equals(k3b)) {
                        return new PlainJavaObjectAdapter(OrderedImmutableMap.of((Object)k1b, (Object)DocNode.of(k1.substring(s1 + 1), v1, k3.substring(s3 + 1), v3), (Object)k2b2, (Object)DocNode.of(k2.substring(s2 + 1), v2)));
                    }
                    return new PlainJavaObjectAdapter(OrderedImmutableMap.of((Object)k1b, (Object)DocNode.of(k1.substring(s1 + 1), v1), (Object)k2b2, (Object)DocNode.of(k2.substring(s2 + 1), v2), (Object)k3b, (Object)DocNode.of(k3.substring(s3 + 1), v3)));
                }
                String k1b = k1.substring(0, s1);
                if (k1b.equals(k2b = k2.substring(0, s2))) {
                    return new PlainJavaObjectAdapter(OrderedImmutableMap.of((Object)k1b, (Object)DocNode.of(k1.substring(s1 + 1), v1, k2.substring(s2 + 1), v2), (Object)k3, (Object)v3));
                }
                return new PlainJavaObjectAdapter(OrderedImmutableMap.of((Object)k1b, (Object)DocNode.of(k1.substring(s1 + 1), v1), (Object)k2b, (Object)DocNode.of(k2.substring(s2 + 1), v2), (Object)k3, (Object)v3));
            }
            if (s3 != -1) {
                String k3b;
                String k1b = k1.substring(0, s1);
                if (k1b.equals(k3b = k3.substring(0, s3))) {
                    return new PlainJavaObjectAdapter(OrderedImmutableMap.of((Object)k1b, (Object)DocNode.of(k1.substring(s1 + 1), v1, k3.substring(s3 + 1), v3), (Object)k2, (Object)v2));
                }
                return new PlainJavaObjectAdapter(OrderedImmutableMap.of((Object)k1b, (Object)DocNode.of(k1.substring(s1 + 1), v1), (Object)k2, (Object)v2, (Object)k3b, (Object)DocNode.of(k3.substring(s3 + 1), v3)));
            }
            return new PlainJavaObjectAdapter(OrderedImmutableMap.of((Object)k1.substring(0, s1), (Object)DocNode.of(k1.substring(s1 + 1), v1), (Object)k2, (Object)v2, (Object)k3, (Object)v3));
        }
        if (s2 != -1) {
            if (s3 != -1) {
                String k3b;
                String k2b = k2.substring(0, s2);
                if (k2b.equals(k3b = k3.substring(0, s3))) {
                    return new PlainJavaObjectAdapter(OrderedImmutableMap.of((Object)k1, (Object)v1, (Object)k2b, (Object)DocNode.of(k2.substring(s2 + 1), v2, k3.substring(s3 + 1), v3)));
                }
                return new PlainJavaObjectAdapter(OrderedImmutableMap.of((Object)k1, (Object)v1, (Object)k2b, (Object)DocNode.of(k2.substring(s2 + 1), v2), (Object)k3b, (Object)DocNode.of(k3.substring(s3 + 1), v3)));
            }
            return new PlainJavaObjectAdapter(OrderedImmutableMap.of((Object)k1, (Object)v1, (Object)k2.substring(0, s2), (Object)DocNode.of(k2.substring(s2 + 1), v2), (Object)k3, (Object)v3));
        }
        if (s3 != -1) {
            return new PlainJavaObjectAdapter(OrderedImmutableMap.of((Object)k1, (Object)v1, (Object)k2, (Object)v2, (Object)k3.substring(0, s3), (Object)DocNode.of(k3.substring(s3 + 1), v3)));
        }
        return new PlainJavaObjectAdapter(OrderedImmutableMap.of((Object)k1, (Object)v1, (Object)k2, (Object)v2, (Object)k3, (Object)v3));
    }

    public static DocNode of(String k1, Object v1, String k2, Object v2, String k3, Object v3, String k4, Object v4) {
        int s1 = k1.indexOf(46);
        int s2 = k2.indexOf(46);
        int s3 = k3.indexOf(46);
        int s4 = k4.indexOf(46);
        if (s1 != -1) {
            if (s2 != -1) {
                String k2b;
                if (s3 != -1) {
                    if (s4 != -1) {
                        String k1b = k1.substring(0, s1);
                        String k2b2 = k2.substring(0, s2);
                        String k3b = k3.substring(0, s3);
                        String k4b = k4.substring(0, s4);
                        if (k1b.equals(k2b2)) {
                            if (k2b2.equals(k3b)) {
                                if (k3b.equals(k4b)) {
                                    return new PlainJavaObjectAdapter(OrderedImmutableMap.of((Object)k1b, (Object)DocNode.of(k1.substring(s1 + 1), v1, k2.substring(s2 + 1), v2, k3.substring(s3 + 1), v3, k4.substring(s4 + 1), v4)));
                                }
                                return new PlainJavaObjectAdapter(OrderedImmutableMap.of((Object)k1b, (Object)DocNode.of(k1.substring(s1 + 1), v1, k2.substring(s2 + 1), v2, k3.substring(s3 + 1), v3), (Object)k4b, (Object)DocNode.of(k4.substring(s4 + 1), v4)));
                            }
                            if (k3b.equals(k4b)) {
                                return new PlainJavaObjectAdapter(OrderedImmutableMap.of((Object)k1b, (Object)DocNode.of(k1.substring(s1 + 1), v1, k2.substring(s2 + 1), v2), (Object)k3b, (Object)DocNode.of(k3.substring(s3 + 1), v3, k4.substring(s4 + 1), v4)));
                            }
                            if (k1b.equals(k4b)) {
                                return new PlainJavaObjectAdapter(OrderedImmutableMap.of((Object)k1b, (Object)DocNode.of(k1.substring(s1 + 1), v1, k2.substring(s2 + 1), v2, k4.substring(s4 + 1), v4), (Object)k3b, (Object)DocNode.of(k3.substring(s3 + 1), v3)));
                            }
                            return new PlainJavaObjectAdapter(OrderedImmutableMap.of((Object)k1b, (Object)DocNode.of(k1.substring(s1 + 1), v1, k2.substring(s2 + 1), v2), (Object)k3b, (Object)DocNode.of(k3.substring(s3 + 1), v3), (Object)k4b, (Object)DocNode.of(k4.substring(s4 + 1), v4)));
                        }
                        if (k2b2.equals(k3b)) {
                            if (k3b.equals(k4b)) {
                                return new PlainJavaObjectAdapter(OrderedImmutableMap.of((Object)k1b, (Object)DocNode.of(k1.substring(s1 + 1), v1), (Object)k2b2, (Object)DocNode.of(k2.substring(s2 + 1), v2, k3.substring(s3 + 1), v3, k4.substring(s4 + 1), v4)));
                            }
                            if (k1b.equals(k4b)) {
                                return new PlainJavaObjectAdapter(OrderedImmutableMap.of((Object)k1b, (Object)DocNode.of(k1.substring(s1 + 1), v1, k4.substring(s4 + 1), v4), (Object)k2b2, (Object)DocNode.of(k2.substring(s2 + 1), v2, k3.substring(s3 + 1), v3)));
                            }
                            return new PlainJavaObjectAdapter(OrderedImmutableMap.of((Object)k1b, (Object)DocNode.of(k1.substring(s1 + 1), v1), (Object)k2b2, (Object)DocNode.of(k2.substring(s2 + 1), v2, k3.substring(s3 + 1), v3), (Object)k4b, (Object)DocNode.of(k4.substring(s4 + 1), v4)));
                        }
                        if (k3b.equals(k4b)) {
                            if (k1b.equals(k3b)) {
                                return new PlainJavaObjectAdapter(OrderedImmutableMap.of((Object)k1b, (Object)DocNode.of(k1.substring(s1 + 1), v1, k3.substring(s3 + 1), v3, k4.substring(s4 + 1), v4), (Object)k2b2, (Object)DocNode.of(k2.substring(s2 + 1), v2)));
                            }
                            return new PlainJavaObjectAdapter(OrderedImmutableMap.of((Object)k1b, (Object)DocNode.of(k1.substring(s1 + 1), v1), (Object)k2b2, (Object)DocNode.of(k2.substring(s2 + 1), v2), (Object)k3b, (Object)DocNode.of(k3.substring(s3 + 1), v3, k4.substring(s4 + 1), v4)));
                        }
                        if (k1b.equals(k3b)) {
                            if (k2b2.equals(k4b)) {
                                return new PlainJavaObjectAdapter(OrderedImmutableMap.of((Object)k1b, (Object)DocNode.of(k1.substring(s1 + 1), v1, k3.substring(s3 + 1), v3), (Object)k2b2, (Object)DocNode.of(k2.substring(s2 + 1), v2, k4.substring(s4 + 1), v4)));
                            }
                            return new PlainJavaObjectAdapter(OrderedImmutableMap.of((Object)k1b, (Object)DocNode.of(k1.substring(s1 + 1), v1, k3.substring(s3 + 1), v3), (Object)k2b2, (Object)DocNode.of(k2.substring(s2 + 1), v2), (Object)k4b, (Object)DocNode.of(k4.substring(s4 + 1), v4)));
                        }
                        if (k2b2.equals(k4b)) {
                            return new PlainJavaObjectAdapter(OrderedImmutableMap.of((Object)k1b, (Object)DocNode.of(k1.substring(s1 + 1), v1), (Object)k2b2, (Object)DocNode.of(k2.substring(s2 + 1), v2, k4.substring(s4 + 1), v4), (Object)k3b, (Object)DocNode.of(k3.substring(s3 + 1), v3)));
                        }
                        if (k1b.equals(k4b)) {
                            return new PlainJavaObjectAdapter(OrderedImmutableMap.of((Object)k1b, (Object)DocNode.of(k1.substring(s1 + 1), v1, k4.substring(s4 + 1), v4), (Object)k2b2, (Object)DocNode.of(k2.substring(s2 + 1), v2), (Object)k3b, (Object)DocNode.of(k3.substring(s3 + 1), v3)));
                        }
                        return new PlainJavaObjectAdapter(OrderedImmutableMap.of((Object)k1b, (Object)DocNode.of(k1.substring(s1 + 1), v1), (Object)k2b2, (Object)DocNode.of(k2.substring(s2 + 1), v2), (Object)k3b, (Object)DocNode.of(k3.substring(s3 + 1), v3), (Object)k4b, (Object)DocNode.of(k4.substring(s4 + 1), v4)));
                    }
                    String k1b = k1.substring(0, s1);
                    String k2b3 = k2.substring(0, s2);
                    String k3b = k3.substring(0, s3);
                    if (k1b.equals(k2b3)) {
                        if (k2b3.equals(k3b)) {
                            return new PlainJavaObjectAdapter(OrderedImmutableMap.of((Object)k1b, (Object)DocNode.of(k1.substring(s1 + 1), v1, k2.substring(s2 + 1), v2, k3.substring(s3 + 1), v3), (Object)k4, (Object)v4));
                        }
                        return new PlainJavaObjectAdapter(OrderedImmutableMap.of((Object)k1b, (Object)DocNode.of(k1.substring(s1 + 1), v1, k2.substring(s2 + 1), v2), (Object)k3b, (Object)DocNode.of(k3.substring(s3 + 1), v3), (Object)k4, (Object)v4));
                    }
                    if (k2b3.equals(k3b)) {
                        return new PlainJavaObjectAdapter(OrderedImmutableMap.of((Object)k1b, (Object)DocNode.of(k1.substring(s1 + 1), v1), (Object)k2b3, (Object)DocNode.of(k2.substring(s2 + 1), v2, k3.substring(s3 + 1), v3), (Object)k4, (Object)v4));
                    }
                    if (k1b.equals(k3b)) {
                        return new PlainJavaObjectAdapter(OrderedImmutableMap.of((Object)k1b, (Object)DocNode.of(k1.substring(s1 + 1), v1, k3.substring(s3 + 1), v3), (Object)k2b3, (Object)DocNode.of(k2.substring(s2 + 1), v2), (Object)k4, (Object)v4));
                    }
                    return new PlainJavaObjectAdapter(OrderedImmutableMap.of((Object)k1b, (Object)DocNode.of(k1.substring(s1 + 1), v1), (Object)k2b3, (Object)DocNode.of(k2.substring(s2 + 1), v2), (Object)k3b, (Object)DocNode.of(k3.substring(s3 + 1), v3), (Object)k4, (Object)v4));
                }
                if (s4 != -1) {
                    String k1b = k1.substring(0, s1);
                    String k2b4 = k2.substring(0, s2);
                    String k4b = k4.substring(0, s4);
                    if (k1b.equals(k2b4)) {
                        if (k2b4.equals(k4b)) {
                            return new PlainJavaObjectAdapter(OrderedImmutableMap.of((Object)k1b, (Object)DocNode.of(k1.substring(s1 + 1), v1, k2.substring(s2 + 1), v2, k4.substring(s4 + 1), v4), (Object)k3, (Object)v3));
                        }
                        return new PlainJavaObjectAdapter(OrderedImmutableMap.of((Object)k1b, (Object)DocNode.of(k1.substring(s1 + 1), v1, k2.substring(s2 + 1), v2), (Object)k3, (Object)v3, (Object)k4b, (Object)DocNode.of(k4.substring(s4 + 1), v4)));
                    }
                    if (k2b4.equals(k4b)) {
                        return new PlainJavaObjectAdapter(OrderedImmutableMap.of((Object)k1b, (Object)DocNode.of(k1.substring(s1 + 1), v1), (Object)k2b4, (Object)DocNode.of(k2.substring(s2 + 1), v2, k4.substring(s4 + 1), v4), (Object)k3, (Object)v3));
                    }
                    if (k1b.equals(k4b)) {
                        return new PlainJavaObjectAdapter(OrderedImmutableMap.of((Object)k1b, (Object)DocNode.of(k1.substring(s1 + 1), v1, k4.substring(s4 + 1), v4), (Object)k2b4, (Object)DocNode.of(k2.substring(s2 + 1), v2), (Object)k3, (Object)v3));
                    }
                    return new PlainJavaObjectAdapter(OrderedImmutableMap.of((Object)k1b, (Object)DocNode.of(k1.substring(s1 + 1), v1), (Object)k2b4, (Object)DocNode.of(k2.substring(s2 + 1), v2), (Object)k3, (Object)v3, (Object)k4b, (Object)DocNode.of(k4.substring(s4 + 1), v4)));
                }
                String k1b = k1.substring(0, s1);
                if (k1b.equals(k2b = k2.substring(0, s2))) {
                    return new PlainJavaObjectAdapter(OrderedImmutableMap.of((Object)k1b, (Object)DocNode.of(k1.substring(s1 + 1), v1, k2.substring(s2 + 1), v2), (Object)k3, (Object)v3, (Object)k4, (Object)v4));
                }
                return new PlainJavaObjectAdapter(OrderedImmutableMap.of((Object)k1b, (Object)DocNode.of(k1.substring(s1 + 1), v1), (Object)k2b, (Object)DocNode.of(k2.substring(s2 + 1), v2), (Object)k3, (Object)v3, (Object)k4, (Object)v4));
            }
            if (s3 != -1) {
                String k3b;
                if (s4 != -1) {
                    String k1b = k1.substring(0, s1);
                    String k3b2 = k3.substring(0, s3);
                    String k4b = k4.substring(0, s4);
                    if (k1b.equals(k3b2)) {
                        if (k3b2.equals(k4b)) {
                            return new PlainJavaObjectAdapter(OrderedImmutableMap.of((Object)k1b, (Object)DocNode.of(k1.substring(s1 + 1), v1, k3.substring(s3 + 1), v3, k4.substring(s4 + 1), v4), (Object)k2, (Object)v2));
                        }
                        return new PlainJavaObjectAdapter(OrderedImmutableMap.of((Object)k1b, (Object)DocNode.of(k1.substring(s1 + 1), v1, k3.substring(s3 + 1), v3), (Object)k2, (Object)v2, (Object)k4b, (Object)DocNode.of(k4.substring(s4 + 1), v4)));
                    }
                    if (k3b2.equals(k4b)) {
                        return new PlainJavaObjectAdapter(OrderedImmutableMap.of((Object)k1b, (Object)DocNode.of(k1.substring(s1 + 1), v1), (Object)k2, (Object)v2, (Object)k3b2, (Object)DocNode.of(k3.substring(s3 + 1), v3, k4.substring(s4 + 1), v4)));
                    }
                    if (k1b.equals(k4b)) {
                        return new PlainJavaObjectAdapter(OrderedImmutableMap.of((Object)k1b, (Object)DocNode.of(k1.substring(s1 + 1), v1, k4.substring(s4 + 1), v4), (Object)k2, (Object)v2, (Object)k3b2, (Object)DocNode.of(k3.substring(s3 + 1), v3)));
                    }
                    return new PlainJavaObjectAdapter(OrderedImmutableMap.of((Object)k1b, (Object)DocNode.of(k1.substring(s1 + 1), v1), (Object)k2, (Object)v2, (Object)k3b2, (Object)DocNode.of(k3.substring(s3 + 1), v3), (Object)k4b, (Object)DocNode.of(k4.substring(s4 + 1), v4)));
                }
                String k1b = k1.substring(0, s1);
                if (k1b.equals(k3b = k3.substring(0, s3))) {
                    return new PlainJavaObjectAdapter(OrderedImmutableMap.of((Object)k1b, (Object)DocNode.of(k1.substring(s1 + 1), v1, k3.substring(s3 + 1), v3), (Object)k2, (Object)v2, (Object)k4, (Object)v4));
                }
                return new PlainJavaObjectAdapter(OrderedImmutableMap.of((Object)k1b, (Object)DocNode.of(k1.substring(s1 + 1), v1), (Object)k2, (Object)v2, (Object)k3b, (Object)DocNode.of(k3.substring(s3 + 1), v3), (Object)k4, (Object)v4));
            }
            if (s4 != -1) {
                String k4b;
                String k1b = k1.substring(0, s1);
                if (k1b.equals(k4b = k4.substring(0, s4))) {
                    return new PlainJavaObjectAdapter(OrderedImmutableMap.of((Object)k1b, (Object)DocNode.of(k1.substring(s1 + 1), v1, k4.substring(s4 + 1), v4), (Object)k2, (Object)v2, (Object)k3, (Object)v3));
                }
                return new PlainJavaObjectAdapter(OrderedImmutableMap.of((Object)k1b, (Object)DocNode.of(k1.substring(s1 + 1), v1), (Object)k2, (Object)v2, (Object)k3, (Object)v3, (Object)k4b, (Object)DocNode.of(k4.substring(s4 + 1), v4)));
            }
            return new PlainJavaObjectAdapter(OrderedImmutableMap.of((Object)k1.substring(0, s1), (Object)DocNode.of(k1.substring(s1 + 1), v1), (Object)k2, (Object)v2, (Object)k3, (Object)v3, (Object)k4, (Object)v4));
        }
        if (s2 != -1) {
            if (s3 != -1) {
                String k3b;
                if (s4 != -1) {
                    String k2b = k2.substring(0, s2);
                    String k3b3 = k3.substring(0, s3);
                    String k4b = k4.substring(0, s4);
                    if (k2b.equals(k3b3)) {
                        if (k3b3.equals(k4b)) {
                            return new PlainJavaObjectAdapter(OrderedImmutableMap.of((Object)k1, (Object)v1, (Object)k2b, (Object)DocNode.of(k2.substring(s2 + 1), v2, k3.substring(s3 + 1), v3, k4.substring(s4 + 1), v4)));
                        }
                        return new PlainJavaObjectAdapter(OrderedImmutableMap.of((Object)k1, (Object)v1, (Object)k2b, (Object)DocNode.of(k2.substring(s2 + 1), v2, k3.substring(s3 + 1), v3), (Object)k4b, (Object)DocNode.of(k4.substring(s4 + 1), v4)));
                    }
                    if (k3b3.equals(k4b)) {
                        return new PlainJavaObjectAdapter(OrderedImmutableMap.of((Object)k1, (Object)v1, (Object)k2b, (Object)DocNode.of(k2.substring(s2 + 1), v2), (Object)k3b3, (Object)DocNode.of(k3.substring(s3 + 1), v3, k4.substring(s4 + 1), v4)));
                    }
                    if (k2b.equals(k4b)) {
                        return new PlainJavaObjectAdapter(OrderedImmutableMap.of((Object)k1, (Object)v1, (Object)k2b, (Object)DocNode.of(k2.substring(s2 + 1), v2, k4.substring(s4 + 1), v4), (Object)k3b3, (Object)DocNode.of(k3.substring(s3 + 1), v3)));
                    }
                    return new PlainJavaObjectAdapter(OrderedImmutableMap.of((Object)k1, (Object)v1, (Object)k2b, (Object)DocNode.of(k2.substring(s2 + 1), v2), (Object)k3b3, (Object)DocNode.of(k3.substring(s3 + 1), v3), (Object)k4b, (Object)DocNode.of(k4.substring(s4 + 1), v4)));
                }
                String k2b = k2.substring(0, s2);
                if (k2b.equals(k3b = k3.substring(0, s3))) {
                    return new PlainJavaObjectAdapter(OrderedImmutableMap.of((Object)k1, (Object)v1, (Object)k2b, (Object)DocNode.of(k2.substring(s2 + 1), v2, k3.substring(s3 + 1), v3), (Object)k4, (Object)v4));
                }
                return new PlainJavaObjectAdapter(OrderedImmutableMap.of((Object)k1, (Object)v1, (Object)k2b, (Object)DocNode.of(k2.substring(s2 + 1), v2), (Object)k3b, (Object)DocNode.of(k3.substring(s3 + 1), v3), (Object)k4, (Object)v4));
            }
            if (s4 != -1) {
                String k4b;
                String k2b = k2.substring(0, s2);
                if (k2b.equals(k4b = k4.substring(0, s4))) {
                    return new PlainJavaObjectAdapter(OrderedImmutableMap.of((Object)k1, (Object)v1, (Object)k2b, (Object)DocNode.of(k2.substring(s2 + 1), v2, k4.substring(s4 + 1), v4), (Object)k3, (Object)v3));
                }
                return new PlainJavaObjectAdapter(OrderedImmutableMap.of((Object)k1, (Object)v1, (Object)k2b, (Object)DocNode.of(k2.substring(s2 + 1), v2), (Object)k3, (Object)v3, (Object)k4b, (Object)DocNode.of(k4.substring(s4 + 1), v4)));
            }
            return new PlainJavaObjectAdapter(OrderedImmutableMap.of((Object)k1, (Object)v1, (Object)k2.substring(0, s2), (Object)DocNode.of(k2.substring(s2 + 1), v2), (Object)k3, (Object)v3, (Object)k4, (Object)v4));
        }
        if (s3 != -1) {
            if (s4 != -1) {
                String k4b;
                String k3b = k3.substring(0, s3);
                if (k3b.equals(k4b = k4.substring(0, s4))) {
                    return new PlainJavaObjectAdapter(OrderedImmutableMap.of((Object)k1, (Object)v1, (Object)k2, (Object)v2, (Object)k3b, (Object)DocNode.of(k3.substring(s3 + 1), v3, k4.substring(s4 + 1), v4)));
                }
                return new PlainJavaObjectAdapter(OrderedImmutableMap.of((Object)k1, (Object)v1, (Object)k2, (Object)v2, (Object)k3b, (Object)DocNode.of(k3.substring(s3 + 1), v3), (Object)k4b, (Object)DocNode.of(k4.substring(s4 + 1), v4)));
            }
            return new PlainJavaObjectAdapter(OrderedImmutableMap.of((Object)k1, (Object)v1, (Object)k2, (Object)v2, (Object)k3.substring(0, s3), (Object)DocNode.of(k3.substring(s3 + 1), v3), (Object)k4, (Object)v4));
        }
        if (s4 != -1) {
            return new PlainJavaObjectAdapter(OrderedImmutableMap.of((Object)k1, (Object)v1, (Object)k2, (Object)v2, (Object)k3, (Object)v3, (Object)k4.substring(0, s4), (Object)DocNode.of(k4.substring(s4 + 1), v4)));
        }
        return new PlainJavaObjectAdapter(OrderedImmutableMap.of((Object)k1, (Object)v1, (Object)k2, (Object)v2, (Object)k3, (Object)v3, (Object)k4, (Object)v4));
    }

    public static DocNode of(String k1, Object v1, String k2, Object v2, String k3, Object v3, String k4, Object v4, String k5, Object v5, Object ... more) {
        OrderedImmutableMap.Builder builder = new OrderedImmutableMap.Builder(5 + (more != null ? more.length : 0));
        DocNode.add((OrderedImmutableMap.Builder<String, Object>)builder, k1, v1);
        DocNode.add((OrderedImmutableMap.Builder<String, Object>)builder, k2, v2);
        DocNode.add((OrderedImmutableMap.Builder<String, Object>)builder, k3, v3);
        DocNode.add((OrderedImmutableMap.Builder<String, Object>)builder, k4, v4);
        DocNode.add((OrderedImmutableMap.Builder<String, Object>)builder, k5, v5);
        if (more != null) {
            for (int i = 0; i < more.length; i += 2) {
                DocNode.add((OrderedImmutableMap.Builder<String, Object>)builder, String.valueOf(more[i]), more[i + 1]);
            }
        }
        return new PlainJavaObjectAdapter(DocNode.build((OrderedImmutableMap.Builder<String, Object>)builder));
    }

    public static DocNode wrap(Object object) {
        if (object instanceof DocNode) {
            return (DocNode)object;
        }
        return new PlainJavaObjectAdapter(object);
    }

    public static DocNode array(Object ... array) {
        return new PlainJavaObjectAdapter(ImmutableList.ofArray((Object[])array));
    }

    private static void add(OrderedImmutableMap.Builder<String, Object> builder, String key, Object value) {
        int s = key.indexOf(46);
        if (s == -1) {
            builder.put((Object)key, value);
        } else {
            String base = key.substring(0, s);
            Object container = builder.get((Object)base);
            if (container == null) {
                OrderedImmutableMap.Builder subBuilder = new OrderedImmutableMap.Builder();
                builder.put((Object)base, (Object)subBuilder);
                DocNode.add((OrderedImmutableMap.Builder<String, Object>)subBuilder, key.substring(s + 1), value);
            } else if (container instanceof OrderedImmutableMap.Builder) {
                OrderedImmutableMap.Builder subBuilder = (OrderedImmutableMap.Builder)container;
                DocNode.add((OrderedImmutableMap.Builder<String, Object>)subBuilder, key.substring(s + 1), value);
            } else {
                throw new IllegalStateException("Key " + base + " does already exist");
            }
        }
    }

    private static OrderedImmutableMap<String, Object> build(OrderedImmutableMap.Builder<String, Object> builder) {
        return builder.build((T value) -> {
            if (value instanceof OrderedImmutableMap.Builder) {
                OrderedImmutableMap.Builder subBuilder = (OrderedImmutableMap.Builder)value;
                return DocNode.build((OrderedImmutableMap.Builder<String, Object>)subBuilder);
            }
            return value;
        });
    }

    public abstract Object get(String var1);

    public abstract ImmutableList<DocNode> getAsListOfNodes(String var1);

    public abstract DocNode getAsNode(String var1);

    public abstract ImmutableMap<String, Object> toMap();

    public abstract boolean isMap();

    public abstract boolean isList();

    public abstract boolean isList(String var1);

    public boolean isScalar() {
        return !this.isMap() && !this.isList() && !this.isNull();
    }

    public abstract ImmutableList<Object> toList();

    public abstract DocNode splitDottedAttributeNamesToTree() throws UnexpectedDocumentStructureException;

    @Override
    public Object toBasicObject() {
        return this.get(null);
    }

    public Map<String, DocNode> toMapOfNodes() {
        return MapView.mapValues(this.toMap(), o -> DocNode.wrap(o));
    }

    public ImmutableList<DocNode> toListOfNodes() {
        return this.getAsListOfNodes(null);
    }

    public boolean isNull() {
        return this.toBasicObject() == null;
    }

    public boolean isString() {
        return this.toBasicObject() instanceof String;
    }

    public boolean isNumber() {
        return this.toBasicObject() instanceof Number;
    }

    public boolean hasAny(String ... keys) {
        for (String key : keys) {
            if (!this.containsKey(key)) continue;
            return true;
        }
        return false;
    }

    public DocNode with(Document<?> other) {
        DocNode otherDocNode = other instanceof DocNode ? (DocNode)other : other.toDocNode();
        if (otherDocNode.isEmpty()) {
            return this;
        }
        if (!otherDocNode.isMap() || !this.isMap()) {
            return otherDocNode;
        }
        return new PlainJavaObjectAdapter(this.toMap().with(otherDocNode.toMap()));
    }

    public DocNode with(String key, Object value) {
        return new PlainJavaObjectAdapter(this.toMap().with((Object)key, value));
    }

    public DocNode without(String ... attrs) {
        HashSet<String> attrsSet = new HashSet<String>(Arrays.asList(attrs));
        LinkedHashMap newMap = new LinkedHashMap(this.size());
        for (Map.Entry entry : this.entrySet()) {
            if (attrsSet.contains(entry.getKey())) continue;
            newMap.put((String)entry.getKey(), entry.getValue());
        }
        return DocNode.wrap(newMap);
    }

    public Object get(String attribute, String ... attributePath) {
        DocNode docNode = this.getAsNode(attribute);
        for (int i = 0; i < attributePath.length - 1 && docNode != null; docNode = docNode.getAsNode(attributePath[i]), ++i) {
        }
        if (docNode != null) {
            return docNode.get(attributePath[attributePath.length - 1]);
        }
        return null;
    }

    public DocNode getAsNode(String attribute, String ... moreAttributes) {
        DocNode docNode = this.getAsNode(attribute);
        for (int i = 0; i < moreAttributes.length && docNode != null && !docNode.isNull(); docNode = docNode.getAsNode(moreAttributes[i]), ++i) {
        }
        return docNode;
    }

    public ImmutableList<String> toListOfStrings() {
        ImmutableList<Object> list = this.toList();
        ImmutableList.Builder result = new ImmutableList.Builder(list.size());
        for (Object e : list) {
            result.add((Object)(e != null ? e.toString() : null));
        }
        return result.build();
    }

    public String getAsString(String attribute) {
        Object object = this.get(attribute);
        if (object != null) {
            return object.toString();
        }
        return null;
    }

    public Number getNumber(String attribute) throws ConfigValidationException {
        Object object = this.get(attribute);
        if (object == null) {
            return null;
        }
        if (object instanceof Number) {
            return (Number)object;
        }
        throw new ConfigValidationException(new InvalidAttributeValue(attribute, object, (Object)"A number value"));
    }

    public BigDecimal getBigDecimal(String attribute) throws ConfigValidationException {
        Object object = this.get(attribute);
        if (object == null) {
            return null;
        }
        if (object instanceof BigDecimal) {
            return (BigDecimal)object;
        }
        if (object instanceof Double || object instanceof Float) {
            return new BigDecimal(((Number)object).doubleValue());
        }
        if (object instanceof Long || object instanceof Integer || object instanceof Short) {
            return new BigDecimal(((Number)object).longValue());
        }
        try {
            return new BigDecimal(object.toString());
        }
        catch (NumberFormatException e) {
            throw new ConfigValidationException(new InvalidAttributeValue(attribute, object, (Object)"A number value").cause(e));
        }
    }

    public Boolean getBoolean(String attribute) throws ConfigValidationException {
        Object object = this.get(attribute);
        if (object == null) {
            return null;
        }
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        throw new ConfigValidationException(new InvalidAttributeValue(attribute, object, (Object)"Must be true or false"));
    }

    public <R> R get(String attribute, ValidatingFunction<String, R> conversionFunction, Object expected) throws ConfigValidationException {
        String value = this.getAsString(attribute);
        if (value == null) {
            return null;
        }
        try {
            return conversionFunction.apply(value);
        }
        catch (ConfigValidationException e) {
            throw new ConfigValidationException(e.getValidationErrors());
        }
        catch (Exception e) {
            throw new ConfigValidationException(new InvalidAttributeValue(attribute, (Object)value, expected).cause(e));
        }
    }

    public <R> R getFromNode(String attribute, ValidatingFunction<DocNode, R> conversionFunction, Object expected) throws ConfigValidationException {
        DocNode value = this.getAsNode(attribute);
        if (value == null) {
            return null;
        }
        try {
            return conversionFunction.apply(value);
        }
        catch (ConfigValidationException e) {
            throw new ConfigValidationException(e.getValidationErrors());
        }
        catch (Exception e) {
            throw new ConfigValidationException(new InvalidAttributeValue(attribute, value, expected).cause(e));
        }
    }

    public <R> ImmutableList<R> getList(String attribute, ValidatingFunction<String, R> conversionFunction, Object expected) throws ConfigValidationException {
        ImmutableList<DocNode> nodeList = this.getAsListOfNodes(attribute);
        ImmutableList.Builder result = new ImmutableList.Builder(nodeList.size());
        ValidationErrors validationErrors = new ValidationErrors();
        int index = 0;
        for (DocNode node : nodeList) {
            try {
                result.add(node.get(null, conversionFunction, expected));
            }
            catch (ConfigValidationException e) {
                validationErrors.add(String.valueOf(index), e);
            }
            ++index;
        }
        validationErrors.throwExceptionForPresentErrors();
        return result.build();
    }

    public <R> ImmutableList<R> getListFromNodes(String attribute, ValidatingFunction<DocNode, R> conversionFunction, Object expected) throws ConfigValidationException {
        ImmutableList<DocNode> nodeList = this.getAsListOfNodes(attribute);
        ImmutableList.Builder result = new ImmutableList.Builder(nodeList.size());
        ValidationErrors validationErrors = new ValidationErrors();
        int index = 0;
        for (DocNode node : nodeList) {
            try {
                result.add(node.getFromNode(null, conversionFunction, expected));
            }
            catch (ConfigValidationException e) {
                validationErrors.add(String.valueOf(index), e);
            }
            ++index;
        }
        validationErrors.throwExceptionForPresentErrors();
        return result.build();
    }

    public <R> ImmutableList<R> getAsList(String attribute, ValidatingFunction<String, R> conversionFunction, Object expected) throws ConfigValidationException {
        if (!this.hasNonNull(attribute)) {
            return ImmutableList.empty();
        }
        if (this.isList(attribute)) {
            return this.getList(attribute, conversionFunction, expected);
        }
        return ImmutableList.of(this.get(attribute, conversionFunction, expected));
    }

    public <R> ImmutableList<R> getAsListFromNodes(String attribute, ValidatingFunction<DocNode, R> conversionFunction) throws ConfigValidationException {
        return this.getAsListFromNodes(attribute, conversionFunction, null);
    }

    public <R> ImmutableList<R> getAsListFromNodes(String attribute, ValidatingFunction<DocNode, R> conversionFunction, Object expected) throws ConfigValidationException {
        if (!this.hasNonNull(attribute)) {
            return ImmutableList.empty();
        }
        if (this.isList(attribute)) {
            return this.getListFromNodes(attribute, conversionFunction, expected);
        }
        return ImmutableList.of(this.getFromNode(attribute, conversionFunction, expected));
    }

    public ImmutableList<String> getListOfStrings(String attribute) throws ConfigValidationException {
        return this.getList(attribute, s -> s, "List of strings");
    }

    public ImmutableList<String> getAsListOfStrings(String attribute) {
        try {
            return this.getAsList(attribute, s -> s, "List of strings");
        }
        catch (ConfigValidationException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean hasNonNull(String attribute) {
        return this.get(attribute) != null;
    }

    @Override
    public boolean containsValue(Object value) {
        if (!this.isMap()) {
            return false;
        }
        return this.values().contains(value);
    }

    @Override
    public Object get(Object key) {
        if (key instanceof String) {
            return this.get((String)key);
        }
        return null;
    }

    public String getKey() {
        return this.key;
    }

    public List<?> findByJsonPath(String jsonPath) {
        return (List)JsonPath.using((Configuration)BasicJsonPathDefaultConfiguration.listDefaultConfiguration()).parse((Object)this).read(jsonPath, new Predicate[0]);
    }

    public ImmutableList<DocNode> findNodesByJsonPath(String jsonPath) {
        Object object = JsonPath.using((Configuration)BasicJsonPathDefaultConfiguration.listDefaultConfiguration()).parse((Object)this).read(jsonPath, new Predicate[0]);
        if (object instanceof List) {
            ImmutableList.Builder result = new ImmutableList.Builder(((List)object).size());
            for (Object subObject : (List)object) {
                result.add((Object)DocNode.wrap(subObject));
            }
            return result.build();
        }
        if (object != null) {
            return ImmutableList.of((Object)DocNode.wrap(object));
        }
        return ImmutableList.empty();
    }

    public <T> T findSingleValueByJsonPath(String jsonPath, Class<T> type) {
        return (T)JsonPath.using((Configuration)BasicJsonPathDefaultConfiguration.defaultConfiguration()).parse((Object)this).read(jsonPath, type, new Predicate[0]);
    }

    public DocNode findSingleNodeByJsonPath(String jsonPath) {
        Object object = JsonPath.using((Configuration)BasicJsonPathDefaultConfiguration.defaultConfiguration()).parse((Object)this).read(jsonPath, new Predicate[0]);
        if (object != null) {
            return DocNode.wrap(object);
        }
        return null;
    }

    @Override
    public Object put(String key, Object value) {
        throw new UnsupportedOperationException("DocumentNode instances cannot be modified");
    }

    @Override
    public Object remove(Object key) {
        throw new UnsupportedOperationException("DocumentNode instances cannot be modified");
    }

    @Override
    public void putAll(Map<? extends String, ? extends Object> m) {
        throw new UnsupportedOperationException("DocumentNode instances cannot be modified");
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("DocumentNode instances cannot be modified");
    }

    public Map<String, Object> toNormalizedMap() {
        return this.toMap();
    }

    public Number toNumber() throws ConfigValidationException {
        return this.getNumber(null);
    }

    @Override
    public String toString(Format format) {
        Object value = this.toBasicObject();
        if (value instanceof Map && format.equals(Format.JSON)) {
            return DocWriter.json().writeAsString(this.toNormalizedMap());
        }
        return DocWriter.format(format).writeAsString(value);
    }

    @Override
    public String toJsonString() {
        return this.toString(Format.JSON);
    }

    @Override
    public String toYamlString() {
        return this.toString(Format.YAML);
    }

    public String toString() {
        Object value = this.toBasicObject();
        if (value instanceof String) {
            return (String)value;
        }
        if (value instanceof Number || value instanceof Boolean || value instanceof Character) {
            return value.toString();
        }
        return this.toString(60);
    }

    protected String toString(int maxChars) {
        Object value = this.toBasicObject();
        if (value instanceof Map) {
            Map map = (Map)value;
            StringBuilder result = new StringBuilder("{");
            int count = 0;
            for (Map.Entry entry : map.entrySet()) {
                if (count != 0) {
                    result.append(", ");
                }
                if (result.length() >= maxChars) {
                    result.append(map.size() - count).append(" more ...");
                    break;
                }
                result.append(DocWriter.json().writeAsString(entry.getKey()));
                result.append(": ");
                result.append(DocNode.wrap(entry.getValue()).toString(maxChars / 2));
                ++count;
            }
            result.append("}");
            return result.toString();
        }
        if (value instanceof Collection) {
            Collection collection = (Collection)value;
            StringBuilder result = new StringBuilder("[");
            int count = 0;
            for (Object element : collection) {
                if (count != 0) {
                    result.append(", ");
                }
                if (result.length() >= maxChars) {
                    result.append(collection.size() - count).append(" more ...");
                    break;
                }
                result.append(DocNode.wrap(element).toString(maxChars / 2));
                ++count;
            }
            result.append("]");
            return result.toString();
        }
        return DocWriter.json().writeAsString(value);
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof DocNode)) {
            return false;
        }
        DocNode other = (DocNode)obj;
        Object thisObject = this.toBasicObject();
        Object otherObject = other.toBasicObject();
        return Objects.equals(thisObject, otherObject);
    }

    public DocNode flatten() {
        if (this.isFlat()) {
            return this;
        }
        return new DocNodeFlattener(this).flatten();
    }

    public boolean isFlat() {
        if (!this.isMap()) {
            return true;
        }
        for (Map.Entry entry : this.entrySet()) {
            Object value = entry.getValue();
            if (value instanceof DocNode) {
                DocNode docNode = (DocNode)value;
                if (!docNode.isMap() && !docNode.isList()) continue;
                return false;
            }
            if (value instanceof Map) {
                return false;
            }
            if (!(value instanceof Collection)) continue;
            return false;
        }
        return true;
    }

    public static class DocNodeParserBuilder {
        private final Format format;
        private final JsonFactory jsonFactory;

        private DocNodeParserBuilder(Format format) {
            this.format = format;
            this.jsonFactory = format.getJsonFactory();
        }

        public DocNode from(Reader in) throws DocumentParseException, IOException {
            try (JsonParser parser = this.jsonFactory.createParser(in);){
                DocNode docNode = DocNode.wrap(new DocReader(this.format, parser).read());
                return docNode;
            }
        }

        public DocNode from(String string) throws DocumentParseException {
            DocNode docNode;
            block9: {
                if (string == null || string.length() == 0) {
                    throw new DocumentParseException(new ValidationError(null, "The document is empty").expected(this.format.getName() + " document"));
                }
                JsonParser parser = this.jsonFactory.createParser(string);
                try {
                    docNode = DocNode.wrap(new DocReader(this.format, parser).read());
                    if (parser == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (parser != null) {
                            try {
                                parser.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
                parser.close();
            }
            return docNode;
        }

        public DocNode from(byte[] bytes) throws DocumentParseException {
            if (bytes == null || bytes.length == 0) {
                throw new DocumentParseException(new ValidationError(null, "The document is empty").expected(this.format.getName() + " document"));
            }
            try {
                return this.from(new ByteArrayInputStream(bytes));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public DocNode from(InputStream in) throws DocumentParseException, IOException {
            try (JsonParser parser = this.jsonFactory.createParser(in);){
                DocNode docNode = DocNode.wrap(new DocReader(this.format, parser).read());
                return docNode;
            }
        }

        public DocNode from(File file) throws DocumentParseException, FileNotFoundException, IOException {
            return this.from(new FileInputStream(file));
        }
    }

    private static class PlainJavaObjectAdapter
    extends DocNode {
        private final Object object;

        public PlainJavaObjectAdapter(Object object) {
            this(object, null);
        }

        public PlainJavaObjectAdapter(Object object, String key) {
            if (object instanceof PlainJavaObjectAdapter) {
                log.warn("Got {}; this should be not wrapped. Unwrapping", object, (Object)new Exception());
                object = ((PlainJavaObjectAdapter)object).object;
            }
            this.object = object;
            this.key = key;
        }

        @Override
        public Object get(String attribute) {
            if (attribute == null) {
                return this.object;
            }
            if (this.object instanceof Map) {
                return PlainJavaObjectAdapter.toBaseType(((Map)this.object).get(attribute));
            }
            return null;
        }

        @Override
        public DocNode getAsNode(String attribute) {
            return DocNode.wrap(this.get(attribute));
        }

        @Override
        public ImmutableList<DocNode> getAsListOfNodes(String attribute) {
            Object object = null;
            if (attribute == null) {
                object = this.object;
            } else if (this.object instanceof Map) {
                object = ((Map)this.object).get(attribute);
            }
            if (object == null) {
                return ImmutableList.empty();
            }
            if (object instanceof PlainJavaObjectAdapter) {
                object = ((PlainJavaObjectAdapter)object).object;
            }
            if (object instanceof Collection) {
                return PlainJavaObjectAdapter.toListOfDocumentNode((Collection)object);
            }
            return ImmutableList.of((Object)PlainJavaObjectAdapter.wrap(object));
        }

        @Override
        public <R> ImmutableList<R> getList(String attribute, ValidatingFunction<String, R> conversionFunction, Object expected) throws ConfigValidationException {
            if (attribute == null) {
                Object object = this.object;
            }
            if (!(this.object instanceof Map)) {
                return null;
            }
            Object object = ((Map)this.object).get(attribute);
            if (object == null) {
                return null;
            }
            if (object instanceof PlainJavaObjectAdapter) {
                object = ((PlainJavaObjectAdapter)object).object;
            }
            if (!(object instanceof Collection)) {
                throw new ConfigValidationException(new InvalidAttributeValue(attribute, object, (Object)"A list of values"));
            }
            Collection collection = (Collection)object;
            ImmutableList.Builder result = new ImmutableList.Builder(collection.size());
            ValidationErrors validationErrors = new ValidationErrors();
            int index = 0;
            for (Object subObject : collection) {
                try {
                    if (subObject == null) {
                        result.add(null);
                    } else {
                        result.add(conversionFunction.apply(subObject.toString()));
                    }
                }
                catch (Exception e) {
                    validationErrors.add(new InvalidAttributeValue(attribute + "." + index, subObject, expected).cause(e));
                }
                ++index;
            }
            validationErrors.throwExceptionForPresentErrors();
            return result.build();
        }

        private static Object toBaseType(Object object) {
            if (object == null) {
                return null;
            }
            if (object instanceof Number || object instanceof String || object instanceof Boolean) {
                return object;
            }
            if (object instanceof Collection) {
                return PlainJavaObjectAdapter.toListOfBaseType((Collection)object);
            }
            if (object instanceof DocNode) {
                return object;
            }
            if (object instanceof Map) {
                return (Map)object;
            }
            throw new RuntimeException("Unexpected type: " + object);
        }

        private static ImmutableList<Object> toListOfBaseType(Collection<?> object) {
            ImmutableList.Builder list = new ImmutableList.Builder(object.size());
            for (Object subNode : object) {
                list.add(PlainJavaObjectAdapter.toBaseType(subNode));
            }
            return list.build();
        }

        private static ImmutableList<DocNode> toListOfDocumentNode(Collection<?> object) {
            ImmutableList.Builder list = new ImmutableList.Builder(object.size());
            for (Object subNode : object) {
                list.add((Object)DocNode.wrap(subNode));
            }
            return list.build();
        }

        @Override
        public ImmutableMap<String, Object> toMap() {
            if (this.object == null) {
                return null;
            }
            if (this.object instanceof Map) {
                return OrderedImmutableMap.of((Map)MapView.stringKeysUnsafe((Map)((Map)this.object)));
            }
            return OrderedImmutableMap.of((Object)"_", (Object)this.object);
        }

        @Override
        public boolean isMap() {
            return this.object instanceof Map;
        }

        @Override
        public boolean isList(String attribute) {
            if (attribute != null && this.object instanceof Map) {
                Object object = ((Map)this.object).get(attribute);
                if (object instanceof PlainJavaObjectAdapter) {
                    object = ((PlainJavaObjectAdapter)object).object;
                }
                return object instanceof Collection;
            }
            if (attribute == null) {
                return this.object instanceof Collection;
            }
            return false;
        }

        @Override
        public boolean isList() {
            return this.object instanceof Collection;
        }

        @Override
        public int size() {
            if (this.object instanceof Map) {
                return ((Map)this.object).size();
            }
            if (this.object instanceof Collection) {
                return ((Collection)this.object).size();
            }
            if (this.object != null) {
                return 1;
            }
            return 0;
        }

        @Override
        public boolean isEmpty() {
            return this.size() == 0;
        }

        @Override
        public boolean containsKey(Object key) {
            if (this.object instanceof Map) {
                return ((Map)this.object).containsKey(key);
            }
            return false;
        }

        @Override
        public Set<String> keySet() {
            if (this.object instanceof Map) {
                return PlainJavaObjectAdapter.ensureSetOfStrings(((Map)this.object).keySet());
            }
            return ImmutableSet.empty();
        }

        @Override
        public Collection<Object> values() {
            if (this.object instanceof Map) {
                return ImmutableList.of(((Map)this.object).values());
            }
            if (this.object instanceof Collection) {
                return ImmutableList.of((Collection)((Collection)this.object));
            }
            if (this.object != null) {
                return ImmutableList.of((Object)this.object);
            }
            return ImmutableList.empty();
        }

        @Override
        public Set<Map.Entry<String, Object>> entrySet() {
            if (this.object instanceof Map) {
                Map map = (Map)this.object;
                LinkedHashSet<Map.Entry<String, Object>> result = new LinkedHashSet<Map.Entry<String, Object>>(map.size());
                for (Map.Entry entry : map.entrySet()) {
                    result.add(Maps.immutableEntry((Object)String.valueOf(entry.getKey()), entry.getValue()));
                }
                return result;
            }
            return ImmutableSet.empty();
        }

        private static Set<String> ensureSetOfStrings(Set<?> set) {
            if (PlainJavaObjectAdapter.containsOnlyStrings(set)) {
                return set;
            }
            LinkedHashSet<String> result = new LinkedHashSet<String>(set.size());
            for (String object : set) {
                if (object != null) {
                    result.add(object.toString());
                    continue;
                }
                result.add(null);
            }
            return result;
        }

        private static boolean containsOnlyStrings(Set<?> set) {
            for (Object object : set) {
                if (object instanceof String) continue;
                return false;
            }
            return true;
        }

        @Override
        public ImmutableList<Object> toList() {
            if (this.object instanceof Collection) {
                return PlainJavaObjectAdapter.toListOfBaseType((Collection)this.object);
            }
            if (this.object != null) {
                return ImmutableList.of((Object)PlainJavaObjectAdapter.toBaseType(this.object));
            }
            return ImmutableList.empty();
        }

        @Override
        public int hashCode() {
            if (this.object != null) {
                return this.object.hashCode();
            }
            return 0;
        }

        @Override
        public DocNode splitDottedAttributeNamesToTree() throws UnexpectedDocumentStructureException {
            return DocNode.wrap(PlainJavaObjectAdapter.splitDottedAttributeNamesToTree(this, null));
        }

        private static Object splitDottedAttributeNamesToTree(Object object, Map<Object, Object> mapBuilder) throws UnexpectedDocumentStructureException {
            if (object instanceof DocNode) {
                object = ((DocNode)object).toBasicObject();
            }
            if (object instanceof Collection) {
                ArrayList<Object> listBuilder = new ArrayList<Object>(((Collection)object).size());
                for (Object e : (Collection)object) {
                    listBuilder.add(PlainJavaObjectAdapter.splitDottedAttributeNamesToTree(e, null));
                }
                return listBuilder;
            }
            if (!(object instanceof Map)) {
                return object;
            }
            Map map = (Map)object;
            if (map.isEmpty()) {
                return object;
            }
            if (mapBuilder == null) {
                mapBuilder = new LinkedHashMap<Object, Object>(map.size());
            }
            for (Map.Entry entry : map.entrySet()) {
                Object existing;
                String key = String.valueOf(entry.getKey());
                Object value = entry.getValue();
                int dot = key.indexOf(46);
                if (dot == -1) {
                    LinkedHashMap subMapBuilder = null;
                    Object existing2 = mapBuilder.get(key);
                    if (existing2 instanceof Map) {
                        subMapBuilder = (LinkedHashMap)existing2;
                    } else if (existing2 instanceof Map) {
                        subMapBuilder = new LinkedHashMap((Map)existing2);
                        mapBuilder.put((Object)key, subMapBuilder);
                    }
                    mapBuilder.put((Object)key, (Object)PlainJavaObjectAdapter.splitDottedAttributeNamesToTree(value, subMapBuilder));
                    continue;
                }
                String[] parts = key.split("\\.");
                Map currentBuilder = mapBuilder;
                for (int i = 0; i < parts.length - 1; ++i) {
                    existing = currentBuilder.get(parts[i]);
                    if (existing == null) {
                        LinkedHashMap<Object, Object> subBuilder = new LinkedHashMap<Object, Object>();
                        currentBuilder.put((Object)parts[i], subBuilder);
                        currentBuilder = subBuilder;
                        continue;
                    }
                    if (existing instanceof Map) {
                        Map subMapBuilder = (Map)existing;
                        currentBuilder.put((Object)parts[i], (Object)subMapBuilder);
                        currentBuilder = subMapBuilder;
                        continue;
                    }
                    throw new UnexpectedDocumentStructureException("Dotted attributes are not well-formed: Part " + parts[i] + " of " + key + " does not fit into document tree.");
                }
                Map subMapBuilder = null;
                existing = currentBuilder.get(key);
                if (existing instanceof Map) {
                    subMapBuilder = (Map)existing;
                }
                currentBuilder.put((Object)parts[parts.length - 1], (Object)PlainJavaObjectAdapter.splitDottedAttributeNamesToTree(value, subMapBuilder));
            }
            return mapBuilder;
        }
    }
}

