/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.codova.documents;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.floragunn.codova.documents.DocumentParseException;
import com.floragunn.codova.documents.Format;
import com.floragunn.codova.documents.UnexpectedDocumentStructureException;
import com.floragunn.codova.validation.errors.ValidationError;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class DocReader {
    private final JsonParser parser;
    private final Format format;
    private final int handleDottedAttributeNamesAsPathsFromDepth;
    private final Object emptyDocumentFallback;
    private Deque<Object> nodeStack = new ArrayDeque<Object>();
    private Object currentNode;
    private Object topNode;
    private String currentAttributeName = null;

    public static DocReaderBuilder format(Format format) {
        return new DocReaderBuilder(format, format.getJsonFactory());
    }

    public static DocReaderBuilder json() {
        return DocReader.format(Format.JSON);
    }

    public static DocReaderBuilder yaml() {
        return DocReader.format(Format.YAML);
    }

    public static DocReaderBuilder smile() {
        return DocReader.format(Format.SMILE);
    }

    public DocReader(Format format, JsonParser parser, int handleDottedAttributeNamesAsPathsFromDepth, Object emptyDocumentFallback) {
        this.format = format;
        this.parser = parser;
        this.handleDottedAttributeNamesAsPathsFromDepth = handleDottedAttributeNamesAsPathsFromDepth;
        this.emptyDocumentFallback = emptyDocumentFallback;
    }

    public DocReader(Format format, JsonParser parser) {
        this.format = format;
        this.parser = parser;
        this.handleDottedAttributeNamesAsPathsFromDepth = -1;
        this.emptyDocumentFallback = null;
    }

    public Object read() throws IOException, DocumentParseException {
        int tokenCount = 0;
        try {
            JsonToken token;
            JsonToken jsonToken = token = this.parser.currentToken() != null ? this.parser.currentToken() : this.parser.nextToken();
            while (token != null) {
                ++tokenCount;
                int depth = this.nodeStack.size();
                switch (token) {
                    case START_OBJECT: {
                        if (this.currentNode != null) {
                            this.nodeStack.add(this.currentNode);
                        }
                        this.currentNode = this.addNode(new LinkedHashMap(), depth);
                        break;
                    }
                    case START_ARRAY: {
                        if (this.currentNode != null) {
                            this.nodeStack.add(this.currentNode);
                        }
                        this.currentNode = this.addNode(new ArrayList(), depth);
                        break;
                    }
                    case END_OBJECT: 
                    case END_ARRAY: {
                        if (this.nodeStack.isEmpty()) {
                            this.currentNode = null;
                            break;
                        }
                        this.currentNode = this.nodeStack.removeLast();
                        break;
                    }
                    case FIELD_NAME: {
                        this.currentAttributeName = this.parser.currentName();
                        break;
                    }
                    case VALUE_TRUE: {
                        this.addNode(Boolean.TRUE, depth);
                        break;
                    }
                    case VALUE_FALSE: {
                        this.addNode(Boolean.FALSE, depth);
                        break;
                    }
                    case VALUE_NULL: {
                        this.addNode(null, depth);
                        break;
                    }
                    case VALUE_NUMBER_FLOAT: 
                    case VALUE_NUMBER_INT: {
                        this.addNode(this.parser.getNumberValue(), depth);
                        break;
                    }
                    case VALUE_STRING: {
                        this.addNode(this.parser.getText(), depth);
                        break;
                    }
                    case VALUE_EMBEDDED_OBJECT: {
                        this.addNode(this.parser.getEmbeddedObject(), depth);
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unexpected token: " + token);
                    }
                }
                if (this.nodeStack.isEmpty() && this.currentNode == null) break;
                token = this.parser.nextToken();
            }
            this.parser.clearCurrentToken();
            if (tokenCount == 0) {
                if (this.emptyDocumentFallback == null) {
                    throw new DocumentParseException(new ValidationError(null, "The document is empty").expected(this.format.getName() + " document"));
                }
                return this.emptyDocumentFallback;
            }
            return this.topNode == null ? this.emptyDocumentFallback : this.topNode;
        }
        catch (JsonProcessingException e) {
            throw new DocumentParseException(e, this.format);
        }
    }

    private Object addNode(Object newNode, int depth) throws JsonProcessingException {
        if (this.topNode == null) {
            this.topNode = newNode;
        }
        if (this.currentNode instanceof Collection) {
            Collection collection = (Collection)this.currentNode;
            collection.add(newNode);
        } else if (this.currentNode instanceof Map) {
            if (this.currentAttributeName == null) {
                throw new JsonParseException(this.parser, "Missing attribute name");
            }
            Map map = (Map)this.currentNode;
            if (this.handleDottedAttributeNamesAsPathsFromDepth != -1 && this.handleDottedAttributeNamesAsPathsFromDepth <= depth && this.currentAttributeName.indexOf(46) != -1) {
                String[] attributePath = this.currentAttributeName.split("\\.");
                Map<String, Object> container = this.getContainer(this.currentAttributeName, map, attributePath);
                if (container.containsKey(attributePath[attributePath.length - 1])) {
                    throw new JsonParseException(this.parser, "Badly nested nodes: The sub-key " + attributePath[attributePath.length - 1] + " of " + this.currentAttributeName + " is already defined as a non-map object: " + container.get(attributePath[attributePath.length - 1]));
                }
                container.put(attributePath[attributePath.length - 1], newNode);
            } else {
                if (map.containsKey(this.currentAttributeName)) {
                    throw new JsonParseException(this.parser, "The attribute '" + this.currentAttributeName + "' is defined more than once");
                }
                map.put(this.currentAttributeName, newNode);
            }
        } else if (this.currentNode != null) {
            throw new JsonParseException(this.parser, "Node in wrong context");
        }
        this.currentAttributeName = null;
        return newNode;
    }

    private Map<String, Object> getContainer(String originalAttributeName, Map<String, Object> node, String[] attributePath) throws JsonParseException {
        for (int i = 0; i < attributePath.length - 1; ++i) {
            Object childNode = node.get(attributePath[i]);
            if (childNode == null) {
                LinkedHashMap newChildNode = new LinkedHashMap();
                node.put(attributePath[i], newChildNode);
                node = newChildNode;
                continue;
            }
            if (childNode instanceof Map) {
                node = (LinkedHashMap)childNode;
                continue;
            }
            throw new JsonParseException(this.parser, "Badly nested nodes: The sub-key " + attributePath[i] + " of " + originalAttributeName + " is already defined as a non-map object: " + childNode);
        }
        return node;
    }

    public static class DocReaderBuilder {
        private JsonFactory jsonFactory;
        private Format format;
        private int handleDottedAttributeNamesAsPathsFromDepth = -1;
        private Object emptyDocumentFallback;

        DocReaderBuilder(Format format, JsonFactory jsonFactory) {
            this.format = format;
            this.jsonFactory = jsonFactory;
        }

        public Object read(Reader in) throws DocumentParseException, IOException {
            try (JsonParser parser = this.jsonFactory.createParser(in);){
                Object object = new DocReader(this.format, parser, this.handleDottedAttributeNamesAsPathsFromDepth, this.emptyDocumentFallback).read();
                return object;
            }
        }

        public Object read(String string) throws DocumentParseException {
            Object object;
            block8: {
                JsonParser parser = this.jsonFactory.createParser(string);
                try {
                    object = new DocReader(this.format, parser, this.handleDottedAttributeNamesAsPathsFromDepth, this.emptyDocumentFallback).read();
                    if (parser == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (parser != null) {
                            try {
                                parser.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
                parser.close();
            }
            return object;
        }

        public Object read(byte[] bytes) throws DocumentParseException {
            try {
                return this.read(new ByteArrayInputStream(bytes));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public Object read(File file) throws DocumentParseException, FileNotFoundException, IOException {
            return this.read(new FileInputStream(file));
        }

        public Object read(InputStream in) throws DocumentParseException, IOException {
            try (JsonParser parser = this.jsonFactory.createParser(in);){
                Object object = new DocReader(this.format, parser, this.handleDottedAttributeNamesAsPathsFromDepth, this.emptyDocumentFallback).read();
                return object;
            }
        }

        public Map<String, Object> readObject(Reader in) throws DocumentParseException, IOException, UnexpectedDocumentStructureException {
            return DocReaderBuilder.toJsonObject(this.read(in));
        }

        public Map<String, Object> readObject(InputStream in) throws DocumentParseException, IOException, UnexpectedDocumentStructureException {
            return DocReaderBuilder.toJsonObject(this.read(in));
        }

        public Map<String, Object> readObject(String string) throws DocumentParseException, UnexpectedDocumentStructureException {
            return DocReaderBuilder.toJsonObject(this.read(string));
        }

        public Map<String, Object> readObject(byte[] bytes) throws DocumentParseException, UnexpectedDocumentStructureException {
            return DocReaderBuilder.toJsonObject(this.read(bytes));
        }

        public Map<String, Object> readObject(File file) throws UnexpectedDocumentStructureException, DocumentParseException, FileNotFoundException, IOException {
            return DocReaderBuilder.toJsonObject(this.read(new FileInputStream(file)));
        }

        private static Map<String, Object> toJsonObject(Object parsedDocument) throws UnexpectedDocumentStructureException {
            if (parsedDocument instanceof Map) {
                Map result = (Map)parsedDocument;
                return result;
            }
            throw new UnexpectedDocumentStructureException("Expected a JSON object. Got: " + (parsedDocument instanceof List ? "Array" : String.valueOf(parsedDocument)));
        }

        public DocReaderBuilder splitAttributesAtDots() {
            this.handleDottedAttributeNamesAsPathsFromDepth = 0;
            return this;
        }

        public DocReaderBuilder splitAttributesAtDotsStartingAtDepth(int handleDottedAttributeNamesAsPathsFromDepth) {
            this.handleDottedAttributeNamesAsPathsFromDepth = handleDottedAttributeNamesAsPathsFromDepth;
            return this;
        }

        public DocReaderBuilder fallbackForEmptyDocuments(Object emptyDocumentFallback) {
            this.emptyDocumentFallback = emptyDocumentFallback;
            return this;
        }
    }
}

