/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.codova.documents;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.floragunn.codova.documents.ContentType;
import com.google.common.base.Charsets;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Format {
    private static List<Format> registeredDocTypes = new ArrayList<Format>();
    private static Map<String, Format> registeredDocTypesByMediaType = new HashMap<String, Format>();
    public static Format JSON = new Format("JSON", Encoding.TEXT, new JsonFactory(), "json", "application/json", "text/x-json", "text/json", "application/vnd.elasticsearch+json");
    public static Format YAML = new Format("YAML", Encoding.TEXT, (JsonFactory)new YAMLFactory(), "ya?ml", "application/x-yaml", "application/yaml", "text/yaml", "text/x-yaml", "text/vnd.yaml");
    public static Format SMILE = new Format("SMILE", Encoding.BINARY, "com.fasterxml.jackson.dataformat.smile.SmileFactory", "sml", "application/x-jackson-smile", "application/smile");
    private final String name;
    private final String mediaType;
    private final ContentType contentType;
    private final Set<String> mediaTypeAliases;
    private final JsonFactory jsonFactory;
    private final Exception jsonFactoryUnavailabilityReason;
    private final Pattern fileNamePattern;
    private final Encoding encoding;
    private final Charset defaultCharset;

    public static Format getByContentType(String contentType) throws UnknownDocTypeException {
        Format result = Format.peekByContentType(contentType);
        if (result != null) {
            return result;
        }
        throw new UnknownDocTypeException(contentType);
    }

    public static Format peekByContentType(String contentType) {
        Format result;
        int paramSeparator = contentType.indexOf(59);
        if (paramSeparator != -1) {
            contentType = contentType.substring(0, paramSeparator).trim();
        }
        if ((result = registeredDocTypesByMediaType.get(contentType)) != null) {
            return result;
        }
        return null;
    }

    public static Format getByFileName(String fileName, Format fallbackDocType) {
        for (Format format : registeredDocTypes) {
            Matcher matcher;
            if (format.fileNamePattern == null || !(matcher = format.fileNamePattern.matcher(fileName)).matches()) continue;
            return format;
        }
        return fallbackDocType;
    }

    public static Format getByFileName(String fileName) throws UnknownDocTypeException {
        for (Format format : registeredDocTypes) {
            Matcher matcher;
            if (format.fileNamePattern == null || !(matcher = format.fileNamePattern.matcher(fileName)).matches()) continue;
            return format;
        }
        throw new UnknownDocTypeException("Could not resolve content type from file name '" + fileName + "'");
    }

    public static Format getByMediaType(String mediaType) throws UnknownDocTypeException {
        Format result = registeredDocTypesByMediaType.get(mediaType);
        if (result != null) {
            return result;
        }
        int plus = mediaType.lastIndexOf(43);
        int slash = mediaType.indexOf(47);
        if (plus != -1 && slash != -1) {
            String suffix = mediaType.substring(plus + 1);
            String prefix = mediaType.substring(0, slash);
            result = registeredDocTypesByMediaType.get(prefix + "/" + suffix);
            if (result != null) {
                return result;
            }
        }
        throw new UnknownDocTypeException(mediaType);
    }

    private static void register(Format format) {
        registeredDocTypes.add(format);
        registeredDocTypesByMediaType.put(format.getMediaType().toLowerCase(), format);
        for (String alias : format.mediaTypeAliases) {
            registeredDocTypesByMediaType.put(alias.toLowerCase(), format);
        }
    }

    public Format(String name, Encoding encoding, JsonFactory jsonFactory, String fileNameSuffixPattern, String mediaType, String ... mediaTypeAliases) {
        this.name = name;
        this.encoding = encoding;
        this.mediaType = mediaType;
        this.contentType = new ContentType(mediaType, mediaType, this, null);
        this.jsonFactory = jsonFactory;
        this.jsonFactoryUnavailabilityReason = null;
        this.mediaTypeAliases = new HashSet<String>(Arrays.asList(mediaTypeAliases));
        this.fileNamePattern = fileNameSuffixPattern != null ? Pattern.compile(".*\\." + fileNameSuffixPattern + "$", 2) : null;
        this.defaultCharset = encoding == Encoding.TEXT ? Charsets.UTF_8 : null;
        Format.register(this);
    }

    public Format(String name, Encoding encoding, String jsonFactoryClass, String fileNameSuffixPattern, String mediaType, String ... mediaTypeAliases) {
        Exception jsonFactoryUnavailabilityReason;
        JsonFactory jsonFactory;
        try {
            jsonFactory = Format.createJsonFactory(jsonFactoryClass);
            jsonFactoryUnavailabilityReason = null;
        }
        catch (Exception e) {
            jsonFactory = null;
            jsonFactoryUnavailabilityReason = e;
        }
        this.name = name;
        this.encoding = encoding;
        this.mediaType = mediaType;
        this.contentType = new ContentType(mediaType, mediaType, this, null);
        this.jsonFactory = jsonFactory;
        this.jsonFactoryUnavailabilityReason = jsonFactoryUnavailabilityReason;
        this.mediaTypeAliases = new HashSet<String>(Arrays.asList(mediaTypeAliases));
        this.fileNamePattern = fileNameSuffixPattern != null ? Pattern.compile(".*\\." + fileNameSuffixPattern + "$", 2) : null;
        this.defaultCharset = encoding == Encoding.TEXT ? Charsets.UTF_8 : null;
        Format.register(this);
    }

    public String getMediaType() {
        return this.mediaType;
    }

    public ContentType getContentType() {
        return this.contentType;
    }

    public JsonFactory getJsonFactory() {
        if (this.jsonFactory != null) {
            return this.jsonFactory;
        }
        throw new RuntimeException("Support for " + this.name + " is not available", this.jsonFactoryUnavailabilityReason);
    }

    public Set<String> getContentTypeAliases() {
        return this.mediaTypeAliases;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    public boolean isBinary() {
        return this.encoding == Encoding.BINARY;
    }

    public Charset getDefaultCharset() {
        return this.defaultCharset;
    }

    private static JsonFactory createJsonFactory(String name) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException, ClassNotFoundException {
        Class<?> clazz = Class.forName(name);
        return (JsonFactory)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
    }

    public static enum Encoding {
        TEXT,
        BINARY;

    }

    public static class UnknownDocTypeException
    extends Exception {
        private static final long serialVersionUID = -3964199452899731782L;

        public UnknownDocTypeException(String contentType) {
            super("Unknown content type: " + contentType);
        }
    }
}

