/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchsupport.queries;

import com.floragunn.codova.documents.Document;
import com.floragunn.codova.validation.ConfigValidationException;
import com.floragunn.codova.validation.errors.ValidationError;
import com.floragunn.searchsupport.xcontent.XContentParserContext;
import org.elasticsearch.common.Strings;
import org.elasticsearch.index.query.AbstractQueryBuilder;
import org.elasticsearch.index.query.MatchNoneQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.xcontent.DeprecationHandler;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentParserConfiguration;
import org.elasticsearch.xcontent.json.JsonXContent;

public class Query
implements Document<Query> {
    public static final Query MATCH_NONE = new Query((QueryBuilder)new MatchNoneQueryBuilder());
    private final QueryBuilder queryBuilder;
    private final String source;

    public Query(String source, XContentParserContext context) throws ConfigValidationException {
        try {
            this.source = source;
            XContentParser parser = JsonXContent.jsonXContent.createParser(XContentParserConfiguration.EMPTY.withRegistry(context.xContentRegistry()).withDeprecationHandler(DeprecationHandler.THROW_UNSUPPORTED_OPERATION), source);
            this.queryBuilder = AbstractQueryBuilder.parseTopLevelQuery((XContentParser)parser);
        }
        catch (Exception e) {
            throw new ConfigValidationException(new ValidationError(null, e.getMessage()).cause((Throwable)e));
        }
    }

    public Query(QueryBuilder queryBuilder) {
        this.queryBuilder = queryBuilder;
        this.source = Strings.toString((ToXContent)queryBuilder);
    }

    public Object toBasicObject() {
        return this.source;
    }

    public String toString() {
        return this.source;
    }

    public QueryBuilder getQueryBuilder() {
        return this.queryBuilder;
    }
}

