/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.enterprise.femt.datamigration880.service;

import com.floragunn.fluent.collections.ImmutableList;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.ExecutionStatus;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.IndexAlreadyExistsException;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.MigrationConfig;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.MigrationExecutionSummary;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.MigrationStateRepository;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.MigrationStep;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.MigrationStepsExecutor;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.OptimisticLockException;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.StepExecutionStatus;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.StepExecutionSummary;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.steps.StepsFactory;
import com.floragunn.searchsupport.action.StandardResponse;
import java.time.Clock;
import java.time.LocalDateTime;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DataMigrationService {
    private static final Logger log = LogManager.getLogger(DataMigrationService.class);
    public static final String STAGE_NAME_PRECONDITIONS = "preconditions check";
    private final MigrationStateRepository migrationStateRepository;
    private final StepsFactory stepsFactory;
    private final Clock clock;

    public DataMigrationService(MigrationStateRepository migrationStateRepository, StepsFactory stepsFactory, Clock clock) {
        this.migrationStateRepository = Objects.requireNonNull(migrationStateRepository, "Migration state repository is required");
        this.stepsFactory = Objects.requireNonNull(stepsFactory, "Step factory is required");
        this.clock = Objects.requireNonNull(clock, "Clock is required");
    }

    public DataMigrationService(MigrationStateRepository migrationStateRepository, StepsFactory stepsFactory) {
        this(migrationStateRepository, stepsFactory, Clock.systemUTC());
    }

    public StandardResponse migrateData(MigrationConfig config) {
        Objects.requireNonNull(config, "Migration config is required");
        try {
            if (!this.migrationStateRepository.isIndexCreated()) {
                this.migrationStateRepository.createIndex();
            }
            return this.findDataMigrationState().map(summary -> this.restartMigration(config, (MigrationExecutionSummary)summary)).orElseGet(() -> this.performFirstMigrationStart(config));
        }
        catch (IndexAlreadyExistsException e) {
            String message = "Cannot create index to store migration related data./\nPossibly another data migration process was started in parallel.\n".trim();
            return this.errorResponse(409, StepExecutionStatus.STATUS_INDEX_ALREADY_EXISTS_ERROR, message, (Throwable)((Object)e));
        }
    }

    public Optional<MigrationExecutionSummary> findDataMigrationState() {
        return this.migrationStateRepository.findById("migration_8_8_0");
    }

    private StandardResponse executeMigrationSteps(MigrationConfig config) {
        MigrationStepsExecutor executor;
        MigrationExecutionSummary summary;
        Objects.requireNonNull(config, "Migration config is required");
        ImmutableList<MigrationStep> steps = this.stepsFactory.createSteps();
        if (log.isInfoEnabled()) {
            log.info("Front-end data migration step execution order: '{}'", (Object)steps.stream().map(MigrationStep::name).collect(Collectors.joining(", ")));
        }
        int httpStatus = (summary = (executor = new MigrationStepsExecutor(config, this.migrationStateRepository, this.clock, steps)).execute()).isSuccessful() ? 200 : 500;
        return new StandardResponse(httpStatus).data((Object)summary);
    }

    private StandardResponse performFirstMigrationStart(MigrationConfig config) {
        Objects.requireNonNull(config, "Migration config is required");
        LocalDateTime now = LocalDateTime.now(this.clock);
        MigrationExecutionSummary summary = this.migrationStartedSummary(now, "The first start of data migration process");
        try {
            this.migrationStateRepository.create("migration_8_8_0", summary);
            return this.executeMigrationSteps(config);
        }
        catch (OptimisticLockException e) {
            String message = "Another migration process has just been started.";
            return this.errorResponse(412, StepExecutionStatus.CANNOT_CREATE_STATUS_DOCUMENT_ERROR, message, (Throwable)((Object)e));
        }
    }

    private StandardResponse restartMigration(MigrationConfig config, MigrationExecutionSummary migrationSummary) {
        LocalDateTime now = LocalDateTime.now(this.clock);
        if (migrationSummary.isMigrationInProgress(now)) {
            String message = "Data migration started previously at " + String.valueOf(migrationSummary.startTime()) + " is already in progress. Cannot run more than one migration process at the time.";
            return this.errorResponse(400, StepExecutionStatus.MIGRATION_ALREADY_IN_PROGRESS_ERROR, message, null);
        }
        MigrationExecutionSummary restartedMigration = this.migrationStartedSummary(now, "Migration restarted");
        try {
            this.migrationStateRepository.updateWithLock("migration_8_8_0", restartedMigration, migrationSummary.lockData());
            return this.executeMigrationSteps(config);
        }
        catch (OptimisticLockException ex) {
            String errorMessage = "Another instance of data migration process is just starting, aborting.";
            return this.errorResponse(409, StepExecutionStatus.CANNOT_UPDATE_STATUS_DOCUMENT_LOCK_ERROR, errorMessage, (Throwable)((Object)ex));
        }
    }

    private MigrationExecutionSummary migrationStartedSummary(LocalDateTime now, String message) {
        StepExecutionSummary preconditionStage = new StepExecutionSummary(0L, now, STAGE_NAME_PRECONDITIONS, StepExecutionStatus.OK, message);
        ImmutableList stages = ImmutableList.of((Object)preconditionStage);
        return new MigrationExecutionSummary(now, ExecutionStatus.IN_PROGRESS, null, null, (ImmutableList<StepExecutionSummary>)stages);
    }

    private StandardResponse errorResponse(int httpStatus, StepExecutionStatus status, String message, Throwable ex) {
        LocalDateTime now = LocalDateTime.now(this.clock);
        ImmutableList stages = ImmutableList.of((Object)new StepExecutionSummary(0L, now, STAGE_NAME_PRECONDITIONS, status, message, ex));
        MigrationExecutionSummary summary = new MigrationExecutionSummary(now, ExecutionStatus.FAILURE, null, null, (ImmutableList<StepExecutionSummary>)stages);
        return new StandardResponse(httpStatus).data((Object)summary);
    }
}

