/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.enterprise.dlsfls.lucene;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.floragunn.codova.documents.DocumentParseException;
import com.floragunn.codova.documents.Format;
import com.floragunn.fluent.collections.ImmutableSet;
import com.floragunn.searchguard.enterprise.dlsfls.RoleBasedFieldAuthorization;
import com.floragunn.searchguard.enterprise.dlsfls.RoleBasedFieldMasking;
import com.floragunn.searchguard.enterprise.dlsfls.lucene.DlsFlsActionContext;
import com.floragunn.searchsupport.dfm.MaskedFieldsConsumer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.StoredFieldVisitor;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.indices.IndicesModule;

class FlsStoredFieldVisitor
extends StoredFieldVisitor {
    private static final Logger log = LogManager.getLogger(FlsStoredFieldVisitor.class);
    private static final ImmutableSet<String> META_FIELDS = ImmutableSet.of((Collection)IndicesModule.getBuiltInMetadataFields()).with((Object)"_primary_term");
    private final StoredFieldVisitor delegate;
    private final DlsFlsActionContext dlsFlsContext;
    private final RoleBasedFieldAuthorization.FlsRule flsRule;
    private final RoleBasedFieldMasking.FieldMaskingRule fieldMaskingRule;

    public FlsStoredFieldVisitor(StoredFieldVisitor delegate, DlsFlsActionContext dlsFlsContext) {
        this.delegate = delegate;
        this.dlsFlsContext = dlsFlsContext;
        this.flsRule = dlsFlsContext.getFlsRule();
        this.fieldMaskingRule = dlsFlsContext.getFieldMaskingRule();
        if (log.isDebugEnabled()) {
            log.debug("Created FlsStoredFieldVisitor for " + String.valueOf(this.flsRule) + "; " + String.valueOf(this.fieldMaskingRule));
        }
    }

    public void binaryField(FieldInfo fieldInfo, byte[] value) throws IOException {
        if (fieldInfo.name.equals("_source")) {
            try {
                if (this.delegate instanceof MaskedFieldsConsumer) {
                    ((MaskedFieldsConsumer)this.delegate).binaryMaskedField(fieldInfo, DocumentFilter.filter(Format.JSON, value, this.flsRule, this.fieldMaskingRule), f -> this.fieldMaskingRule != null && this.fieldMaskingRule.get((String)f) != null);
                }
                this.delegate.binaryField(fieldInfo, DocumentFilter.filter(Format.JSON, value, this.flsRule, this.fieldMaskingRule));
            }
            catch (DocumentParseException e) {
                throw new ElasticsearchException("Cannot filter source of document", (Throwable)e, new Object[0]);
            }
        } else {
            this.delegate.binaryField(fieldInfo, value);
        }
    }

    public StoredFieldVisitor.Status needsField(FieldInfo fieldInfo) throws IOException {
        return META_FIELDS.contains((Object)fieldInfo.name) || this.dlsFlsContext.isAllowed(fieldInfo.name) ? this.delegate.needsField(fieldInfo) : StoredFieldVisitor.Status.NO;
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public void stringField(FieldInfo fieldInfo, String value) throws IOException {
        RoleBasedFieldMasking.FieldMaskingRule.Field field = this.fieldMaskingRule.get(fieldInfo.name);
        if (field != null) {
            if (this.delegate instanceof MaskedFieldsConsumer) {
                ((MaskedFieldsConsumer)this.delegate).stringMaskedField(fieldInfo, field.apply(value));
            } else {
                this.delegate.stringField(fieldInfo, field.apply(value));
            }
        } else {
            this.delegate.stringField(fieldInfo, value);
        }
    }

    public void intField(FieldInfo fieldInfo, int value) throws IOException {
        this.delegate.intField(fieldInfo, value);
    }

    public void longField(FieldInfo fieldInfo, long value) throws IOException {
        this.delegate.longField(fieldInfo, value);
    }

    public void floatField(FieldInfo fieldInfo, float value) throws IOException {
        this.delegate.floatField(fieldInfo, value);
    }

    public void doubleField(FieldInfo fieldInfo, double value) throws IOException {
        this.delegate.doubleField(fieldInfo, value);
    }

    public boolean equals(Object obj) {
        return this.delegate.equals(obj);
    }

    public String toString() {
        return this.delegate.toString();
    }

    static class DocumentFilter {
        private final JsonParser parser;
        private final JsonGenerator generator;
        private final RoleBasedFieldAuthorization.FlsRule flsRule;
        private final RoleBasedFieldMasking.FieldMaskingRule fieldMaskingRule;
        private String queuedFieldName;
        private String fullCurrentName;
        private String fullParentName;
        private Deque<String> nameStack = new ArrayDeque<String>();

        public static byte[] filter(Format format, byte[] bytes, RoleBasedFieldAuthorization.FlsRule flsRule, RoleBasedFieldMasking.FieldMaskingRule fieldMaskingRule) throws DocumentParseException, IOException {
            try (ByteArrayInputStream in = new ByteArrayInputStream(bytes);){
                byte[] byArray;
                try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
                    DocumentFilter.filter(format, in, out, flsRule, fieldMaskingRule);
                    byArray = out.toByteArray();
                }
                return byArray;
            }
        }

        public static void filter(Format format, InputStream in, OutputStream out, RoleBasedFieldAuthorization.FlsRule flsRule, RoleBasedFieldMasking.FieldMaskingRule fieldMaskingRule) throws DocumentParseException, IOException {
            try (JsonParser parser = format.getJsonFactory().createParser(in);
                 JsonGenerator generator = format.getJsonFactory().createGenerator(out);){
                new DocumentFilter(parser, generator, flsRule, fieldMaskingRule).copy();
            }
        }

        DocumentFilter(JsonParser parser, JsonGenerator generator, RoleBasedFieldAuthorization.FlsRule flsRule, RoleBasedFieldMasking.FieldMaskingRule fieldMaskingRule) {
            this.parser = parser;
            this.generator = generator;
            this.flsRule = flsRule;
            this.fieldMaskingRule = fieldMaskingRule;
        }

        /*
         * Unable to fully structure code
         */
        private void copy() throws IOException {
            v0 = token = this.parser.currentToken() != null ? this.parser.currentToken() : this.parser.nextToken();
            while (token != null) {
                if (this.queuedFieldName == null) ** GOTO lbl14
                startOfObjectOrArray = token == JsonToken.START_OBJECT || token == JsonToken.START_ARRAY;
                fullQueuedFieldName = this.fullParentName == null ? this.queuedFieldName : this.fullParentName + "." + this.queuedFieldName;
                this.queuedFieldName = null;
                if (!(FlsStoredFieldVisitor.META_FIELDS.contains((Object)fullQueuedFieldName) || this.flsRule.isAllowedAssumingParentsAreAllowed(fullQueuedFieldName) || startOfObjectOrArray && this.flsRule.isObjectAllowedAssumingParentsAreAllowed(fullQueuedFieldName))) {
                    if (startOfObjectOrArray) {
                        this.parser.skipChildren();
                    }
                } else {
                    this.generator.writeFieldName(this.parser.currentName());
                    this.fullCurrentName = fullQueuedFieldName;
lbl14:
                    // 2 sources

                    switch (1.$SwitchMap$com$fasterxml$jackson$core$JsonToken[token.ordinal()]) {
                        case 1: {
                            this.queuedFieldName = this.parser.currentName();
                            break;
                        }
                        case 2: {
                            this.generator.writeStartObject();
                            if (this.fullParentName != null) {
                                this.nameStack.add(this.fullParentName);
                            }
                            this.fullParentName = this.fullCurrentName;
                            break;
                        }
                        case 3: {
                            this.generator.writeEndObject();
                            this.fullCurrentName = this.fullParentName;
                            if (this.nameStack.isEmpty()) {
                                this.fullParentName = null;
                                break;
                            }
                            this.fullParentName = this.nameStack.removeLast();
                            break;
                        }
                        case 4: {
                            this.generator.writeStartArray();
                            break;
                        }
                        case 5: {
                            this.generator.writeEndArray();
                            break;
                        }
                        case 6: {
                            this.generator.writeBoolean(Boolean.TRUE.booleanValue());
                            break;
                        }
                        case 7: {
                            this.generator.writeBoolean(Boolean.FALSE.booleanValue());
                            break;
                        }
                        case 8: {
                            this.generator.writeNull();
                            break;
                        }
                        case 9: {
                            this.generator.writeNumber(this.parser.getDecimalValue());
                            break;
                        }
                        case 10: {
                            this.generator.writeNumber(this.parser.getBigIntegerValue());
                            break;
                        }
                        case 11: {
                            field = this.fieldMaskingRule.get(this.fullCurrentName);
                            if (field != null) {
                                this.generator.writeString(field.apply(this.parser.getText()));
                                break;
                            }
                            this.generator.writeString(this.parser.getText());
                            break;
                        }
                        case 12: {
                            this.generator.writeEmbeddedObject(this.parser.getEmbeddedObject());
                            break;
                        }
                        default: {
                            throw new IllegalStateException("Unexpected token: " + String.valueOf(token));
                        }
                    }
                }
                token = this.parser.nextToken();
            }
        }
    }
}

