/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.rest;

import com.floragunn.fluent.collections.ImmutableSet;
import com.floragunn.searchguard.authz.AuthorizationService;
import com.floragunn.searchguard.authz.TenantAccessMapper;
import com.floragunn.searchguard.configuration.AdminDNs;
import com.floragunn.searchguard.support.Base64Helper;
import com.floragunn.searchguard.user.User;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;

public class SearchGuardInfoAction
extends BaseRestHandler {
    private final Logger log = LogManager.getLogger(((Object)((Object)this)).getClass());
    private final AuthorizationService authorizationService;
    private final TenantAccessMapper tenantAccessMapper;
    private final ThreadContext threadContext;
    private final ClusterService clusterService;
    private final AdminDNs adminDNs;

    public SearchGuardInfoAction(Settings settings, RestController controller, AuthorizationService authorizationService, TenantAccessMapper tenantAccessMapper, ThreadPool threadPool, ClusterService clusterService, AdminDNs adminDNs) {
        this.threadContext = threadPool.getThreadContext();
        this.tenantAccessMapper = tenantAccessMapper;
        this.clusterService = clusterService;
        this.authorizationService = authorizationService;
        this.adminDNs = adminDNs;
    }

    public List<RestHandler.Route> routes() {
        return ImmutableList.of((Object)new RestHandler.Route(RestRequest.Method.GET, "/_searchguard/authinfo"), (Object)new RestHandler.Route(RestRequest.Method.POST, "/_searchguard/authinfo"));
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(final RestRequest request, NodeClient client) throws IOException {
        return new BaseRestHandler.RestChannelConsumer(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void accept(RestChannel channel) throws Exception {
                RestResponse response = null;
                try (XContentBuilder builder = channel.newBuilder();){
                    boolean verbose = request.paramAsBoolean("verbose", false);
                    X509Certificate[] certs = (X509Certificate[])SearchGuardInfoAction.this.threadContext.getTransient("_sg_ssl_peer_certificates");
                    User user = (User)SearchGuardInfoAction.this.threadContext.getTransient("_sg_user");
                    TransportAddress remoteAddress = (TransportAddress)SearchGuardInfoAction.this.threadContext.getTransient("_sg_remote_address");
                    ImmutableSet<String> sgRoles = ImmutableSet.empty();
                    boolean adminUser = false;
                    if (user != null && !(adminUser = SearchGuardInfoAction.this.adminDNs.isAdmin(user))) {
                        try {
                            sgRoles = SearchGuardInfoAction.this.authorizationService.getMappedRoles(user, remoteAddress);
                        }
                        catch (Exception e) {
                            SearchGuardInfoAction.this.log.warn("Error while evaluating roles for user " + String.valueOf(user), (Throwable)e);
                        }
                    }
                    builder.startObject();
                    builder.field("user", user == null ? null : user.toString());
                    builder.field("user_name", user == null ? null : user.getName());
                    builder.field("user_requested_tenant", user == null ? null : user.getRequestedTenant());
                    builder.field("remote_address", (ToXContent)remoteAddress);
                    builder.field("backend_roles", user == null ? null : user.getRoles());
                    builder.field("attribute_names", user == null ? null : user.getStructuredAttributes().keySet());
                    builder.field("sg_roles", sgRoles);
                    builder.field("sg_tenants", user == null ? null : SearchGuardInfoAction.this.tenantAccessMapper.mapTenantsAccess(user, adminUser, (Set<String>)sgRoles));
                    builder.field("principal", (String)SearchGuardInfoAction.this.threadContext.getTransient("_sg_ssl_principal"));
                    builder.field("peer_certificates", (String)(certs != null && certs.length > 0 ? "" + certs.length : "0"));
                    String ssoLogoutUrl = (String)SearchGuardInfoAction.this.threadContext.getTransient("_sg_sso_logout_url");
                    if (ssoLogoutUrl != null) {
                        builder.field("sso_logout_url", ssoLogoutUrl);
                    }
                    builder.field("cluster_name", SearchGuardInfoAction.this.clusterService.getClusterName().value());
                    if (user != null && verbose) {
                        try {
                            builder.field("size_of_user", RamUsageEstimator.humanReadableUnits((long)Base64Helper.serializeObject(user).length()));
                            builder.field("size_of_attributes", RamUsageEstimator.humanReadableUnits((long)Base64Helper.serializeObject((Serializable)((Object)user.getStructuredAttributes())).getBytes(StandardCharsets.UTF_8).length));
                            builder.field("size_of_backendroles", RamUsageEstimator.humanReadableUnits((long)Base64Helper.serializeObject((Serializable)((Object)user.getRoles())).getBytes(StandardCharsets.UTF_8).length));
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                    builder.endObject();
                    response = new RestResponse(RestStatus.OK, builder);
                }
                channel.sendResponse(response);
            }
        };
    }

    public String getName() {
        return "Search Guard Info Action";
    }
}

